set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4005977';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-8-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      '2343430',
      NULL,
      0.957853,
      0,
      3,
      '1330',
      NULL,
      0.788699,
      NULL,
      NULL,
      ' 9-21-1988',
      NULL,
      NULL,
      1.345164,
      NULL,
      NULL,
      ' 2- 0-1978',
      NULL,
      NULL,
      290.598419,
      NULL,
      0.037923,
      '10- 3-1991',
      ' 5- 6-1989',
      ' 0- 4-1974',
      1,
      2.259389,
      NULL,
      1.138017,
      NULL,
      1,
      12.510632,
      1.265577,
      1,
      183,
      NULL,
      6,
      NULL,
      NULL,
      18,
      NULL,
      10,
      1.199806,
      0.222369,
      7,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.787780,
      1,
      3.429182,
      3.580539,
      NULL,
      11,
      1,
      NULL,
      0.972456,
      2,
      0,
      1,
      1,
      0,
      1.633202,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.633313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.961447,
      1,
      0,
      1,
      NULL,
      0,
      2,
      NULL,
      NULL,
      3.850811,
      2,
      0.154270,
      NULL,
      0,
      1.358177,
      2,
      0,
      NULL,
      0.884606,
      0.163073,
      0,
      1,
      4,
      0,
      3.119211,
      0.689635,
      NULL,
      NULL,
      NULL,
      1.851532,
      NULL,
      NULL,
      0.397929,
      0,
      0,
      1,
      0,
      0.878626,
      5.249161,
      NULL,
      0.199279,
      1,
      2,
      1,
      1,
      3,
      0.822828,
      0.190401,
      0,
      0.312756,
      1.369508,
      NULL,
      0.410226,
      0.740623,
      1,
      1,
      0.262867,
      NULL,
      4,
      6.811576,
      1,
      7,
      5,
      NULL,
      1,
      NULL,
      NULL,
      5.484787,
      5,
      NULL,
      7,
      1.936067,
      10.204942,
      4,
      10,
      NULL,
      NULL,
      1.357083,
      NULL,
      1,
      ' 2- 8-1978',
      NULL,
      ' 7- 9-2001',
      633.190911,
      2,
      NULL,
      0,
      NULL,
      0.356671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.902029,
      0,
      NULL,
      1.944466,
      1,
      3.429721,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      0.776374,
      0.911323,
      1,
      1.664068,
      3.866621,
      NULL,
      5,
      1,
      3,
      0.693779,
      1,
      0,
      1,
      0.224192,
      3,
      1,
      NULL,
      3.481465,
      1.226808,
      0,
      NULL,
      NULL,
      2,
      0,
      1.823514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      0.090268,
      1,
      1,
      1,
      NULL,
      68.343567,
      1.082479,
      1.750342,
      29.073948,
      NULL,
      NULL,
      2,
      0,
      0.493117,
      2.386982,
      NULL,
      NULL,
      0.739548,
      1,
      0.355536,
      1,
      0,
      0.734062,
      NULL,
      NULL,
      1,
      2.888156,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      1.438315,
      NULL,
      1,
      1.234266,
      1.674531,
      1.462779,
      NULL,
      1,
      3.208674,
      1,
      8,
      6,
      2,
      1.597625,
      4.990250,
      3,
      3.716867,
      2,
      3.230715,
      1,
      0.484068,
      3,
      NULL,
      3,
      NULL,
      NULL,
      20,
      2.521653,
      48,
      3,
      0.524325,
      1,
      '40011',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0.866300,
      '',
      NULL,
      NULL,
      2,
      10,
      355,
      37.469250,
      1,
      NULL,
      NULL,
      4,
      2.789940,
      2,
      3,
      2,
      NULL,
      NULL,
      NULL,
      0.662530,
      NULL,
      2.029307,
      0.373456,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.930834,
      NULL,
      1,
      2.866737,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.909429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8,
      1,
      2.865165,
      1.487832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.938429,
      3.153927,
      0.401573,
      1.705280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2.322335,
      3.860306,
      2.090735,
      0.983596,
      2,
      2.643015,
      0,
      0,
      3.990926,
      2,
      1.498839,
      1.692179,
      NULL,
      NULL,
      NULL,
      0.776633,
      NULL,
      NULL,
      0.872344,
      NULL,
      NULL,
      5,
      NULL,
      5.455435,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.879429,
      NULL,
      NULL,
      0.613683,
      NULL,
      NULL,
      1.254585,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.921701,
      2,
      0,
      0,
      NULL,
      1.122272,
      3.710479,
      1,
      NULL,
      NULL,
      1.627995,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.075159,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.975436,
      1.027382,
      1.129291,
      1,
      7,
      NULL,
      1.178632,
      5,
      0.636558,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      3,
      2,
      1.521865,
      3.290070,
      2,
      1,
      2,
      11.495414,
      1,
      3,
      2,
      1,
      3.705022,
      2.192460,
      1,
      1.083930,
      3.135839,
      1,
      1,
      0.031090,
      NULL,
      NULL,
      4.254320,
      2.317726,
      6.735090,
      0,
      0,
      2.189321,
      2.089003,
      NULL,
      6.149336,
      1.763486,
      NULL,
      0.100573,
      0,
      0.919769,
      1,
      NULL,
      NULL,
      1.127356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.279001,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.003439,
      NULL,
      NULL,
      0.169309,
      NULL,
      NULL,
      2.726639,
      1.850154,
      NULL,
      1,
      0,
      2.538895,
      1.274796,
      NULL,
      NULL,
      8.327256,
      NULL,
      NULL,
      NULL,
      113.758847,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.142519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.806169,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.857424,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7.689873,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.056636,
      177.877724,
      298.435452,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      171.905132,
      45,
      0,
      0.629033,
      1.533323,
      0.685172,
      0,
      NULL,
      1.315745,
      0.339651,
      0.741946,
      1,
      0,
      1.654719,
      0.943353,
      0,
      NULL,
      1.658265,
      0,
      1.507506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.275222,
      2,
      0.265357,
      5,
      1.966883,
      4.774094,
      NULL,
      1.881855,
      7,
      2,
      2,
      1,
      1.861255,
      1.361887,
      NULL,
      0.793212,
      1.895962,
      NULL,
      1,
      3,
      NULL,
      0,
      1.135833,
      NULL,
      1.704602,
      2,
      NULL,
      0.327311,
      NULL,
      NULL,
      1.843037,
      2.417393,
      NULL,
      0,
      1,
      NULL,
      1.898358,
      0.902224,
      NULL,
      1.550086,
      0.522253,
      NULL,
      NULL,
      1.931321,
      NULL,
      NULL,
      0,
      1.835772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.313223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.815958,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      8.255285,
      NULL,
      1.847169,
      1.451435,
      3.110551,
      19.138391,
      79.887588,
      1.603049,
      0.910239,
      2,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


