set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6015584';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-8-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '2224231',
      NULL,
      0.315405,
      1,
      3,
      '3232',
      1.589595,
      0.732334,
      NULL,
      NULL,
      ' 6-22-1984',
      0,
      NULL,
      7,
      0,
      0,
      ' 0- 3-2000',
      97,
      1.645143,
      323.369071,
      58,
      2,
      ' 3-19-1997',
      ' 7- 7-1991',
      NULL,
      1.649872,
      NULL,
      2,
      0,
      1.674010,
      3,
      1.776405,
      1,
      1,
      26,
      7.048048,
      17.854216,
      7,
      NULL,
      187.338846,
      6.180081,
      NULL,
      5.991106,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      6.534738,
      NULL,
      4.037018,
      NULL,
      NULL,
      1.204861,
      0,
      1,
      2,
      1.209475,
      0,
      0.188237,
      0,
      1,
      2.554954,
      0,
      2,
      0,
      1.287452,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.061689,
      1,
      1,
      0.201170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.172824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.703495,
      NULL,
      9,
      NULL,
      7,
      0.866181,
      2.530037,
      0,
      1.674176,
      1.827319,
      NULL,
      NULL,
      1,
      0.868656,
      0,
      0,
      0,
      1.592630,
      1,
      NULL,
      0.077995,
      1,
      0,
      0,
      1,
      0,
      NULL,
      3.009796,
      1.584775,
      0.675036,
      NULL,
      2,
      3.239454,
      3.937630,
      NULL,
      NULL,
      NULL,
      0,
      7,
      3.035857,
      3.910455,
      8,
      10.247493,
      10,
      NULL,
      1,
      2.819609,
      2,
      '11-25-1996',
      433.871846,
      '11- 3-1997',
      47,
      NULL,
      1.711644,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.750516,
      1.578111,
      1.316420,
      0,
      NULL,
      0,
      1.875915,
      0.192998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.501573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.273375,
      1,
      6,
      1,
      1.139404,
      3.644753,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.620846,
      0.302849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.784432,
      1,
      1.560781,
      NULL,
      0,
      1,
      0,
      2,
      NULL,
      3.300874,
      0.108699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.165344,
      5,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.035872,
      2,
      1.665014,
      0.808387,
      NULL,
      67,
      NULL,
      NULL,
      NULL,
      8.727501,
      NULL,
      20.605074,
      4.450957,
      1.774524,
      0.988741,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0.611162,
      '',
      '',
      NULL,
      3,
      25,
      25,
      1.681472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.015330,
      2.886569,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.788444,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.591865,
      3.953769,
      1.779298,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.266957,
      NULL,
      NULL,
      0.171441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.624596,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.238603,
      NULL,
      NULL,
      0.124877,
      NULL,
      NULL,
      0.091007,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.450662,
      NULL,
      NULL,
      0,
      1.133235,
      3,
      2,
      3.258965,
      1.342832,
      0.629200,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.723756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.832125,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.127828,
      3.184896,
      3.325156,
      1.149491,
      NULL,
      NULL,
      3.909080,
      3.834910,
      NULL,
      3.662217,
      NULL,
      NULL,
      3.597147,
      NULL,
      1.473399,
      2,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.888726,
      4.248838,
      NULL,
      NULL,
      0.309364,
      NULL,
      3,
      3.804782,
      2.476680,
      0.777595,
      2,
      3.571645,
      2.777986,
      3.330354,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.575390,
      NULL,
      0.455274,
      1,
      0,
      1,
      0.558450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.208314,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.895899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.301504,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.712619,
      1.914681,
      0.063541,
      1.970874,
      NULL,
      NULL,
      1.671307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.793077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.995301,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.183627,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.109289,
      NULL,
      NULL,
      0.154243,
      NULL,
      NULL,
      1.848997,
      NULL,
      0,
      NULL,
      1527.403974,
      0.444480,
      1,
      1,
      0.116516,
      0.776620,
      NULL,
      1,
      1.041914,
      0.663993,
      1,
      NULL,
      1.883743,
      0.303381,
      NULL,
      1.559349,
      0,
      0.980895,
      1.054482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.321189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.568792,
      NULL,
      0.534300,
      14,
      NULL,
      NULL,
      8.344435,
      8,
      NULL,
      19,
      3.892075,
      NULL,
      3.127690,
      14,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      12.516161,
      NULL,
      8.706861,
      12,
      NULL,
      11.090206,
      19.758169,
      NULL,
      16.481690,
      13.364447,
      NULL,
      13,
      NULL,
      NULL,
      3.712607,
      8.289113,
      NULL,
      0.924026,
      1.121234,
      0.167029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.835189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.156144,
      NULL,
      0.162068,
      NULL,
      1,
      NULL,
      5.072511,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      28,
      NULL,
      NULL,
      0,
      NULL,
      '01410',
      '',
      '',
      0,
      NULL,
      '',
      '',
      1.014280,
      '',
      '',
      '');
commit;
end;
/


