set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9132494';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-11-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      '3414',
      2.084120,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 9-2002',
      NULL,
      4.343676,
      181,
      87,
      2,
      ' 0- 4-1997',
      ' 0- 4-1976',
      ' 2-13-1998',
      NULL,
      NULL,
      2,
      0.650807,
      1.026980,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.290554,
      NULL,
      1.713480,
      23,
      7,
      10.357657,
      3.557547,
      NULL,
      2.497303,
      1,
      0.976801,
      0,
      1,
      0,
      0,
      0,
      0.868038,
      1,
      1,
      0,
      NULL,
      1.288444,
      4.359596,
      0,
      3,
      NULL,
      NULL,
      1.652764,
      0,
      0.054550,
      0,
      0.747782,
      1,
      0,
      0.997664,
      1,
      2,
      0.319734,
      0.006548,
      0.330148,
      0,
      1.300532,
      NULL,
      NULL,
      0.988393,
      NULL,
      NULL,
      0.181057,
      0.081322,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.975618,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      5,
      1.082658,
      0.526595,
      0,
      1.037876,
      NULL,
      NULL,
      0,
      1.596370,
      1.092488,
      0,
      1,
      1.187856,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      4.571873,
      NULL,
      0,
      7,
      NULL,
      10,
      5.622683,
      NULL,
      4,
      6,
      4,
      11,
      0.610924,
      6,
      NULL,
      NULL,
      7,
      5.680897,
      2.994984,
      NULL,
      0.186726,
      3.898590,
      1.481621,
      1.096686,
      '11- 9-1980',
      NULL,
      ' 8- 5-1995',
      NULL,
      2.586861,
      0.490541,
      1.899352,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.106940,
      1,
      1.537813,
      0,
      1,
      NULL,
      0.834417,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.670289,
      1,
      0,
      NULL,
      0.341826,
      0.535022,
      0.787475,
      NULL,
      NULL,
      NULL,
      1,
      0.262717,
      1.912423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.653414,
      1.749643,
      0.830335,
      0,
      NULL,
      13,
      0,
      0.875452,
      NULL,
      NULL,
      NULL,
      0.365959,
      1,
      0,
      1,
      0.604151,
      3.124615,
      NULL,
      3.893476,
      1.482178,
      0,
      2,
      2.531032,
      3.637002,
      NULL,
      2.542425,
      0,
      1.902377,
      NULL,
      0,
      0.853177,
      0,
      0,
      0,
      NULL,
      0.609364,
      1.492423,
      NULL,
      1,
      1,
      0.412439,
      2,
      NULL,
      2.296055,
      NULL,
      2,
      11.294342,
      6.147845,
      0,
      5,
      1.451120,
      0,
      1,
      3.889073,
      3.839974,
      8,
      3,
      NULL,
      NULL,
      NULL,
      14.835324,
      44.803446,
      3,
      0,
      1.844898,
      '',
      NULL,
      '',
      2.643120,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      17.291829,
      NULL,
      22,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.483700,
      2,
      1.429381,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.251523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.452933,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.869476,
      NULL,
      NULL,
      0.257784,
      1.032427,
      1.079810,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.534621,
      NULL,
      NULL,
      5,
      2.560180,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.764096,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.539288,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.709281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.420202,
      NULL,
      NULL,
      0.335714,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      2,
      3.179253,
      0.111973,
      NULL,
      NULL,
      0,
      2,
      0.950644,
      2.420661,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.117661,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.867696,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      2.423632,
      0,
      NULL,
      NULL,
      7,
      0.678383,
      0.077677,
      8,
      0.172237,
      0,
      NULL,
      3,
      4,
      1,
      2.085760,
      3.933612,
      2.071904,
      1,
      2.476967,
      0,
      2.295935,
      NULL,
      8.805830,
      4,
      6.465998,
      0.326450,
      2,
      0.179726,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.444814,
      3.098725,
      0,
      1,
      1.230585,
      5.875333,
      8.218044,
      NULL,
      6.644112,
      0,
      3.429931,
      3,
      NULL,
      NULL,
      0.308023,
      1,
      NULL,
      0,
      0.170254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.570753,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.750110,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.708636,
      1.349168,
      3,
      1.830453,
      NULL,
      NULL,
      3.083283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.659215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.253689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.301321,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.411772,
      1.800368,
      0.527357,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.028756,
      NULL,
      NULL,
      1.250610,
      NULL,
      NULL,
      1.503602,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.269836,
      0.035605,
      1.124369,
      1,
      NULL,
      0,
      1,
      NULL,
      0.827719,
      1.182087,
      1.784179,
      0,
      NULL,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.256666,
      2.051427,
      4.916407,
      NULL,
      4.114266,
      2.173355,
      4.215396,
      0.379979,
      2,
      NULL,
      3,
      NULL,
      NULL,
      0.683881,
      NULL,
      NULL,
      0.625610,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1.953778,
      NULL,
      NULL,
      0.944081,
      NULL,
      NULL,
      1.098034,
      NULL,
      3,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2.520958,
      1.112618,
      NULL,
      2.508588,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.619796,
      NULL,
      5,
      8.339031,
      8,
      3.657516,
      2,
      NULL,
      31.864930,
      42,
      5.857723,
      1.290397,
      0.249572,
      '',
      NULL,
      '',
      0.251080,
      '44403',
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


