set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902224';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-2-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '2113123',
      NULL,
      NULL,
      6,
      NULL,
      '1034',
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 4-1978',
      42,
      NULL,
      2,
      1.479154,
      0.466925,
      '10-21-1980',
      24,
      NULL,
      NULL,
      70.236062,
      NULL,
      '10-12-1997',
      ' 8-10-2000',
      '10-18-1980',
      0,
      1.251312,
      2.336876,
      0.202460,
      NULL,
      0.980997,
      NULL,
      1,
      0,
      5,
      4.045119,
      19.193279,
      2,
      4,
      24,
      2,
      25.063046,
      9.044914,
      6,
      1,
      1,
      0,
      0.330337,
      0.078962,
      1.128886,
      1.776137,
      0,
      0.027605,
      0.694468,
      1,
      19,
      NULL,
      7,
      0.219903,
      NULL,
      0.080627,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4,
      4,
      2,
      2,
      0.596512,
      0,
      9.102530,
      1.168241,
      0.325267,
      NULL,
      0.142704,
      1,
      NULL,
      NULL,
      0.576716,
      NULL,
      NULL,
      2.827055,
      0.187866,
      1,
      3.353119,
      1.101712,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1,
      0.543688,
      2,
      3,
      NULL,
      0.995041,
      NULL,
      1,
      0.587114,
      0.317738,
      NULL,
      4.278821,
      0.724979,
      0,
      1,
      0.406856,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      2,
      1.711140,
      1,
      1.486820,
      0,
      1.322620,
      5.494525,
      0,
      1.773222,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      6.446805,
      5,
      4.543320,
      7,
      0,
      4,
      5,
      1,
      3,
      NULL,
      1,
      7.810726,
      3,
      2.513077,
      0,
      1,
      3,
      4,
      1,
      1,
      4.106183,
      3,
      5,
      0,
      4.903684,
      NULL,
      NULL,
      ' 1-20-1975',
      229.500472,
      ' 0- 2-1984',
      110,
      1.172792,
      1,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.103919,
      NULL,
      0.513630,
      NULL,
      1.225608,
      0.862428,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.456145,
      NULL,
      NULL,
      NULL,
      NULL,
      5.898189,
      0.619505,
      0.534774,
      NULL,
      0.376100,
      7.399845,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.008597,
      1,
      4.404101,
      3,
      0,
      1,
      9.159321,
      1,
      3,
      3,
      1.895280,
      3,
      1.038050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.790819,
      1,
      1,
      0.488918,
      1.120963,
      3,
      75,
      1.239171,
      NULL,
      NULL,
      NULL,
      NULL,
      1.196431,
      NULL,
      0.075404,
      0,
      2.915429,
      1,
      5,
      4,
      NULL,
      0,
      0.023040,
      4,
      3,
      0,
      NULL,
      NULL,
      0,
      0.852546,
      1,
      0,
      1,
      NULL,
      1.166107,
      0,
      NULL,
      0,
      1.129848,
      0,
      0.260401,
      NULL,
      3,
      1,
      11,
      1.006285,
      2.921261,
      9.161174,
      NULL,
      2,
      4,
      2,
      4.753556,
      1.278539,
      1.793733,
      0.812322,
      60.786276,
      2.043804,
      3.619589,
      NULL,
      17,
      17.435881,
      32.818259,
      1.220395,
      1.044591,
      2.669192,
      '34142',
      NULL,
      NULL,
      1.274155,
      NULL,
      '',
      '',
      1.818448,
      '',
      '',
      '',
      0.324020,
      29.439139,
      44,
      25,
      1.371627,
      NULL,
      4,
      3.135181,
      5.608687,
      1.735364,
      NULL,
      0,
      0.967281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.748455,
      2.668632,
      NULL,
      2.953421,
      1,
      NULL,
      NULL,
      2.061597,
      1,
      0,
      2.077510,
      1.384925,
      0,
      NULL,
      NULL,
      1,
      1.371510,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0.267528,
      NULL,
      NULL,
      1,
      2,
      7.961846,
      0.343580,
      2.985167,
      2.806481,
      NULL,
      NULL,
      0.525918,
      NULL,
      NULL,
      NULL,
      0,
      3.010851,
      NULL,
      NULL,
      NULL,
      NULL,
      2.659616,
      1.203212,
      0.161392,
      3,
      0.783537,
      NULL,
      0,
      1.291091,
      1,
      0,
      2.231966,
      0,
      NULL,
      3,
      0.080292,
      1,
      1.032344,
      1.288512,
      1.517650,
      3,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.882908,
      NULL,
      NULL,
      3,
      0.865652,
      1,
      1,
      3,
      0.124250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.117668,
      1,
      NULL,
      NULL,
      7.196954,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.678392,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.110461,
      NULL,
      NULL,
      0.773061,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.142039,
      2.994979,
      NULL,
      0,
      8,
      NULL,
      7.609263,
      3,
      2.254280,
      3.594295,
      4.773746,
      NULL,
      NULL,
      2.167208,
      0.500748,
      NULL,
      2.831263,
      0.810207,
      3,
      0,
      1,
      0.967828,
      2,
      5,
      0.154417,
      3,
      1.316407,
      0,
      1,
      NULL,
      NULL,
      0.769590,
      3.734735,
      0.635636,
      3.693136,
      0.620200,
      1,
      8,
      4,
      9,
      5,
      2.965443,
      6,
      3.906699,
      5,
      6,
      NULL,
      3.315105,
      2,
      0,
      2,
      2,
      NULL,
      NULL,
      0,
      NULL,
      13,
      NULL,
      NULL,
      1.495393,
      NULL,
      NULL,
      1.732851,
      NULL,
      NULL,
      0.418291,
      NULL,
      NULL,
      2.620086,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2.226987,
      0,
      NULL,
      1,
      0.367701,
      NULL,
      2.008000,
      2.153563,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.063033,
      NULL,
      NULL,
      0.630840,
      NULL,
      8.613036,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      0.721019,
      NULL,
      0.835913,
      NULL,
      NULL,
      1.060206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.153113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.936692,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.704989,
      NULL,
      NULL,
      NULL,
      3.186069,
      NULL,
      NULL,
      NULL,
      0.140886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.038320,
      22,
      NULL,
      0.372012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.020995,
      NULL,
      NULL,
      1,
      22.429533,
      12,
      3.202833,
      NULL,
      0,
      0.755238,
      NULL,
      1,
      189.947493,
      2,
      1,
      NULL,
      0.740228,
      0,
      1.655397,
      0,
      0.103896,
      NULL,
      1,
      0,
      0.568116,
      1.870539,
      NULL,
      0,
      1.047329,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.647155,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.884283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.897499,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.167014,
      0,
      0.403912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.866825,
      3.901082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.052448,
      NULL,
      1.023387,
      1.393173,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.943547,
      5.362846,
      1.012800,
      2.264830,
      1.234892,
      4.815110,
      NULL,
      0,
      2.678579,
      1.844236,
      1.414448,
      0,
      NULL,
      0.869942,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0.206261,
      NULL,
      0.580435,
      1.334575,
      NULL,
      1,
      1,
      NULL,
      1,
      2,
      NULL,
      1,
      1.306959,
      NULL,
      1,
      NULL,
      NULL,
      2.539260,
      2,
      NULL,
      0,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.570848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.204381,
      NULL,
      0.460683,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2,
      1,
      NULL,
      NULL,
      61,
      47.432181,
      2,
      1,
      2.899449,
      '34422',
      '',
      '',
      NULL,
      '42313',
      NULL,
      '',
      1.373799,
      '',
      '',
      NULL);
commit;
end;
/


