set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7914472';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1983-2-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '3142214',
      0.550695,
      1.190695,
      1,
      2,
      '3043',
      1,
      0.868768,
      NULL,
      NULL,
      ' 8-14-1977',
      34.689795,
      NULL,
      3.366135,
      0.711440,
      15,
      ' 6-15-1976',
      32.387243,
      0.096466,
      129,
      89.109233,
      3.695774,
      ' 4-21-1976',
      NULL,
      NULL,
      2,
      NULL,
      1,
      3,
      1,
      NULL,
      0,
      0.884955,
      NULL,
      NULL,
      1,
      NULL,
      6,
      152.938246,
      NULL,
      5,
      29.513478,
      5.174323,
      0,
      2,
      NULL,
      3,
      0,
      NULL,
      0,
      1.650762,
      0,
      NULL,
      0.110591,
      0,
      1.177672,
      2,
      2,
      0.157474,
      2.596978,
      0.555775,
      1,
      NULL,
      0,
      4,
      NULL,
      4.463034,
      3.836157,
      0,
      1.213543,
      1,
      3,
      NULL,
      0.623466,
      4,
      2.796135,
      1.220458,
      1.816645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5.643990,
      2,
      NULL,
      0.586518,
      NULL,
      NULL,
      NULL,
      1.067928,
      1.936140,
      0,
      NULL,
      3.549080,
      NULL,
      1,
      0.946923,
      0.535021,
      0,
      NULL,
      NULL,
      1,
      2.156326,
      2.601900,
      0.761468,
      4,
      1.911974,
      NULL,
      NULL,
      NULL,
      1.202788,
      NULL,
      NULL,
      1.098788,
      2.248459,
      3.233929,
      0,
      7,
      1.277981,
      NULL,
      1.801949,
      0.646063,
      0.173387,
      1.758685,
      0.164798,
      0.660302,
      5,
      1.971320,
      NULL,
      0,
      NULL,
      0.464348,
      NULL,
      1,
      0,
      4,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.327860,
      1.142029,
      0,
      NULL,
      NULL,
      3,
      8.184681,
      9.350708,
      6.187486,
      2.943624,
      1,
      4.671843,
      5,
      6,
      0,
      1,
      0.960935,
      3,
      ' 5-20-1992',
      NULL,
      ' 5- 7-1985',
      140,
      NULL,
      0.223580,
      1.315724,
      6,
      1.655082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.619340,
      3,
      1,
      NULL,
      0.183637,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.639235,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.842984,
      0.211013,
      7,
      NULL,
      0.978112,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.605936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.250858,
      NULL,
      NULL,
      NULL,
      NULL,
      2.482058,
      1,
      1.116415,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      63,
      NULL,
      NULL,
      NULL,
      54.935986,
      40,
      29.971539,
      NULL,
      1,
      NULL,
      '04042',
      '',
      '',
      1,
      '',
      '',
      '',
      0.126296,
      '',
      '',
      '',
      2,
      13.138123,
      111,
      28.842246,
      1.981730,
      NULL,
      3.846184,
      9,
      0.100479,
      0.128189,
      NULL,
      NULL,
      0.789060,
      NULL,
      NULL,
      0.365047,
      3,
      0.883237,
      NULL,
      NULL,
      NULL,
      0.230973,
      0,
      1.100872,
      1,
      NULL,
      NULL,
      NULL,
      1.083409,
      NULL,
      0,
      NULL,
      NULL,
      0.366366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.112391,
      7.992168,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.256038,
      0,
      0,
      2,
      0.468472,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.926278,
      1.094348,
      3,
      0.698157,
      NULL,
      0.752584,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      0,
      1,
      0.596113,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      10.295733,
      11,
      1,
      3.127647,
      1.849382,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.118065,
      NULL,
      NULL,
      0.597964,
      1.118561,
      0.862919,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.299366,
      NULL,
      NULL,
      0.854259,
      3.984356,
      0,
      NULL,
      NULL,
      NULL,
      2.209910,
      4.485320,
      3.231178,
      NULL,
      0,
      NULL,
      1.270910,
      NULL,
      NULL,
      1.877876,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.001321,
      2,
      1,
      NULL,
      NULL,
      NULL,
      3.105877,
      NULL,
      2.759030,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5,
      10.832494,
      8.085352,
      NULL,
      3,
      NULL,
      NULL,
      0,
      2,
      0.262315,
      1,
      2.557904,
      0.055115,
      1.033407,
      NULL,
      0,
      11,
      11.578822,
      0.192243,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      2,
      2,
      1,
      3,
      2.845449,
      3,
      0,
      NULL,
      1.347533,
      1.035595,
      7.184161,
      2,
      2.976027,
      3.459581,
      5.202146,
      0,
      0.468595,
      NULL,
      0.484170,
      1,
      2,
      NULL,
      NULL,
      1.654184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.543276,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.525416,
      NULL,
      NULL,
      0.172219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.846718,
      0,
      0.488097,
      0.742331,
      NULL,
      1.168408,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.985777,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.428636,
      NULL,
      NULL,
      NULL,
      3.541399,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.808352,
      NULL,
      NULL,
      NULL,
      1.407218,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.153138,
      2.577268,
      NULL,
      NULL,
      1.224113,
      0,
      NULL,
      NULL,
      1,
      0.746727,
      NULL,
      NULL,
      0.830133,
      0,
      NULL,
      NULL,
      0,
      0.167013,
      NULL,
      NULL,
      0,
      1.088798,
      NULL,
      NULL,
      1.987431,
      0,
      NULL,
      NULL,
      8,
      3,
      NULL,
      NULL,
      0.949287,
      NULL,
      NULL,
      NULL,
      1,
      68.781046,
      12.497991,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      20.504342,
      13,
      1.311783,
      NULL,
      NULL,
      1.562538,
      NULL,
      1.482875,
      8562,
      0.653437,
      1,
      0.990753,
      0,
      1.753222,
      1.534177,
      0.889589,
      0,
      1.390286,
      NULL,
      NULL,
      0.603408,
      1,
      NULL,
      0.486777,
      1,
      1,
      0.367641,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.488940,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.141109,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.666508,
      0,
      NULL,
      0,
      NULL,
      1.587836,
      NULL,
      NULL,
      NULL,
      0,
      0.593717,
      1.228146,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.673211,
      NULL,
      0,
      0.495803,
      1.154231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.555812,
      4.934290,
      0,
      NULL,
      NULL,
      114,
      103,
      4,
      0,
      2.816803,
      NULL,
      '',
      '',
      1.264124,
      '',
      '',
      '',
      0,
      NULL,
      '',
      NULL);
commit;
end;
/


