set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8934076';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-7-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '0310213',
      2.655335,
      0.408915,
      6,
      3,
      '4422',
      NULL,
      0,
      NULL,
      NULL,
      ' 5-15-1994',
      27.487475,
      NULL,
      NULL,
      1.814452,
      2,
      ' 0-16-1985',
      20.507833,
      2,
      331.351974,
      138,
      3,
      NULL,
      '11-28-1992',
      NULL,
      0.191339,
      1,
      1.714059,
      0,
      NULL,
      2.100048,
      NULL,
      0.694220,
      0,
      31,
      7.206523,
      4.342505,
      0.712551,
      23,
      17.419282,
      5,
      NULL,
      NULL,
      3.576697,
      4.415343,
      NULL,
      1.761265,
      0.390479,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0.007490,
      NULL,
      4,
      0.326400,
      NULL,
      0.826410,
      0,
      0,
      0,
      0.751391,
      2,
      NULL,
      NULL,
      1,
      3.170096,
      NULL,
      5.615631,
      2,
      3.469460,
      0,
      NULL,
      NULL,
      0.736826,
      NULL,
      NULL,
      10,
      5.194510,
      5,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2.674319,
      0.889919,
      NULL,
      0,
      3.383088,
      3,
      0,
      1,
      3,
      0,
      0,
      NULL,
      NULL,
      3.102690,
      NULL,
      1.110245,
      0.258101,
      2.496692,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.906585,
      5,
      1,
      0.985679,
      3,
      0,
      6,
      1.386705,
      0,
      1.122472,
      0,
      1,
      NULL,
      0.797881,
      NULL,
      1,
      1.326680,
      1.768361,
      0.270093,
      NULL,
      0.010740,
      0.205979,
      1.512993,
      0.626340,
      1,
      NULL,
      NULL,
      5,
      1.419859,
      1.717975,
      NULL,
      4.918350,
      0,
      2,
      5.763951,
      5.146897,
      9,
      3.818327,
      4,
      6,
      0,
      0,
      2,
      1.959380,
      0,
      3,
      5.616426,
      2.424484,
      ' 2-12-1992',
      99,
      ' 7-26-1999',
      15,
      1,
      1,
      1,
      2,
      0.034387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      1.018654,
      NULL,
      0.414506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.456881,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      2.649600,
      3,
      8,
      10,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.593902,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1.544505,
      0.960908,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.871387,
      1,
      1,
      2.574177,
      3,
      NULL,
      NULL,
      0.484290,
      17,
      NULL,
      0.948406,
      NULL,
      NULL,
      NULL,
      3.081390,
      NULL,
      3,
      2.542780,
      1,
      3.949086,
      2,
      NULL,
      2,
      NULL,
      1.401810,
      NULL,
      NULL,
      0.552511,
      0.348008,
      3.289671,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1.757516,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      2.914355,
      9,
      2,
      9,
      8.900097,
      3,
      2.787189,
      NULL,
      NULL,
      3,
      2.033202,
      NULL,
      17,
      3.449569,
      0,
      NULL,
      18,
      56.546192,
      21.609410,
      1,
      0,
      2.636082,
      '23221',
      '',
      '',
      1.998176,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '',
      3,
      13.753449,
      18,
      NULL,
      2.674840,
      26.462186,
      27,
      12.534458,
      7,
      2,
      2.399805,
      2.839181,
      1.106876,
      NULL,
      NULL,
      0.043913,
      NULL,
      NULL,
      1.691532,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.569002,
      NULL,
      NULL,
      0.082180,
      0,
      3.594448,
      2,
      1,
      0.889339,
      1.163717,
      2.241773,
      0.298403,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      3.227401,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      2,
      0,
      0.343016,
      NULL,
      2.607446,
      NULL,
      0.864754,
      1,
      2.215934,
      0.409353,
      NULL,
      2.505204,
      0,
      NULL,
      1,
      0.814870,
      NULL,
      3,
      1.462264,
      1,
      0,
      1,
      0.148533,
      NULL,
      NULL,
      1.187371,
      NULL,
      NULL,
      3.100698,
      0,
      3.282087,
      0,
      9,
      0,
      NULL,
      1.976382,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.203018,
      NULL,
      NULL,
      1,
      NULL,
      0.320963,
      3.977619,
      0,
      1,
      0,
      NULL,
      NULL,
      1.555890,
      5.554778,
      1,
      NULL,
      3.181495,
      0,
      1.507860,
      NULL,
      NULL,
      5,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.450286,
      NULL,
      NULL,
      1.643288,
      NULL,
      NULL,
      1.433957,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.441961,
      NULL,
      5.603537,
      0,
      NULL,
      NULL,
      0.740011,
      1.994898,
      1,
      3.241374,
      2,
      0.109413,
      0.199938,
      1.621914,
      3.307350,
      0,
      NULL,
      7,
      NULL,
      1,
      NULL,
      1.609029,
      NULL,
      NULL,
      0.805690,
      2.464682,
      1.425089,
      0.946549,
      NULL,
      1.152623,
      3.471126,
      8.868130,
      NULL,
      0,
      NULL,
      1,
      1.177296,
      1.064583,
      6,
      NULL,
      0,
      NULL,
      0.361124,
      0.049976,
      1.565460,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.210373,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.125309,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.423652,
      2.204490,
      3,
      2.901850,
      NULL,
      NULL,
      3.962895,
      4.486098,
      NULL,
      2.821371,
      2,
      9.741552,
      NULL,
      13,
      17.614091,
      3,
      NULL,
      1.873311,
      3,
      1,
      NULL,
      1.715550,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.787680,
      1,
      1,
      NULL,
      0,
      0.386027,
      3.712018,
      NULL,
      NULL,
      0,
      0.719786,
      NULL,
      0,
      1,
      1,
      NULL,
      1.098079,
      0,
      0,
      NULL,
      0,
      NULL,
      3,
      NULL,
      2.334787,
      NULL,
      1.939397,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.134804,
      NULL,
      0.541962,
      3,
      1,
      NULL,
      0.928056,
      0,
      2,
      NULL,
      1.259088,
      0.850484,
      NULL,
      NULL,
      9.625274,
      NULL,
      NULL,
      NULL,
      3.504225,
      2,
      1,
      NULL,
      2,
      NULL,
      NULL,
      1,
      35,
      1,
      1.904445,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      30,
      2,
      1.893980,
      NULL,
      NULL,
      3.985392,
      20,
      1.270119,
      NULL,
      4.535370,
      1,
      1.561168,
      0,
      NULL,
      0.938535,
      0.734609,
      0.030687,
      NULL,
      NULL,
      NULL,
      1.513269,
      0.202019,
      0,
      0,
      0.945048,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.595882,
      1,
      0.711376,
      1,
      0.501419,
      0.700884,
      NULL,
      2.215607,
      0,
      NULL,
      0.840593,
      3.146782,
      1,
      0.556614,
      NULL,
      0.507261,
      1.849670,
      NULL,
      1,
      NULL,
      1.847530,
      1,
      0.295819,
      1.211006,
      0,
      0.005190,
      0.501708,
      1,
      1,
      0.563101,
      NULL,
      1.516425,
      2.521899,
      NULL,
      1,
      1.659719,
      0,
      0,
      0.923470,
      1,
      1,
      1.229953,
      0.450266,
      1.026748,
      NULL,
      1.518801,
      1.852327,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.336059,
      1,
      1.404888,
      1,
      NULL,
      1,
      5.194562,
      5.394687,
      3,
      1,
      NULL,
      NULL,
      60,
      134.498713,
      5.068849,
      1,
      0,
      '33012',
      '01102',
      '',
      1.595746,
      NULL,
      NULL,
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


