set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8628956';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      7.826343,
      4,
      1.200799,
      6.899091,
      3,
      1.310392,
      2,
      0.299663,
      '312',
      '40140410',
      41,
      NULL,
      '4014234',
      1.712168,
      0,
      0,
      2,
      '1412',
      NULL,
      0.516888,
      NULL,
      NULL,
      NULL,
      31,
      10,
      NULL,
      1,
      NULL,
      ' 5-28-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 7- 0-1991',
      '10-16-1996',
      ' 4-12-1998',
      2.216299,
      3,
      0.998522,
      NULL,
      NULL,
      1,
      0.090792,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      4.166682,
      2.616806,
      NULL,
      1.780170,
      NULL,
      0.078461,
      1,
      0.891531,
      1.319510,
      0.535774,
      0.854089,
      0.104256,
      NULL,
      0.489263,
      NULL,
      3,
      1.840720,
      0,
      1.436043,
      1,
      NULL,
      NULL,
      5,
      1,
      4,
      3,
      1,
      NULL,
      NULL,
      1.645562,
      3.522506,
      NULL,
      3.584131,
      4.752629,
      5.016474,
      NULL,
      NULL,
      NULL,
      0.877780,
      NULL,
      NULL,
      0.347399,
      NULL,
      1.688423,
      0.830115,
      0,
      0,
      0.467205,
      0,
      1.889473,
      1.761584,
      NULL,
      1,
      NULL,
      0,
      2.106319,
      2,
      3,
      2,
      NULL,
      0.786148,
      1.845332,
      6,
      10,
      1.663391,
      1.285041,
      0.189285,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.479606,
      1,
      2,
      0.569638,
      2.697527,
      1.440065,
      NULL,
      1.790168,
      NULL,
      0.472487,
      1.317113,
      1,
      0,
      0.717455,
      0.601739,
      0.164128,
      0.436226,
      1,
      0,
      NULL,
      0.521328,
      NULL,
      0.535480,
      1,
      1.365155,
      NULL,
      0.779695,
      1.732817,
      NULL,
      0,
      1,
      NULL,
      1.362405,
      NULL,
      NULL,
      0,
      5.169353,
      1,
      5,
      7,
      3.630835,
      1.973277,
      4,
      6,
      1.291586,
      NULL,
      3.301953,
      NULL,
      NULL,
      135.542467,
      '10-14-1991',
      NULL,
      3,
      4,
      0.964774,
      NULL,
      0.968701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.568405,
      0,
      1.450156,
      0.403761,
      NULL,
      3.148956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.758826,
      2.774159,
      NULL,
      1.559613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.132913,
      1.168580,
      1.211434,
      0,
      1,
      6,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.022222,
      NULL,
      1.035171,
      NULL,
      0,
      1.344218,
      NULL,
      54.584687,
      0.582749,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.880343,
      0.226652,
      3.221837,
      1.717712,
      2.744846,
      1,
      1.683506,
      NULL,
      1,
      2,
      0.756901,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.651197,
      NULL,
      0.246682,
      NULL,
      0,
      1.363686,
      0,
      NULL,
      NULL,
      0.143937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.215801,
      1,
      NULL,
      1.825123,
      34,
      4,
      NULL,
      2.649745,
      '40323',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      20,
      0.344412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.943180,
      NULL,
      NULL,
      NULL,
      0.360456,
      NULL,
      NULL,
      3.442336,
      NULL,
      1.456426,
      0,
      3.666487,
      0,
      1,
      NULL,
      NULL,
      0.267180,
      1.800027,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.422710,
      NULL,
      NULL,
      NULL,
      2.145696,
      5.360090,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.956257,
      1,
      1.337013,
      NULL,
      NULL,
      1.319679,
      NULL,
      NULL,
      2,
      1,
      1,
      0,
      0,
      NULL,
      3,
      1.374146,
      1,
      1.963717,
      1.965624,
      1.172592,
      2,
      NULL,
      3.753493,
      1,
      2,
      NULL,
      0,
      1.167004,
      NULL,
      NULL,
      NULL,
      3.571357,
      0,
      5.336008,
      5,
      1,
      1.708293,
      1.308562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      4,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.980642,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.783036,
      NULL,
      NULL,
      0.147926,
      NULL,
      NULL,
      1.236599,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      2.193637,
      1.696109,
      NULL,
      NULL,
      1,
      1,
      2.451462,
      NULL,
      2.024536,
      4.884295,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0.856551,
      NULL,
      2.268338,
      1,
      3,
      0.363636,
      NULL,
      2,
      3.546856,
      NULL,
      1.094752,
      1.659977,
      3.886128,
      3,
      2,
      NULL,
      3,
      0,
      3,
      1,
      7.709024,
      NULL,
      3.600625,
      NULL,
      NULL,
      NULL,
      NULL,
      1.937566,
      1,
      NULL,
      0.490078,
      1,
      0.511583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0.479363,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.154607,
      NULL,
      NULL,
      NULL,
      0,
      1.734257,
      0.827427,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.476879,
      NULL,
      NULL,
      1.034181,
      NULL,
      NULL,
      1.469265,
      NULL,
      0,
      0,
      1.663809,
      0.868700,
      NULL,
      0.547695,
      0.064900,
      0.065432,
      1.611947,
      NULL,
      0.810544,
      0.663888,
      0.193664,
      1.740505,
      0.609627,
      1.091978,
      0.442513,
      0,
      0,
      0.642258,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.287261,
      4.066994,
      7,
      NULL,
      5,
      3,
      1.720526,
      6,
      3,
      1,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      3.494247,
      NULL,
      2,
      NULL,
      NULL,
      2.761028,
      0.389006,
      NULL,
      NULL,
      1.178450,
      NULL,
      1,
      0,
      NULL,
      0.525633,
      0.526045,
      NULL,
      1,
      2.587816,
      NULL,
      NULL,
      0.318170,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.280469,
      NULL,
      1.362927,
      NULL,
      NULL,
      7,
      0.259056,
      0.008277,
      NULL,
      NULL,
      22,
      13,
      0,
      3.956755,
      0.680814,
      '01121',
      '',
      '',
      0.511973,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


