set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923682';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-10-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '4412314',
      3,
      1,
      0,
      2,
      '4241',
      0.733968,
      1.975420,
      NULL,
      NULL,
      ' 4- 4-1985',
      NULL,
      NULL,
      3.177041,
      0,
      1.667901,
      NULL,
      58.019510,
      5,
      53.475937,
      84.015892,
      1,
      ' 5-13-1998',
      ' 5- 0-1980',
      ' 4- 4-1983',
      2,
      1,
      0.366553,
      0,
      NULL,
      3.191750,
      NULL,
      1.471401,
      0.256784,
      26,
      0.080807,
      9.347796,
      5.915035,
      15,
      21,
      1.875406,
      17,
      NULL,
      3.839389,
      5.939581,
      0.983353,
      NULL,
      1.896590,
      0,
      1.517479,
      0,
      0.047436,
      1,
      0,
      1,
      0.470768,
      NULL,
      NULL,
      1,
      2,
      5.026812,
      NULL,
      3.610332,
      0.906723,
      0.959528,
      1.100732,
      4,
      1,
      1,
      0,
      NULL,
      0.720017,
      1.505483,
      1,
      4.980479,
      NULL,
      1,
      0.425315,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.371927,
      1.749189,
      0.309349,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.732850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.101196,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      2.496663,
      7.404194,
      0,
      NULL,
      1.757173,
      1.699075,
      NULL,
      1,
      1.079126,
      NULL,
      1.155837,
      6,
      NULL,
      NULL,
      5.465461,
      1.630086,
      2,
      7.013531,
      3,
      0,
      NULL,
      5,
      2,
      4,
      NULL,
      NULL,
      0,
      NULL,
      10,
      9.264585,
      1.083896,
      4,
      3.600057,
      3,
      NULL,
      NULL,
      3,
      NULL,
      ' 6-14-2001',
      64.671687,
      ' 7-14-1976',
      14.193549,
      1,
      NULL,
      0,
      2.737222,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.348806,
      3.702662,
      NULL,
      4.081557,
      1.603961,
      0,
      0.570670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.074051,
      7.505286,
      NULL,
      1,
      1.561984,
      4,
      0,
      1.488263,
      2,
      3,
      1.780561,
      0.692946,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.932969,
      5,
      7,
      2,
      0.239457,
      NULL,
      NULL,
      NULL,
      1.764941,
      6.265092,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.819079,
      3.974275,
      NULL,
      1.359270,
      1,
      1,
      NULL,
      0.726179,
      2,
      NULL,
      0.359014,
      NULL,
      NULL,
      NULL,
      2.664267,
      0.518030,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      2.791364,
      2.726330,
      1,
      NULL,
      NULL,
      1.746560,
      NULL,
      3,
      1,
      1.834955,
      1.592243,
      0,
      0.971556,
      NULL,
      0.558918,
      1,
      1,
      1,
      0.322710,
      1.455323,
      1,
      1.666346,
      1.707674,
      4.246746,
      NULL,
      4.833195,
      5,
      9.168619,
      3,
      4.508906,
      2.430074,
      0,
      3,
      2.709465,
      0.752649,
      5.879877,
      0,
      1,
      NULL,
      26.977837,
      NULL,
      92,
      4,
      0,
      2.721389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      3,
      '0042',
      '',
      '',
      1,
      NULL,
      17.844378,
      12,
      1.469214,
      45.244829,
      5.727455,
      1.645547,
      0,
      1,
      3.668288,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2.763610,
      0.839955,
      0.280807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.549696,
      1,
      1.640823,
      0.182748,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.726652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.580744,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.065454,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.334383,
      NULL,
      NULL,
      0,
      NULL,
      2,
      2.896035,
      0,
      2,
      NULL,
      6,
      2.208835,
      1.529144,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.170470,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.647514,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.592006,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.738859,
      NULL,
      NULL,
      NULL,
      5.064636,
      4,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      0,
      3.320692,
      1,
      10,
      8,
      3,
      2,
      3.727612,
      3,
      2,
      3.903710,
      1.613988,
      3.422272,
      NULL,
      0,
      1,
      3,
      10.836091,
      8.359085,
      NULL,
      NULL,
      2.579936,
      2.776490,
      1,
      NULL,
      2,
      1,
      1,
      1,
      0.555354,
      0,
      3,
      NULL,
      NULL,
      0.811551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.654267,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.747166,
      NULL,
      NULL,
      0.334810,
      NULL,
      NULL,
      1.701601,
      NULL,
      NULL,
      0.329930,
      2,
      3.464173,
      1,
      1.719943,
      1.404958,
      0.577392,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.018098,
      NULL,
      NULL,
      NULL,
      1.473814,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.469870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.925931,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.720046,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.215249,
      NULL,
      NULL,
      NULL,
      2.827417,
      NULL,
      NULL,
      NULL,
      0.748098,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.743437,
      1,
      2.732248,
      0.944505,
      0.072793,
      NULL,
      NULL,
      0.834217,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.818719,
      NULL,
      NULL,
      0,
      NULL,
      0.424227,
      243.393763,
      NULL,
      NULL,
      1,
      1.919808,
      0,
      0.340391,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      0.327700,
      NULL,
      1,
      NULL,
      0,
      0.448590,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.136746,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.833599,
      2,
      3.271416,
      13.231528,
      1.442054,
      5,
      4,
      7.181830,
      NULL,
      0,
      1.318653,
      1.564395,
      0.556315,
      0.376689,
      NULL,
      1.277519,
      3,
      NULL,
      0.888524,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.300796,
      3.702693,
      NULL,
      NULL,
      2,
      NULL,
      3.645891,
      NULL,
      NULL,
      3.347132,
      NULL,
      NULL,
      0.267762,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.108589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.881901,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2.402656,
      NULL,
      NULL,
      NULL,
      0.657827,
      NULL,
      2,
      NULL,
      1,
      NULL,
      2,
      NULL,
      3.871144,
      NULL,
      1.188556,
      NULL,
      2.106602,
      NULL,
      18.496691,
      0,
      NULL,
      0,
      NULL,
      0.421233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      54,
      5,
      1.494486,
      5,
      '10032',
      '33113',
      '',
      1,
      '00112',
      NULL,
      '',
      0.443897,
      '0434',
      '',
      '');
commit;
end;
/


