set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923682';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-1-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '1300342',
      5.329356,
      1.756480,
      0,
      2,
      '3130',
      0,
      0,
      NULL,
      NULL,
      ' 6- 4-2002',
      64,
      NULL,
      1.868175,
      NULL,
      0,
      ' 9- 7-1990',
      52.886858,
      3.728053,
      190,
      NULL,
      0.205741,
      ' 6-15-1986',
      ' 9-17-1974',
      NULL,
      3.919618,
      0.972874,
      2.300144,
      2.735089,
      0,
      3.933856,
      0.236265,
      1.963130,
      NULL,
      78,
      0,
      2,
      1.758949,
      18.965573,
      NULL,
      3,
      29,
      3.272534,
      0.623085,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.818723,
      1.611751,
      0.603482,
      1.960703,
      7,
      1,
      0.469144,
      1.825115,
      NULL,
      1,
      NULL,
      3,
      0,
      0,
      6,
      NULL,
      11.094842,
      NULL,
      5,
      0.907483,
      1,
      0.476965,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.210872,
      NULL,
      1.268341,
      1,
      0.633761,
      1.129744,
      NULL,
      2,
      NULL,
      2.752760,
      0,
      0.972080,
      0,
      NULL,
      2.989036,
      0,
      2.263887,
      1,
      1.059127,
      NULL,
      2.904316,
      NULL,
      1,
      0.922360,
      0.589464,
      1.381368,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.668638,
      2,
      0,
      1.272773,
      1,
      1,
      1.183936,
      NULL,
      1.610069,
      1.833940,
      1,
      1,
      1.351886,
      1,
      NULL,
      1.455256,
      NULL,
      1.791822,
      NULL,
      0.452470,
      4.658937,
      0,
      0,
      NULL,
      7.909379,
      0,
      0.544573,
      0,
      NULL,
      0.749902,
      NULL,
      0.832882,
      NULL,
      4,
      3,
      5.776277,
      NULL,
      7,
      0,
      10.509833,
      8,
      0.200990,
      0,
      0.773738,
      0,
      ' 0-27-1976',
      380.154534,
      NULL,
      40.309436,
      3.767381,
      1,
      0.148866,
      NULL,
      0.271321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.214372,
      1.223016,
      NULL,
      0.990744,
      NULL,
      1.841596,
      NULL,
      0.430754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.487122,
      NULL,
      NULL,
      0,
      1.568958,
      6.092351,
      0.345185,
      0,
      3,
      2.836690,
      3.015268,
      1.045396,
      1,
      NULL,
      2,
      3,
      1,
      1,
      2.470658,
      1.515611,
      2,
      3.225838,
      2,
      3,
      0.400060,
      NULL,
      NULL,
      0.260285,
      NULL,
      0.130520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      0,
      1,
      0.756965,
      2.754923,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      NULL,
      0,
      0,
      2,
      3.760914,
      NULL,
      2.697318,
      3,
      NULL,
      1.810705,
      3,
      NULL,
      1,
      2,
      0,
      NULL,
      1.386738,
      NULL,
      1.061817,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      9.421394,
      NULL,
      4.348908,
      NULL,
      2,
      3,
      NULL,
      3,
      6,
      2.839858,
      1,
      2,
      43,
      2.569287,
      1,
      NULL,
      35.174975,
      40,
      32.053535,
      1.178425,
      NULL,
      NULL,
      '42433',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '1134',
      '',
      '',
      0,
      33.249568,
      46.032499,
      3,
      NULL,
      NULL,
      3.437343,
      3.263267,
      NULL,
      2,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.623309,
      1.775289,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.401427,
      NULL,
      3.355974,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.915664,
      NULL,
      NULL,
      7,
      9.828304,
      9,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.819424,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.112853,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.868413,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.789147,
      NULL,
      NULL,
      1.348738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.231341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.139728,
      2.840593,
      1,
      3,
      2,
      0.464525,
      6.693939,
      NULL,
      0.232489,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.134202,
      0,
      0.848132,
      1,
      NULL,
      NULL,
      0.250439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.750632,
      NULL,
      NULL,
      NULL,
      1,
      2.197880,
      NULL,
      NULL,
      NULL,
      NULL,
      2.300016,
      NULL,
      6.498186,
      5,
      2,
      3,
      NULL,
      NULL,
      3.569589,
      0.996969,
      2,
      0,
      NULL,
      1,
      2,
      3.514901,
      2.969581,
      9.835282,
      NULL,
      2,
      0.111977,
      0,
      3.013186,
      0,
      1.511955,
      0.143149,
      0.858438,
      1.002132,
      2.830128,
      1,
      2.532255,
      0,
      5,
      7,
      2,
      NULL,
      NULL,
      0,
      1,
      NULL,
      4,
      NULL,
      1,
      0,
      1.983989,
      1.338529,
      0.353100,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.940662,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.629307,
      NULL,
      NULL,
      1.143431,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.019391,
      NULL,
      NULL,
      1.689690,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      2.413312,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.503609,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.918133,
      NULL,
      NULL,
      NULL,
      1.156996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.453394,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.647646,
      NULL,
      NULL,
      NULL,
      0.643652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.887387,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      5,
      NULL,
      1.651794,
      1,
      0,
      1.531869,
      NULL,
      NULL,
      3,
      22,
      8,
      0.364156,
      NULL,
      NULL,
      0.080354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      325,
      NULL,
      NULL,
      1.033746,
      1,
      1,
      1.937508,
      NULL,
      0.893775,
      1.792206,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      1.191646,
      1.251740,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.249240,
      1.930204,
      11.955461,
      3,
      NULL,
      0,
      4.301711,
      7,
      1.649248,
      NULL,
      0.997584,
      0,
      NULL,
      NULL,
      0.549528,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.381664,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.384195,
      NULL,
      0.808731,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.178727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.183859,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      2.919814,
      NULL,
      1.563606,
      NULL,
      2,
      NULL,
      0.340156,
      NULL,
      1,
      NULL,
      5,
      3.214020,
      NULL,
      0,
      NULL,
      3.135854,
      NULL,
      1,
      NULL,
      2.196068,
      6,
      6,
      NULL,
      1,
      NULL,
      30,
      57,
      4,
      1.405490,
      NULL,
      NULL,
      '20031',
      '',
      0,
      NULL,
      NULL,
      '',
      NULL,
      '0232',
      NULL,
      '');
commit;
end;
/


