set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9824700';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-4-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      3,
      1,
      NULL,
      3.380342,
      NULL,
      1,
      0.133553,
      '224',
      '42330340',
      65.573110,
      72,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '3411',
      2.479409,
      0.161460,
      NULL,
      NULL,
      ' 0-10-1980',
      127,
      149.224921,
      NULL,
      0,
      3,
      ' 5- 7-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 7-11-1984',
      0.243518,
      0,
      0.182090,
      0.590704,
      0.482650,
      NULL,
      3,
      1.593632,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.558997,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.038498,
      3,
      NULL,
      1,
      3.836019,
      1,
      5,
      1.298355,
      5.449113,
      0,
      0.718298,
      0.423708,
      2,
      1.194661,
      0.120088,
      NULL,
      0.934065,
      0.639606,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.405569,
      2.462844,
      NULL,
      NULL,
      1.657339,
      2,
      3.677538,
      1.558258,
      NULL,
      2,
      0.100230,
      1,
      1,
      NULL,
      1,
      0.763096,
      NULL,
      2.349791,
      0,
      0,
      5,
      7,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.591502,
      0.568945,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0.948830,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.892253,
      1.198463,
      1,
      1.954798,
      NULL,
      0.498527,
      NULL,
      2,
      1.551032,
      3.539629,
      NULL,
      NULL,
      4.337489,
      3,
      1.264789,
      1.450790,
      0.432281,
      7,
      NULL,
      3,
      NULL,
      5.300369,
      7.785629,
      NULL,
      NULL,
      4,
      3.125011,
      2.074361,
      ' 3- 8-1986',
      70,
      ' 2-27-1993',
      6,
      1,
      1.084635,
      0.105983,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.672132,
      1.225612,
      NULL,
      1,
      0,
      3.393977,
      3,
      1.827723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      0.906828,
      3,
      1.265488,
      1.604872,
      1,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.778971,
      NULL,
      NULL,
      3,
      1,
      5,
      3.060647,
      NULL,
      NULL,
      NULL,
      0,
      0.791241,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.019240,
      NULL,
      0,
      NULL,
      0.330784,
      0,
      NULL,
      1.116082,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.698622,
      3,
      1,
      2,
      1,
      0,
      0.079807,
      0.088356,
      NULL,
      2.256302,
      3,
      0,
      1,
      3.470609,
      2,
      3.311239,
      1,
      0,
      NULL,
      0.240567,
      1.363091,
      0.635313,
      1.936535,
      0,
      0,
      0,
      1.977385,
      0,
      0,
      2,
      0,
      NULL,
      2,
      2,
      5.609375,
      3.326595,
      1.695275,
      4.441186,
      3.834151,
      0.695170,
      1.146035,
      1.967548,
      NULL,
      2,
      NULL,
      1.308372,
      23.986794,
      NULL,
      NULL,
      NULL,
      1,
      3.439530,
      0.470783,
      '14102',
      '',
      '',
      1.740266,
      '',
      '',
      '',
      0.770333,
      NULL,
      '',
      NULL,
      0.108594,
      7.177740,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.887997,
      1,
      1,
      NULL,
      NULL,
      2.837522,
      0,
      1.908452,
      1,
      NULL,
      NULL,
      2,
      1,
      0,
      0.403054,
      NULL,
      NULL,
      NULL,
      NULL,
      1.453794,
      0.643487,
      NULL,
      NULL,
      0.423057,
      NULL,
      NULL,
      0.532979,
      NULL,
      NULL,
      0.160807,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      0.940976,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.045154,
      3,
      2,
      1,
      1.819522,
      NULL,
      0,
      0,
      0.214937,
      1.498631,
      1.249188,
      1.707131,
      1,
      0,
      NULL,
      3,
      0.554346,
      0,
      1.538513,
      1,
      2,
      NULL,
      1.588602,
      2,
      1.799107,
      1.801321,
      3,
      1.176047,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.405666,
      2,
      0,
      NULL,
      3.105546,
      0.576361,
      0.984359,
      1.146268,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.469205,
      NULL,
      NULL,
      NULL,
      NULL,
      1.018206,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1.881981,
      1.405576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.421471,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.717151,
      NULL,
      NULL,
      1.711482,
      NULL,
      NULL,
      0.849540,
      NULL,
      NULL,
      1.977388,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.429414,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.533024,
      NULL,
      0,
      NULL,
      NULL,
      1.035762,
      4.799872,
      NULL,
      0,
      2.584437,
      0,
      0,
      0.324437,
      NULL,
      1,
      NULL,
      0,
      0,
      1.483562,
      1,
      0.732156,
      6,
      1.115135,
      NULL,
      1,
      NULL,
      NULL,
      1.662032,
      NULL,
      NULL,
      1.742511,
      0.311320,
      NULL,
      NULL,
      NULL,
      0.784029,
      NULL,
      NULL,
      1.046312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.475595,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.878841,
      NULL,
      NULL,
      0.960357,
      NULL,
      NULL,
      1.672018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      2,
      2.635722,
      1,
      1.369160,
      1,
      1.158052,
      7.844306,
      NULL,
      NULL,
      NULL,
      33,
      NULL,
      NULL,
      NULL,
      1.867657,
      NULL,
      NULL,
      NULL,
      0.837720,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.716882,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.764096,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.870608,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.513937,
      NULL,
      NULL,
      NULL,
      1.303091,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.444362,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.647143,
      NULL,
      NULL,
      NULL,
      1.814531,
      NULL,
      NULL,
      3,
      4.881034,
      1,
      1,
      NULL,
      NULL,
      0.400330,
      NULL,
      NULL,
      0.958689,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1.857798,
      1.193783,
      0.822702,
      NULL,
      0,
      0,
      1.860542,
      0,
      0,
      1,
      0,
      NULL,
      0,
      0.580430,
      1.351903,
      1.843853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      0.543145,
      2.302956,
      2,
      5,
      13,
      0.240701,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1,
      0,
      0.682655,
      NULL,
      0,
      1,
      1.062358,
      NULL,
      1.805882,
      0.786966,
      2.275115,
      1,
      1.050700,
      0,
      NULL,
      1.012206,
      NULL,
      1,
      1,
      2.976874,
      0,
      1,
      1.356326,
      1,
      NULL,
      3.714608,
      0.420812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.498933,
      1.966059,
      1.998436,
      0.784146,
      1,
      2.870999,
      2,
      2.791911,
      1.013391,
      NULL,
      NULL,
      NULL,
      13,
      4,
      2,
      1,
      '42401',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


