set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-10-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '40',
      '11',
      9,
      29,
      '4313401',
      1.966329,
      1,
      0,
      NULL,
      NULL,
      3.126499,
      1.953853,
      NULL,
      NULL,
      NULL,
      28,
      28,
      NULL,
      1.927338,
      1.247650,
      ' 1-18-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      2.313371,
      NULL,
      ' 4-10-1991',
      ' 9- 8-1988',
      NULL,
      2.530709,
      1,
      0,
      1,
      0.506729,
      NULL,
      1,
      1.934753,
      NULL,
      6,
      NULL,
      2.535285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.573824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.156129,
      2.793989,
      NULL,
      NULL,
      1,
      1,
      3.261658,
      0,
      0,
      NULL,
      NULL,
      3.683151,
      1.922513,
      4,
      0,
      5,
      1.507680,
      3,
      0.171049,
      3.539018,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      6,
      3,
      0,
      0,
      3,
      NULL,
      2.173072,
      NULL,
      1,
      NULL,
      0.518220,
      0,
      NULL,
      1,
      0.665349,
      0,
      1,
      2,
      1,
      1,
      2.460599,
      1.463952,
      2,
      2.174882,
      NULL,
      NULL,
      NULL,
      1.299398,
      NULL,
      NULL,
      0.223397,
      0,
      1,
      NULL,
      0,
      1.391521,
      1.606908,
      1,
      0,
      NULL,
      0,
      1.106656,
      1,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      0.979965,
      NULL,
      NULL,
      1.702828,
      NULL,
      NULL,
      3,
      1,
      0,
      1,
      1.519820,
      0,
      2,
      0,
      1,
      0.385214,
      2.174145,
      0.276431,
      5,
      NULL,
      0,
      3.384664,
      4,
      0.277180,
      NULL,
      3,
      2.564291,
      ' 9-12-2000',
      8,
      ' 7-21-1993',
      NULL,
      1.031673,
      1.630573,
      3.986611,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.938114,
      0.944152,
      1,
      NULL,
      1.376830,
      NULL,
      1,
      0.808330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      6.837397,
      1,
      1.774602,
      2,
      1.104815,
      0.849644,
      NULL,
      1,
      3.828655,
      7.674694,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.839373,
      3.625154,
      0,
      2,
      0.233041,
      5,
      0,
      NULL,
      NULL,
      1,
      7.101029,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.635183,
      NULL,
      1.930293,
      1,
      1,
      1.404996,
      10.981807,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.020194,
      5,
      3.220118,
      2.833228,
      NULL,
      5,
      3.007483,
      5,
      3.198810,
      1.694253,
      NULL,
      0,
      NULL,
      3,
      0,
      0.368919,
      0,
      1.288524,
      NULL,
      1.204762,
      NULL,
      1,
      0.384744,
      1.908840,
      0,
      0.417283,
      0,
      1,
      NULL,
      NULL,
      1.438559,
      2.700637,
      3,
      0.577155,
      4.598981,
      7,
      2,
      2.051674,
      NULL,
      NULL,
      3,
      NULL,
      47.398287,
      0.636226,
      2,
      75,
      NULL,
      27,
      NULL,
      4,
      2.140381,
      3,
      '10031',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      17,
      14.951408,
      NULL,
      0.667700,
      28.221778,
      4.282152,
      0,
      0,
      3,
      1.600078,
      1,
      1,
      NULL,
      NULL,
      0.334261,
      NULL,
      NULL,
      1,
      1,
      0.051692,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.737992,
      3.910144,
      1.876158,
      1.954606,
      NULL,
      NULL,
      3,
      3.834982,
      2.235177,
      1.529537,
      NULL,
      NULL,
      1.043963,
      1.759829,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1,
      1,
      1,
      0,
      2,
      2.656198,
      0,
      1,
      0.852990,
      2,
      1.747026,
      3,
      3.080944,
      NULL,
      1.627390,
      3.651116,
      3.557836,
      3.193038,
      3.346025,
      3,
      3.621221,
      NULL,
      3,
      1.071419,
      0,
      NULL,
      NULL,
      1,
      2,
      1.907143,
      NULL,
      10.985513,
      1,
      0.683678,
      NULL,
      NULL,
      NULL,
      NULL,
      1.369883,
      NULL,
      NULL,
      NULL,
      1.224319,
      NULL,
      NULL,
      NULL,
      2,
      0.958286,
      1.089678,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.738533,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.398970,
      NULL,
      NULL,
      0.176558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.816628,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.672242,
      NULL,
      1.309073,
      2,
      2,
      NULL,
      0.237704,
      NULL,
      NULL,
      1.896087,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      NULL,
      2.392825,
      4,
      NULL,
      3.543033,
      0,
      0,
      0.938947,
      NULL,
      1,
      0.836226,
      NULL,
      NULL,
      3,
      NULL,
      3,
      0,
      3,
      NULL,
      3,
      6,
      2,
      3,
      1,
      7,
      NULL,
      1,
      1,
      1.253796,
      0,
      NULL,
      NULL,
      NULL,
      0.167737,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.942155,
      NULL,
      NULL,
      0.441828,
      NULL,
      NULL,
      0.959375,
      NULL,
      NULL,
      1.806851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.047049,
      NULL,
      0.412654,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.367355,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.023879,
      NULL,
      NULL,
      NULL,
      1.772568,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.349946,
      NULL,
      NULL,
      NULL,
      3.797785,
      NULL,
      NULL,
      NULL,
      3.064316,
      NULL,
      NULL,
      NULL,
      0.601029,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.263092,
      NULL,
      NULL,
      NULL,
      13.645957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      24.664621,
      NULL,
      1.062362,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.813952,
      NULL,
      NULL,
      1.981735,
      NULL,
      NULL,
      1.686513,
      NULL,
      NULL,
      1,
      NULL,
      0.058307,
      555,
      230,
      1,
      0,
      1,
      0.406028,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      0.455421,
      0.404009,
      NULL,
      0.248195,
      NULL,
      0.059503,
      1.894220,
      0.921924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.196456,
      7,
      1.918731,
      3.191488,
      5.558742,
      NULL,
      NULL,
      1.613646,
      10,
      0.400989,
      2.987483,
      1.747205,
      1.814031,
      1.877155,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      3.585508,
      NULL,
      0.178718,
      0.409883,
      NULL,
      3.265610,
      0,
      NULL,
      0,
      1.541032,
      NULL,
      2,
      1,
      NULL,
      2.586026,
      3,
      NULL,
      0,
      0,
      NULL,
      1,
      1.931871,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.744820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.580276,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      2,
      1,
      1,
      NULL,
      NULL,
      47.264548,
      2.011420,
      NULL,
      3,
      NULL,
      '14001',
      '',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      '3204',
      '',
      '');
commit;
end;
/


