set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7810402';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      '3432401',
      3.996990,
      NULL,
      0,
      2,
      '0412',
      2.856055,
      NULL,
      NULL,
      NULL,
      ' 2- 9-1998',
      59,
      NULL,
      1,
      1.238142,
      1.137554,
      ' 4- 4-1987',
      36,
      0.631203,
      73.492069,
      81,
      0.566363,
      ' 2-13-1975',
      NULL,
      ' 0- 5-1975',
      2,
      3.484522,
      3,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      300.227368,
      3.161644,
      7.757597,
      5.892439,
      27,
      38.210591,
      3.068705,
      4.873959,
      6.989292,
      0.006795,
      6,
      1.464252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      5,
      NULL,
      2.904927,
      0,
      1,
      NULL,
      2.897306,
      1.498277,
      0,
      NULL,
      2,
      3.180603,
      NULL,
      NULL,
      6.016652,
      NULL,
      5.779044,
      2,
      0.741935,
      0,
      NULL,
      NULL,
      0.387562,
      1,
      5.757632,
      9,
      3,
      NULL,
      NULL,
      0.135704,
      0.565473,
      NULL,
      0.906013,
      1.850017,
      0,
      2.423661,
      0.526968,
      0,
      1,
      NULL,
      2,
      NULL,
      NULL,
      1.730964,
      5.233182,
      1,
      NULL,
      9.851727,
      1.816112,
      0,
      NULL,
      0.189512,
      NULL,
      NULL,
      0.087219,
      1,
      3,
      1.810229,
      5.610398,
      NULL,
      NULL,
      NULL,
      0,
      1.616476,
      1,
      1.458839,
      0.458542,
      5.746116,
      0,
      0.822845,
      5,
      NULL,
      NULL,
      NULL,
      1.800033,
      1.729880,
      NULL,
      1.547458,
      4.634692,
      NULL,
      5.394136,
      6,
      0,
      7.407552,
      4.178250,
      1,
      NULL,
      6.002930,
      1.614627,
      3,
      NULL,
      0,
      5,
      8.836739,
      4.345997,
      NULL,
      5.913268,
      3.538974,
      8.044802,
      10.303885,
      5.406625,
      2.498807,
      0,
      1,
      3.685341,
      ' 1-28-1991',
      1323.733062,
      ' 9- 6-1988',
      674,
      3,
      0.966417,
      NULL,
      5.631274,
      1,
      NULL,
      2,
      0.057890,
      2.505725,
      1,
      1.397806,
      0,
      NULL,
      0,
      0.319242,
      1.332159,
      0.393671,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.138110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.445515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.876632,
      NULL,
      3,
      1,
      0,
      2.821722,
      NULL,
      NULL,
      NULL,
      1,
      7.711961,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      98,
      ' 0-28-2002',
      6,
      0,
      1.614536,
      1,
      0,
      NULL,
      1.017466,
      1.451214,
      NULL,
      1,
      0,
      1.543767,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.853497,
      1.483958,
      3,
      1.633238,
      0,
      NULL,
      1.345750,
      0.402043,
      0,
      NULL,
      0.236047,
      0.424227,
      2,
      13,
      7,
      NULL,
      NULL,
      116.627027,
      101.299316,
      87,
      135,
      0.902845,
      NULL,
      0,
      1.159428,
      NULL,
      1,
      1,
      7,
      12,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      8.509261,
      18.510711,
      42,
      5.196237,
      NULL,
      3,
      '01332',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      1.101833,
      '',
      '',
      '',
      2,
      22,
      17.880645,
      6.580386,
      NULL,
      9,
      12.838119,
      12.744817,
      1.964711,
      NULL,
      NULL,
      0.399849,
      0.049313,
      NULL,
      NULL,
      1.347531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.638834,
      NULL,
      NULL,
      1.480541,
      NULL,
      NULL,
      3.154548,
      2,
      1,
      1.927204,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.068323,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.755578,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.884200,
      1.238737,
      NULL,
      0,
      NULL,
      1.918418,
      1,
      1,
      NULL,
      NULL,
      2.914618,
      0,
      1,
      1.896357,
      NULL,
      1.859910,
      1,
      2,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.327507,
      NULL,
      NULL,
      NULL,
      NULL,
      2.777502,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.764292,
      0,
      6,
      1.874393,
      NULL,
      NULL,
      0.638672,
      NULL,
      NULL,
      NULL,
      0.814569,
      0.125979,
      2,
      NULL,
      0.414379,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      0.113297,
      0.546359,
      0.105404,
      NULL,
      NULL,
      0.588220,
      0.397559,
      NULL,
      3,
      1.111610,
      1.954103,
      NULL,
      NULL,
      NULL,
      8.788870,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.691585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.664107,
      NULL,
      NULL,
      NULL,
      0.233438,
      0.040705,
      6,
      1,
      1,
      4.255105,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      3.556490,
      0.457362,
      0.449560,
      3,
      0,
      NULL,
      2,
      4.967686,
      2,
      0.476661,
      NULL,
      2,
      0.276408,
      NULL,
      3,
      0.979503,
      1.902869,
      NULL,
      3.808880,
      1.078391,
      0.416883,
      7.212251,
      4,
      5,
      6,
      4,
      3.736583,
      2.526595,
      1.254134,
      NULL,
      0,
      0.758558,
      1.430763,
      0.313763,
      0.233580,
      3.965070,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.622858,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.708137,
      NULL,
      NULL,
      0.908377,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.062768,
      0.940864,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2.050429,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.391901,
      0.851065,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1,
      1.686543,
      NULL,
      NULL,
      2.399688,
      NULL,
      NULL,
      NULL,
      3,
      1.695387,
      1,
      NULL,
      3.132633,
      0.639185,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.859306,
      1.654242,
      NULL,
      NULL,
      1.757152,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.752786,
      NULL,
      2.550681,
      NULL,
      0.305345,
      NULL,
      NULL,
      NULL,
      0.171291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.812964,
      0.087488,
      NULL,
      3.693526,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.645659,
      NULL,
      7.217606,
      2,
      0.053229,
      10.868772,
      1.195361,
      0,
      320,
      93.066100,
      3.091670,
      13,
      NULL,
      0.353036,
      NULL,
      NULL,
      1,
      3.974568,
      NULL,
      1,
      6.646420,
      5.550508,
      1.990807,
      NULL,
      NULL,
      0,
      NULL,
      1,
      409,
      NULL,
      0.357929,
      2,
      NULL,
      NULL,
      0,
      1.218264,
      NULL,
      2.669331,
      0.198164,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.668292,
      0.999627,
      2,
      NULL,
      1.257033,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.297744,
      NULL,
      3,
      NULL,
      47.673537,
      NULL,
      3.659846,
      13.057753,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.703987,
      NULL,
      1.327718,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.616029,
      NULL,
      1.123201,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.845367,
      NULL,
      0.746300,
      0,
      0.713403,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.929186,
      NULL,
      NULL,
      NULL,
      1.343994,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.668053,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.021784,
      NULL,
      NULL,
      0.422251,
      NULL,
      NULL,
      NULL,
      NULL,
      0.399868,
      NULL,
      142,
      NULL,
      0.241145,
      NULL,
      NULL,
      NULL,
      1.432845,
      NULL,
      1,
      NULL,
      1.508768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.500824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.342790,
      3.102841,
      NULL,
      1.796014,
      NULL,
      0.795924,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.863694,
      11.561118,
      40.596378,
      1.218904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.007757,
      NULL,
      3.892284,
      1.806909,
      2,
      10.530516,
      1.539055,
      NULL,
      2.179591,
      0.560371,
      NULL,
      0.684620,
      0.398285,
      1,
      0.837227,
      NULL,
      1,
      3.913808,
      0.065983,
      0,
      0.351391,
      0.646460,
      0,
      0.948361,
      0,
      NULL,
      0,
      1.917566,
      1,
      1.856458,
      0,
      3,
      3,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      0,
      1,
      NULL,
      2.003988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.238369,
      NULL,
      NULL,
      NULL,
      1.775133,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.978104,
      NULL,
      1,
      NULL,
      0.810601,
      NULL,
      1.114968,
      NULL,
      0,
      37,
      3.333929,
      NULL,
      1.654204,
      0.293932,
      0,
      NULL,
      0,
      NULL,
      4,
      10,
      10.295712,
      3.412241,
      0.505606,
      1,
      55.361322,
      30.852968,
      1.028142,
      1.882267,
      3.772739,
      NULL,
      '10100',
      '',
      NULL,
      '',
      '',
      NULL,
      0.514687,
      NULL,
      '',
      '');
commit;
end;
/


