set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8906739';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      NULL,
      0.661076,
      1,
      5,
      3,
      '4120',
      2,
      1.604687,
      NULL,
      NULL,
      ' 8-11-1991',
      27,
      NULL,
      NULL,
      NULL,
      0.267126,
      ' 6- 3-1977',
      9.252499,
      3,
      168.282437,
      35.512071,
      0,
      NULL,
      ' 6-10-1983',
      ' 7-21-1982',
      0.309786,
      0.481254,
      0,
      3.776735,
      1,
      2,
      2.346827,
      1,
      0,
      2.302558,
      9.972472,
      1,
      2.001355,
      8.900026,
      18,
      4,
      NULL,
      1.398079,
      1,
      1.336073,
      NULL,
      1,
      1.473687,
      1,
      1,
      0,
      1.322077,
      1.771544,
      1.876312,
      NULL,
      1,
      0,
      0.156210,
      NULL,
      2.765126,
      3,
      1,
      1.353789,
      0.347977,
      0.326310,
      1,
      NULL,
      1.348878,
      NULL,
      1.460838,
      0.715381,
      NULL,
      2.095588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.604501,
      NULL,
      1.511308,
      0.010907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.716337,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.280495,
      3.462220,
      0.998634,
      4,
      0.794455,
      1,
      1,
      1.629609,
      0.357187,
      0,
      1,
      0.311760,
      1,
      0,
      NULL,
      0,
      0,
      0.505382,
      NULL,
      NULL,
      4,
      3,
      NULL,
      0.126981,
      0.856069,
      1,
      NULL,
      NULL,
      4.555969,
      0.473101,
      NULL,
      3,
      NULL,
      NULL,
      4.091284,
      1.317015,
      2.903633,
      2,
      3,
      0,
      2.952882,
      NULL,
      2,
      1,
      NULL,
      NULL,
      3.682013,
      ' 7-23-1977',
      NULL,
      ' 8- 0-1985',
      NULL,
      1.874308,
      NULL,
      0,
      9,
      0.610587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.172300,
      1,
      1.034384,
      0,
      0,
      NULL,
      1.199632,
      0.608775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.685718,
      2.576978,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.043125,
      NULL,
      0,
      1.328810,
      7.633583,
      3,
      1.590603,
      0,
      0.170164,
      2.522109,
      0.485773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.601676,
      0,
      0,
      0,
      NULL,
      27,
      NULL,
      1.562399,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.441338,
      3,
      0,
      1,
      NULL,
      NULL,
      1.082339,
      3,
      NULL,
      2.783822,
      3.255457,
      1.722913,
      NULL,
      0,
      3.731628,
      1,
      NULL,
      NULL,
      0.623228,
      NULL,
      1,
      0.212705,
      1.108722,
      1.701157,
      1.255517,
      1,
      0.645878,
      1.503969,
      1.591644,
      1,
      10,
      0.229654,
      1,
      6.286142,
      9,
      5,
      0,
      NULL,
      1.377146,
      1.217417,
      0,
      NULL,
      3,
      1.014294,
      NULL,
      NULL,
      62.592511,
      16,
      95,
      0.227984,
      NULL,
      4,
      '31230',
      '44112',
      '',
      1,
      '',
      '',
      '',
      0.719631,
      '',
      '',
      '',
      1,
      22.086882,
      48,
      3.415846,
      1.414919,
      NULL,
      5.681003,
      1.498788,
      4,
      0,
      1,
      1.537788,
      1.629065,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.312157,
      NULL,
      NULL,
      2.533427,
      0,
      1,
      0.747145,
      NULL,
      NULL,
      0.231653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      7.810247,
      0,
      1.447784,
      1.192946,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.129102,
      0.859285,
      1.524802,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.560123,
      0.601547,
      0,
      1.904528,
      1.068888,
      0.477001,
      0.716509,
      0.851992,
      0.821808,
      0.295837,
      1.971026,
      0,
      0.431013,
      NULL,
      NULL,
      0.931894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.390663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.579547,
      1.266331,
      NULL,
      3,
      3.176202,
      NULL,
      0.811361,
      NULL,
      NULL,
      6.868999,
      6,
      1,
      0,
      NULL,
      NULL,
      0.889165,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.637190,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.138311,
      2,
      0.134498,
      0.053975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.052907,
      1.827561,
      3,
      NULL,
      1.207448,
      1,
      NULL,
      0.825881,
      NULL,
      2.348926,
      0.444571,
      NULL,
      NULL,
      NULL,
      1.414822,
      NULL,
      NULL,
      1.442521,
      3.156332,
      1.030592,
      1.916817,
      NULL,
      NULL,
      4,
      4.082964,
      2.988763,
      0,
      NULL,
      NULL,
      3.347681,
      3.289893,
      2,
      0,
      NULL,
      0,
      0,
      0,
      0.921831,
      NULL,
      NULL,
      1.492245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.573443,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.944199,
      NULL,
      NULL,
      0.836022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.452414,
      0,
      0,
      0,
      NULL,
      NULL,
      1.640991,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      2.820719,
      NULL,
      NULL,
      NULL,
      2.454238,
      NULL,
      NULL,
      NULL,
      1.000786,
      NULL,
      NULL,
      NULL,
      0,
      1.328555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.307831,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.231019,
      NULL,
      NULL,
      NULL,
      0.955831,
      NULL,
      NULL,
      NULL,
      0.177086,
      NULL,
      NULL,
      NULL,
      1,
      1.607769,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.472420,
      1.232492,
      NULL,
      NULL,
      0.995886,
      1,
      NULL,
      NULL,
      1,
      2.767440,
      NULL,
      NULL,
      NULL,
      0.516130,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.188345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.394149,
      0.653436,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      83,
      0,
      0.302141,
      1.267904,
      0.666836,
      0,
      1.633246,
      1.709344,
      NULL,
      1.374722,
      1.648469,
      0,
      1,
      1.490050,
      0,
      1.231556,
      1.735073,
      0,
      0.310962,
      0.848819,
      2,
      NULL,
      NULL,
      NULL,
      1.933936,
      NULL,
      2.215583,
      NULL,
      NULL,
      NULL,
      59,
      NULL,
      NULL,
      NULL,
      14.032881,
      NULL,
      NULL,
      1.062894,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.835607,
      NULL,
      1.933117,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.971173,
      NULL,
      1,
      NULL,
      0.635057,
      NULL,
      1.261150,
      NULL,
      1.552239,
      NULL,
      1,
      NULL,
      1.689030,
      NULL,
      1.381887,
      NULL,
      1.474237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      3.299117,
      NULL,
      2,
      2.157832,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.384755,
      0,
      NULL,
      NULL,
      1.038065,
      0.779946,
      1.095996,
      1,
      0,
      NULL,
      NULL,
      0,
      1.304167,
      NULL,
      0,
      1.104164,
      3,
      3,
      0,
      1.530628,
      1.848900,
      1.720405,
      NULL,
      0,
      0,
      1.805133,
      1,
      1,
      3,
      3.993526,
      1.942336,
      NULL,
      NULL,
      1,
      3.888510,
      1.581459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.427632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.309285,
      NULL,
      1,
      NULL,
      NULL,
      0.867352,
      3,
      2,
      1.297697,
      NULL,
      NULL,
      59.734883,
      74,
      0,
      NULL,
      1,
      '33122',
      '00232',
      '',
      0.165454,
      '',
      NULL,
      '',
      0.730724,
      '',
      '',
      '');
commit;
end;
/


