set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8119304';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      4.918687,
      0.198627,
      9,
      2.026510,
      6.960485,
      NULL,
      0.828648,
      0,
      NULL,
      '41243244',
      NULL,
      20.727115,
      '1243034',
      3.512020,
      1,
      NULL,
      NULL,
      '4443',
      3.560426,
      1,
      NULL,
      NULL,
      ' 9-21-1986',
      27,
      7,
      NULL,
      2.797074,
      3.640583,
      ' 9-24-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      3.216813,
      ' 4-21-1977',
      ' 4-29-1980',
      ' 2- 5-1998',
      1.834723,
      2.173577,
      0,
      2,
      1.330996,
      NULL,
      NULL,
      1.483898,
      0.246021,
      37.638151,
      11.479158,
      15.365823,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.473598,
      NULL,
      1.098288,
      0,
      1.419747,
      NULL,
      0,
      NULL,
      1.066796,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1,
      1.721843,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      7,
      4,
      NULL,
      0.037766,
      7.440308,
      1,
      0.622774,
      1.331389,
      3,
      0,
      NULL,
      NULL,
      0.845344,
      0,
      2.073601,
      7.302617,
      0,
      0,
      0.357667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.191579,
      0,
      1,
      0.031260,
      NULL,
      0,
      1.009444,
      NULL,
      NULL,
      2.815190,
      0,
      NULL,
      1,
      1,
      4.707435,
      1.498776,
      4.276071,
      NULL,
      NULL,
      NULL,
      1.431027,
      0,
      NULL,
      NULL,
      0,
      1,
      1.909102,
      0.122862,
      1,
      1.961283,
      1.664775,
      NULL,
      0.570087,
      1.257002,
      0,
      NULL,
      5,
      1.500146,
      3,
      NULL,
      1,
      4.409975,
      7.152281,
      NULL,
      1,
      6.204460,
      0,
      3,
      3,
      1,
      7,
      8.089460,
      0.329509,
      NULL,
      5.429369,
      NULL,
      3,
      3.814336,
      3.822711,
      NULL,
      ' 6- 1-1999',
      26,
      ' 8-20-1996',
      0.289958,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.264731,
      0,
      1.721941,
      1.498475,
      1.322846,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.938172,
      0,
      3,
      NULL,
      3.746563,
      3,
      2.652964,
      0.831189,
      0,
      0.535608,
      3,
      6,
      2.059042,
      0.226827,
      3.939427,
      1.596758,
      4,
      ' 7- 1-1999',
      0.621056,
      '10-29-1984',
      NULL,
      1,
      0.162451,
      0.923453,
      1.992477,
      1.631536,
      0,
      0.183314,
      1,
      1.648602,
      0,
      2.337245,
      3.781860,
      0.384685,
      1,
      NULL,
      NULL,
      NULL,
      2.098485,
      1,
      2.159204,
      3,
      NULL,
      3.806621,
      1.712430,
      3.958202,
      2,
      3.697903,
      2,
      2.258896,
      3.425047,
      3.818619,
      NULL,
      3.454824,
      3.613707,
      1,
      0,
      NULL,
      1.899511,
      0,
      0.507198,
      1.968096,
      0.908785,
      1,
      NULL,
      1.788352,
      1.611516,
      1.619017,
      NULL,
      1,
      7.185537,
      2.752252,
      4,
      3,
      2,
      4,
      0,
      NULL,
      5,
      0,
      3.377075,
      3.025896,
      30,
      3,
      1,
      48.484924,
      NULL,
      33,
      15.676568,
      1.011448,
      2,
      1.244916,
      '10020',
      '42304',
      '',
      2,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.239824,
      29,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.554592,
      NULL,
      12,
      0,
      1,
      NULL,
      NULL,
      1.186246,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.436187,
      27,
      3.149483,
      3.701242,
      1.860736,
      1.178183,
      1,
      1,
      0,
      1.725786,
      1,
      1.495077,
      0.162166,
      NULL,
      0.980722,
      1,
      NULL,
      0,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.375864,
      NULL,
      19,
      NULL,
      1,
      1.084915,
      NULL,
      0,
      NULL,
      1.669279,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.506866,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.040459,
      NULL,
      1.040341,
      NULL,
      1,
      NULL,
      0.670027,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.944317,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.304622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.223139,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.068089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.064419,
      2.651540,
      NULL,
      3,
      NULL,
      3.619302,
      NULL,
      202.625815,
      NULL,
      NULL,
      NULL,
      1.616258,
      NULL,
      0.627590,
      1.245950,
      0,
      23,
      NULL,
      2,
      1,
      2,
      2.053806,
      5.668556,
      NULL,
      2,
      NULL,
      1.156406,
      1,
      3.581982,
      3,
      9,
      2.183662,
      3.083829,
      1,
      0.037553,
      0,
      NULL,
      1,
      1,
      NULL,
      0.431458,
      0.208609,
      NULL,
      1,
      1.067393,
      NULL,
      3,
      1,
      NULL,
      1,
      3,
      NULL,
      0,
      0,
      NULL,
      1.200128,
      0.026694,
      NULL,
      1,
      0,
      NULL,
      2,
      1,
      NULL,
      0.697969,
      1.254771,
      NULL,
      2,
      1,
      0.836027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.704289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.486523,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.215239,
      NULL,
      2,
      0.869611,
      2,
      NULL,
      31.145312,
      NULL,
      0.538832,
      1,
      4.324213,
      NULL,
      '33400',
      NULL,
      NULL,
      '4422',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '');
commit;
end;
/


