set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8929504';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-6-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '1022130',
      1,
      0.740975,
      2,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      ' 6- 7-1999',
      NULL,
      NULL,
      0,
      NULL,
      0.107669,
      ' 6- 3-1977',
      8.057467,
      3.603413,
      155,
      29,
      3,
      NULL,
      ' 1-24-1993',
      NULL,
      NULL,
      3.190161,
      0,
      NULL,
      1,
      0.385154,
      3,
      NULL,
      0.457992,
      25.053863,
      NULL,
      10,
      7.511421,
      133,
      9.958188,
      NULL,
      20,
      3,
      0.436137,
      7.968033,
      0.499337,
      0,
      0.386212,
      1,
      1,
      0,
      NULL,
      1.363897,
      0,
      0.237283,
      194,
      NULL,
      1.632095,
      4,
      0.766671,
      NULL,
      0,
      6.945818,
      3.752294,
      4,
      5.703653,
      5.039292,
      NULL,
      NULL,
      2.173783,
      3.039913,
      3.251465,
      NULL,
      3.920564,
      4,
      NULL,
      1,
      1.013093,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9.652486,
      7.032660,
      4,
      1,
      NULL,
      1.868651,
      1,
      0,
      3,
      3,
      0,
      3,
      0,
      2,
      1,
      0.322705,
      0,
      1.460532,
      NULL,
      2,
      NULL,
      4.959252,
      6.598834,
      0.903588,
      NULL,
      3,
      1.038956,
      NULL,
      NULL,
      0.844413,
      NULL,
      NULL,
      1,
      3,
      7,
      4.840552,
      NULL,
      4.323638,
      8,
      1.328112,
      9.662216,
      0.515297,
      2,
      2,
      2.496760,
      10.484802,
      0,
      1,
      0,
      0.789150,
      0.863986,
      NULL,
      0.570888,
      5.496266,
      5.124976,
      5,
      11.446375,
      1.113265,
      7,
      3,
      0.781965,
      NULL,
      5.431461,
      NULL,
      2,
      NULL,
      10,
      7,
      4,
      6,
      8,
      7,
      NULL,
      1.589651,
      1,
      5.421585,
      0,
      8,
      6.823181,
      3.464612,
      ' 4- 0-1996',
      381,
      ' 6-19-2000',
      NULL,
      1.304208,
      1.447039,
      1,
      0.353024,
      1.941007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.727133,
      5,
      NULL,
      2,
      NULL,
      0.471185,
      2.033483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.778026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.473207,
      1,
      0,
      NULL,
      2,
      1,
      4.512234,
      1.201606,
      NULL,
      0.431833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.565919,
      0,
      2.303992,
      0.215992,
      0.434946,
      1.898864,
      NULL,
      336,
      NULL,
      2,
      29.801634,
      2,
      126,
      1.005188,
      NULL,
      3,
      NULL,
      1.257956,
      1,
      3.387633,
      0,
      1.783504,
      0,
      NULL,
      1,
      3.032776,
      NULL,
      0.284944,
      0.707781,
      NULL,
      1.557010,
      3,
      1.929286,
      NULL,
      1.841004,
      0.768258,
      0,
      NULL,
      3.705906,
      0.303805,
      NULL,
      NULL,
      1,
      3.588709,
      1.944010,
      7.562384,
      10.217295,
      5,
      2.945699,
      7,
      1,
      2,
      1.013532,
      0,
      0,
      NULL,
      2.121010,
      18,
      3,
      3.848179,
      NULL,
      10.926071,
      NULL,
      26,
      0,
      0,
      1,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      '31222',
      '',
      '',
      3,
      18,
      138.218322,
      12.612682,
      NULL,
      NULL,
      12.727688,
      31.342027,
      NULL,
      2.954101,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2.898913,
      1.654473,
      3.555369,
      0,
      0,
      NULL,
      NULL,
      1.159949,
      1,
      1.798396,
      0.085726,
      3,
      3.599283,
      1.160904,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.624126,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.373054,
      NULL,
      NULL,
      4.695702,
      9.750293,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.084299,
      2,
      NULL,
      1,
      NULL,
      3,
      2.535483,
      2.154448,
      3.079812,
      2.007919,
      0.112223,
      NULL,
      3,
      3.058017,
      0,
      0.974085,
      0,
      1,
      1.031129,
      0,
      NULL,
      NULL,
      1.540815,
      3.438494,
      1.565093,
      NULL,
      NULL,
      1.903408,
      NULL,
      NULL,
      2.974398,
      NULL,
      NULL,
      0,
      0.039650,
      1.787074,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.058642,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2,
      0,
      3,
      NULL,
      1.269305,
      NULL,
      NULL,
      NULL,
      2.102127,
      2,
      NULL,
      2,
      1.513192,
      1,
      NULL,
      1.387387,
      NULL,
      NULL,
      0.869379,
      0.513273,
      1.463555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.118470,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.175228,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.105334,
      1.872495,
      0,
      1.657411,
      7.088445,
      1.536954,
      1.946465,
      0.314260,
      1.628102,
      0,
      NULL,
      9.992260,
      NULL,
      0,
      0.246727,
      0.122510,
      NULL,
      1,
      1.270715,
      0.619821,
      NULL,
      0.515745,
      4.723829,
      8.936338,
      0,
      NULL,
      0.067690,
      1.246620,
      1.769430,
      1.022607,
      1,
      0,
      NULL,
      NULL,
      3.444543,
      3,
      3.868085,
      NULL,
      3.292457,
      NULL,
      7.607671,
      3.800898,
      3.027072,
      1,
      1.365382,
      6,
      NULL,
      0.465680,
      1.048788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.083220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.161808,
      1.237758,
      1.415839,
      0,
      3.226674,
      3.900792,
      NULL,
      NULL,
      0.486365,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.078861,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.069154,
      0.655846,
      NULL,
      NULL,
      1,
      1.845938,
      NULL,
      NULL,
      0.462399,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.929084,
      NULL,
      NULL,
      NULL,
      0.451030,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.787656,
      NULL,
      NULL,
      0.892026,
      0.843669,
      NULL,
      NULL,
      1.140897,
      1,
      NULL,
      NULL,
      2,
      0.046135,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.869098,
      5.650429,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.410979,
      7,
      NULL,
      3.460639,
      3.716329,
      2.165614,
      0,
      NULL,
      NULL,
      0,
      2.020059,
      1.764590,
      0.531899,
      NULL,
      NULL,
      0.470030,
      11,
      0.508163,
      1,
      NULL,
      NULL,
      NULL,
      0.863936,
      NULL,
      1.894426,
      0.075838,
      0.331497,
      0,
      1,
      NULL,
      0,
      0.518077,
      3,
      0,
      0,
      0,
      0.763927,
      0,
      1.082239,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.866938,
      NULL,
      NULL,
      NULL,
      0.255044,
      NULL,
      0,
      NULL,
      0.152820,
      NULL,
      1.411376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.349124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.569567,
      1.740408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.117909,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.883087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.404960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.691331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.954927,
      NULL,
      0.270804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.830119,
      NULL,
      0,
      1,
      1.784707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.664542,
      3.395040,
      2,
      2,
      2.432543,
      NULL,
      1,
      4,
      3.133537,
      1.928397,
      0.442769,
      NULL,
      0.976256,
      NULL,
      0.235491,
      0.288446,
      0,
      0,
      1.031206,
      1.234861,
      0.954963,
      0.803668,
      1,
      1,
      1.886266,
      1,
      0.925798,
      NULL,
      0.343651,
      NULL,
      1,
      0.214422,
      NULL,
      1,
      0,
      1,
      1.049211,
      0.283760,
      NULL,
      0,
      1,
      0.117779,
      1.991193,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.672650,
      1,
      NULL,
      4,
      8.570326,
      10,
      1,
      0.817954,
      0,
      14.105580,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      NULL,
      '',
      '');
commit;
end;
/


