set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6516689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10',
      '13',
      NULL,
      26,
      '4231120',
      NULL,
      0.294595,
      2,
      2,
      '1011',
      3,
      1.565312,
      NULL,
      NULL,
      ' 2-15-1996',
      68.900815,
      3.041336,
      NULL,
      2.676007,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 6- 1-1974',
      '11-18-2001',
      '10-19-1995',
      NULL,
      2.127520,
      NULL,
      NULL,
      1.880488,
      3,
      7,
      0.717006,
      1,
      91,
      3.990887,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.710910,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7,
      3,
      0,
      1,
      1.011961,
      0.110097,
      NULL,
      1.118491,
      NULL,
      9,
      NULL,
      NULL,
      2.018128,
      0,
      1.449224,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      0.924965,
      3.061596,
      1.541525,
      1,
      1.935927,
      0,
      0.112587,
      0,
      3,
      1,
      NULL,
      1,
      1.058976,
      3.156309,
      1.236673,
      3.956928,
      2.975915,
      0.534486,
      1,
      NULL,
      5.293636,
      1,
      0.132810,
      NULL,
      1.952561,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1.578014,
      1,
      1.383395,
      0.852288,
      1,
      0,
      NULL,
      0,
      0.474745,
      0.830277,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      0.131516,
      0.165860,
      1,
      0,
      NULL,
      1.656255,
      0,
      3.971357,
      NULL,
      3,
      0,
      1.689041,
      0,
      1,
      1.872691,
      6,
      NULL,
      1,
      3,
      9.718227,
      3,
      0.240008,
      0.634594,
      NULL,
      0.651737,
      0,
      0.152080,
      3,
      '10-10-1978',
      890.256470,
      NULL,
      912.433207,
      1,
      0.380501,
      1,
      0,
      2.250748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.457107,
      0.987238,
      1,
      NULL,
      1,
      NULL,
      0.681249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.568744,
      NULL,
      0.299577,
      0.191231,
      3.606607,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.853490,
      1,
      1,
      NULL,
      NULL,
      3,
      1.489323,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.702011,
      1,
      NULL,
      0,
      1.180456,
      0.303289,
      1.902247,
      1.097136,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.647800,
      2,
      NULL,
      3,
      0.016303,
      2,
      2.240261,
      3,
      1,
      NULL,
      3.922956,
      0,
      1,
      0.313784,
      1,
      0,
      5,
      NULL,
      1,
      1,
      0.162651,
      1.685871,
      NULL,
      0.798986,
      1.968609,
      NULL,
      NULL,
      4.037154,
      0.036501,
      10,
      6.599373,
      3,
      NULL,
      8,
      1,
      0.045405,
      0.204833,
      1,
      3.476295,
      2,
      2.844383,
      33.733035,
      3,
      0,
      21,
      NULL,
      44.059304,
      NULL,
      2.993272,
      NULL,
      2,
      '14121',
      NULL,
      '',
      0.808463,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0.873409,
      NULL,
      248.396474,
      23,
      1.165737,
      36,
      27.656210,
      5,
      NULL,
      NULL,
      2.645174,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.073337,
      2.148328,
      NULL,
      0.627727,
      1.615302,
      NULL,
      NULL,
      NULL,
      0.720969,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.757490,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.662448,
      NULL,
      NULL,
      9.069572,
      NULL,
      3.028368,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      2,
      3,
      0,
      2,
      1.259319,
      NULL,
      NULL,
      0.728848,
      NULL,
      NULL,
      1.954477,
      NULL,
      1,
      2,
      1.530858,
      0.458461,
      NULL,
      2,
      1.693211,
      2,
      NULL,
      0,
      2.013875,
      1,
      NULL,
      3.393115,
      1,
      NULL,
      NULL,
      1.598670,
      NULL,
      NULL,
      3,
      1.671542,
      NULL,
      9,
      5,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3.847582,
      NULL,
      1.650123,
      2,
      0,
      NULL,
      NULL,
      0,
      1,
      1.616341,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.158500,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.822412,
      NULL,
      NULL,
      1.001362,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.105011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.594507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.161336,
      NULL,
      NULL,
      2.414961,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      2,
      NULL,
      3.876435,
      0.406095,
      NULL,
      0.569773,
      NULL,
      NULL,
      5,
      NULL,
      7,
      NULL,
      3.822180,
      1,
      2.249619,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.390950,
      0.385205,
      0,
      NULL,
      1.212562,
      0,
      NULL,
      NULL,
      0.153276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.044506,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.358172,
      NULL,
      NULL,
      1.434218,
      NULL,
      NULL,
      2,
      3,
      0.044770,
      NULL,
      1,
      3.587534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.869754,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.924179,
      NULL,
      NULL,
      NULL,
      1.756160,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.508839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.952217,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.491522,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      5.012721,
      5.318932,
      3.019194,
      2,
      33.266715,
      10,
      1.113252,
      NULL,
      28,
      NULL,
      NULL,
      NULL,
      3.776699,
      26,
      0,
      3,
      NULL,
      0.056910,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.061512,
      92.801741,
      NULL,
      0.663332,
      0.584509,
      0.526484,
      NULL,
      0,
      0.072995,
      1.020655,
      1,
      0.917103,
      1.408952,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0.298149,
      NULL,
      1.750188,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51.675497,
      50.858668,
      2,
      0.489265,
      3,
      NULL,
      0.392550,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.502902,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.175596,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.924837,
      1,
      1.729705,
      0.866954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.934387,
      1.077574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.930525,
      1.770063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.603573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.843136,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.705553,
      NULL,
      0.232770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.490809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      0.070403,
      1.967316,
      0,
      NULL,
      1.685876,
      0,
      0.677814,
      1.220988,
      NULL,
      NULL,
      0,
      3.433975,
      NULL,
      1,
      1.313508,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0.716801,
      NULL,
      NULL,
      0,
      NULL,
      1.904021,
      0.678761,
      NULL,
      0,
      3.814114,
      NULL,
      1,
      0.719011,
      NULL,
      NULL,
      0,
      0.943435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.947900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.172616,
      NULL,
      3.197350,
      8,
      2,
      1.959510,
      NULL,
      NULL,
      20.000906,
      NULL,
      5.889565,
      3.272694,
      5.355284,
      '42143',
      '24322',
      '',
      0.600687,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


