set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9880269';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.891339,
      1,
      2.489250,
      1,
      3,
      NULL,
      4,
      3,
      '421',
      '42004032',
      52,
      32,
      NULL,
      2.179100,
      0.069899,
      3,
      1,
      '2013',
      0,
      1,
      NULL,
      NULL,
      ' 0-18-1976',
      NULL,
      155,
      NULL,
      2,
      0.314207,
      ' 6-28-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 7-26-1988',
      ' 6-19-1986',
      ' 5-11-1977',
      0,
      3,
      NULL,
      0,
      0,
      0.686506,
      NULL,
      0.847426,
      0,
      5,
      6,
      12,
      1.205474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.053573,
      NULL,
      3.453760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      3,
      1,
      1.598265,
      NULL,
      0.690068,
      NULL,
      NULL,
      5,
      1.372792,
      0,
      0,
      1.964556,
      1.420959,
      NULL,
      1,
      0.399517,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.989124,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.423798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      5.144920,
      NULL,
      6.476784,
      7,
      2,
      0.944986,
      1.798565,
      7,
      2,
      0.836380,
      0.789476,
      4,
      1.950646,
      NULL,
      1.982945,
      NULL,
      1,
      NULL,
      0.191897,
      0,
      0.440135,
      0.946863,
      0,
      1,
      NULL,
      0,
      0.991849,
      0,
      4,
      0.381241,
      NULL,
      4,
      3,
      4.840182,
      9,
      1,
      0.932287,
      NULL,
      NULL,
      4.815387,
      5,
      5.650668,
      1,
      1,
      NULL,
      NULL,
      ' 9-29-2000',
      390,
      NULL,
      NULL,
      2.301856,
      1,
      0.284796,
      3,
      0.627178,
      NULL,
      6,
      0,
      2,
      0.051992,
      5,
      5.463190,
      4,
      5,
      4.849462,
      1.017939,
      1,
      3.579079,
      0,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.698475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.238501,
      1.880218,
      3.775778,
      1.877563,
      NULL,
      3.007898,
      1.581116,
      NULL,
      NULL,
      NULL,
      NULL,
      3.331881,
      0.631651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.554136,
      NULL,
      0.818967,
      0,
      1.006492,
      3,
      14,
      1.674295,
      NULL,
      NULL,
      NULL,
      NULL,
      1.655863,
      0.708878,
      2.029281,
      0,
      2.380580,
      0.893723,
      1.978992,
      1,
      3.389152,
      0.547765,
      2.179921,
      1.745010,
      1,
      NULL,
      0,
      2.314600,
      1,
      0.598617,
      1.831997,
      5,
      0.827251,
      1,
      0,
      1,
      0.031990,
      NULL,
      NULL,
      0,
      1,
      0,
      2,
      1.193513,
      11.483158,
      2.932953,
      7.473877,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      5.954085,
      3,
      2,
      1,
      15.176916,
      2,
      3.545479,
      NULL,
      NULL,
      43,
      17,
      5,
      1.473361,
      0,
      NULL,
      '',
      '',
      0.255001,
      NULL,
      '',
      '',
      0.051388,
      '',
      '',
      '',
      0.252735,
      24.704048,
      35.700818,
      8.395330,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      3.653503,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      2.748518,
      1,
      NULL,
      NULL,
      0.882437,
      NULL,
      NULL,
      2,
      NULL,
      3.048489,
      0,
      NULL,
      NULL,
      1.279853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.069938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      3.105293,
      6,
      0.475231,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.625172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.727822,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.750405,
      NULL,
      NULL,
      1.139589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.541928,
      NULL,
      NULL,
      3.663012,
      3,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      3,
      NULL,
      0,
      0.335878,
      3.908190,
      1,
      3.340116,
      4.709663,
      5,
      4.173437,
      0,
      NULL,
      NULL,
      1.431626,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.504453,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2.940589,
      6.605295,
      3.560392,
      NULL,
      2,
      1.875544,
      3.614173,
      0,
      1.851019,
      4,
      3.581616,
      1.072099,
      0.984552,
      0.465888,
      3,
      1,
      1,
      NULL,
      NULL,
      4,
      1,
      0.557213,
      0.498556,
      0,
      2.840763,
      1.657698,
      NULL,
      NULL,
      1.534979,
      0.496069,
      NULL,
      0.063789,
      2,
      2.912090,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      2.145554,
      1.475498,
      6.495590,
      0,
      1.697982,
      0.423990,
      1.627276,
      1,
      1.732131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      111.418774,
      NULL,
      NULL,
      0.010989,
      NULL,
      NULL,
      3.673754,
      NULL,
      NULL,
      1.359446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.181007,
      NULL,
      NULL,
      0.524494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.698858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.629796,
      1,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.726806,
      NULL,
      NULL,
      NULL,
      1.220837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.064857,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.803852,
      NULL,
      NULL,
      NULL,
      1.789658,
      NULL,
      NULL,
      NULL,
      0.994144,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.645727,
      NULL,
      NULL,
      NULL,
      1.253279,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      3.847122,
      NULL,
      10,
      0,
      0.254151,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.251223,
      NULL,
      5,
      1.375053,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      126,
      12,
      0.777685,
      0,
      1,
      0,
      1.179166,
      NULL,
      1,
      2,
      1,
      0.330736,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      1.726035,
      1.257216,
      1,
      0,
      0,
      NULL,
      0,
      0.903547,
      0.103838,
      0.276608,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.901783,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.592225,
      1.485790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.260757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.400089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.346370,
      0,
      1,
      1.640355,
      0,
      NULL,
      NULL,
      0.306769,
      0.364269,
      1.492427,
      1,
      1.581456,
      0,
      0.020074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.787528,
      2.353985,
      1,
      NULL,
      4,
      4,
      3.951830,
      1.161367,
      0.145897,
      NULL,
      0.295470,
      1,
      NULL,
      NULL,
      1,
      1.910245,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0.085200,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.240622,
      NULL,
      3,
      1.826290,
      NULL,
      3,
      2.329368,
      NULL,
      1,
      1.878712,
      NULL,
      2,
      2.626401,
      NULL,
      0,
      NULL,
      NULL,
      3.392244,
      0,
      3.925573,
      0,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2.252549,
      NULL,
      3,
      NULL,
      1.560861,
      NULL,
      NULL,
      NULL,
      11.281974,
      NULL,
      NULL,
      0.539918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.505935,
      NULL,
      5,
      4.127562,
      NULL,
      NULL,
      NULL,
      NULL,
      64.755483,
      7.421717,
      4,
      5,
      2,
      '01201',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.993574,
      '',
      '',
      NULL);
commit;
end;
/


