set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9008277';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '0242411',
      3.797850,
      NULL,
      6,
      1,
      '4210',
      1,
      0.901436,
      NULL,
      NULL,
      NULL,
      31,
      NULL,
      7.478000,
      0.433236,
      2,
      ' 8-27-1983',
      NULL,
      3.304257,
      137.134004,
      86,
      1.973332,
      ' 9-22-1979',
      '10- 3-1988',
      '11- 2-2000',
      2.668367,
      0,
      NULL,
      0.414480,
      1.467059,
      0,
      0,
      0.997338,
      NULL,
      2,
      4.457242,
      11,
      NULL,
      0.194665,
      11,
      6,
      11,
      5.040665,
      2.879513,
      6.805595,
      NULL,
      0,
      0.368493,
      1.032625,
      0.984703,
      1.950475,
      0.244978,
      1,
      0.634247,
      NULL,
      0.033449,
      0.324463,
      2,
      2,
      2.135373,
      7.899867,
      0,
      NULL,
      NULL,
      0.004782,
      0.371706,
      NULL,
      2,
      0.711880,
      1,
      1,
      0,
      NULL,
      0.384409,
      1,
      NULL,
      NULL,
      1.314230,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.798082,
      1.134106,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.350824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.838321,
      0,
      0.002052,
      3,
      5.555888,
      0,
      0.915503,
      4,
      1,
      1.350362,
      0.370030,
      1,
      0,
      0.347872,
      1.476500,
      1,
      NULL,
      NULL,
      1.551805,
      3,
      4,
      1,
      0,
      0,
      2.900782,
      NULL,
      1,
      NULL,
      6.774173,
      NULL,
      0.841850,
      7.198823,
      0,
      4,
      0,
      2.023052,
      8,
      0,
      3.753518,
      0,
      2.338726,
      4.978244,
      5.060557,
      2,
      2,
      NULL,
      '10-14-2001',
      379.582340,
      ' 9-10-1995',
      113.089446,
      0.831479,
      0,
      1.897795,
      5,
      0.620481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.839887,
      5.265998,
      NULL,
      0.593793,
      5,
      1.092673,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.079343,
      NULL,
      21.274370,
      3.324290,
      NULL,
      0.331493,
      1,
      1.557214,
      NULL,
      3.732500,
      5.363589,
      5,
      2,
      2,
      3,
      0.960270,
      3,
      3,
      1,
      2.929156,
      1,
      NULL,
      5,
      2,
      NULL,
      NULL,
      NULL,
      1,
      2.164302,
      NULL,
      NULL,
      NULL,
      NULL,
      7.812465,
      '11-13-1994',
      604.964164,
      ' 6- 6-1982',
      9.074473,
      2,
      1,
      1.457025,
      NULL,
      NULL,
      1,
      0.775883,
      0,
      0.027330,
      1.322490,
      0.685793,
      NULL,
      1,
      1.111687,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.868527,
      NULL,
      2.355132,
      0,
      3,
      NULL,
      3.844955,
      1,
      1,
      3.553450,
      0.930452,
      NULL,
      3.579132,
      2,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.334783,
      0.966260,
      1.251751,
      1.194018,
      0,
      0,
      1.532756,
      0,
      0,
      3.980369,
      1,
      NULL,
      6,
      NULL,
      7.756831,
      NULL,
      4,
      0,
      0.158878,
      3,
      0.388295,
      1,
      1.774107,
      43.189716,
      1,
      2.265034,
      NULL,
      69.073213,
      5.707522,
      17,
      1,
      1,
      1,
      NULL,
      NULL,
      '',
      1.265404,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.544139,
      0,
      1.758755,
      3,
      3.892689,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.906445,
      NULL,
      1.179532,
      NULL,
      0.973386,
      NULL,
      0.552955,
      0,
      0,
      NULL,
      1.817627,
      3,
      0.749474,
      0,
      NULL,
      0,
      0.346573,
      0,
      NULL,
      0.560751,
      0,
      3,
      1,
      1,
      NULL,
      2,
      NULL,
      0.351426,
      NULL,
      0.499852,
      NULL,
      NULL,
      NULL,
      65.739046,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      0.793835,
      0.334980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.053589,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.584962,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.512085,
      NULL,
      1,
      0.526386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.410644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.518702,
      1.431852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.629669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.139398,
      0.993274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0.529292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.003949,
      NULL,
      1.185645,
      0,
      0.285745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2.239064,
      NULL,
      3,
      0,
      3.860448,
      2.826111,
      7,
      NULL,
      2,
      0.070171,
      0.505713,
      0.803823,
      NULL,
      0,
      NULL,
      NULL,
      1.966238,
      0.660295,
      NULL,
      1.689196,
      0,
      NULL,
      0.490902,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.952129,
      0.316809,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3.626060,
      1.204220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.693660,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.468635,
      NULL,
      0.733567,
      NULL,
      NULL,
      NULL,
      3.208743,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.185885,
      NULL,
      12,
      2.773431,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.834731,
      NULL,
      NULL,
      6,
      2.322684,
      0.680047,
      NULL,
      NULL,
      50.075697,
      NULL,
      5,
      1,
      1,
      NULL,
      '31411',
      '',
      0,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


