set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006782';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-8-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '3332400',
      1,
      NULL,
      6,
      3,
      '0022',
      3,
      0.055693,
      NULL,
      NULL,
      NULL,
      7.306925,
      NULL,
      1,
      1.758295,
      7.205433,
      ' 9- 3-1989',
      NULL,
      4.955678,
      119,
      NULL,
      0.332590,
      ' 7-23-1991',
      ' 6-26-1984',
      ' 6-18-1974',
      NULL,
      1.714436,
      3,
      2.415627,
      0,
      0.633738,
      3,
      1,
      1,
      86,
      8,
      2.271839,
      5.684680,
      8,
      5.401269,
      NULL,
      NULL,
      3,
      NULL,
      6.379108,
      1.889389,
      0.353821,
      0.506966,
      0.357564,
      0.597265,
      2.262201,
      1,
      NULL,
      0.974299,
      1,
      1.109955,
      0.919356,
      0.149619,
      1,
      3,
      6,
      NULL,
      0,
      3,
      7,
      0.692896,
      NULL,
      1.682513,
      1.584671,
      1,
      1.758695,
      1,
      9,
      0,
      2.495637,
      1,
      2.892636,
      1,
      NULL,
      NULL,
      0.798278,
      NULL,
      NULL,
      NULL,
      NULL,
      1.936171,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.134102,
      0.909847,
      1.125519,
      2.400029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.347443,
      7,
      4,
      5.543117,
      2,
      1.779071,
      6,
      NULL,
      5,
      1.085072,
      0.685400,
      4.348499,
      0.229155,
      3.010936,
      1,
      0.683269,
      0,
      0,
      0.441767,
      NULL,
      1,
      1.448394,
      4,
      0,
      NULL,
      NULL,
      4.823921,
      3,
      1,
      2,
      3.466091,
      5.612224,
      5.097613,
      NULL,
      0,
      NULL,
      7,
      3,
      2,
      8,
      7,
      0.939400,
      NULL,
      3,
      NULL,
      8.802750,
      7.167525,
      2,
      ' 7- 1-1998',
      473,
      ' 5-19-2000',
      491.290559,
      2,
      5.751120,
      1.366203,
      6.137356,
      0.423312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.843651,
      4.161835,
      0,
      NULL,
      0,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.693638,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.621636,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3.269073,
      2,
      NULL,
      0.748456,
      3.767301,
      NULL,
      NULL,
      NULL,
      0.517954,
      8,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.774200,
      1.086576,
      2,
      0,
      0.193148,
      0.198474,
      1,
      48.233325,
      0.419088,
      1.294339,
      NULL,
      NULL,
      NULL,
      0.506614,
      NULL,
      2,
      3.054991,
      2,
      2.494875,
      0.947001,
      2,
      3.768898,
      0.983608,
      2.119416,
      NULL,
      1.153629,
      0,
      3,
      2.646643,
      0.394723,
      NULL,
      1.990724,
      2.312875,
      1,
      0,
      0,
      0,
      0.126419,
      0.357636,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      5.180590,
      10,
      6.600132,
      NULL,
      1.789403,
      1,
      5,
      3.641467,
      NULL,
      3,
      NULL,
      1.550813,
      NULL,
      NULL,
      2.529781,
      NULL,
      11.935971,
      37,
      4.379677,
      NULL,
      1,
      2.153016,
      '44020',
      NULL,
      '',
      0.180073,
      '',
      '',
      '',
      1.246491,
      '',
      '',
      '',
      2.072451,
      8.276595,
      73,
      7.634934,
      2.192545,
      33,
      8.315000,
      3.043518,
      3,
      0.630977,
      3,
      NULL,
      9,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.932179,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.231471,
      NULL,
      NULL,
      2,
      3.031017,
      3.395239,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.734212,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.985649,
      NULL,
      NULL,
      2,
      2.509134,
      1,
      0.847677,
      0,
      NULL,
      NULL,
      NULL,
      1.249909,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.873732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.271506,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.177698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.633039,
      1,
      1,
      3.984503,
      NULL,
      1.392810,
      NULL,
      2.386044,
      1.441679,
      14.913358,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.091190,
      NULL,
      2,
      3.537285,
      0,
      3.296751,
      6,
      NULL,
      6,
      1,
      NULL,
      NULL,
      1.049931,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.284683,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.157190,
      NULL,
      NULL,
      0.616776,
      NULL,
      NULL,
      1.783912,
      2,
      3.435222,
      6.981274,
      2.833209,
      4.278832,
      6.116948,
      NULL,
      2.107570,
      7.324125,
      0,
      0,
      1,
      2,
      3,
      NULL,
      1.760437,
      3.466449,
      NULL,
      3.740992,
      1,
      3.491116,
      4.799745,
      NULL,
      NULL,
      NULL,
      2,
      3,
      3.296218,
      2,
      1,
      0.291448,
      1,
      1,
      3.177283,
      2.161471,
      5,
      2,
      NULL,
      NULL,
      1.726815,
      NULL,
      1.478849,
      1.986830,
      1.617242,
      0.442938,
      NULL,
      1.660585,
      1,
      1,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.038957,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0.776559,
      0,
      0.715148,
      1.680696,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.171561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.440037,
      NULL,
      NULL,
      NULL,
      0.925795,
      NULL,
      NULL,
      NULL,
      0.835663,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.360891,
      NULL,
      NULL,
      NULL,
      1.049777,
      NULL,
      NULL,
      NULL,
      0.810870,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.164949,
      NULL,
      NULL,
      NULL,
      1.781198,
      NULL,
      NULL,
      NULL,
      2.734658,
      NULL,
      NULL,
      0.249260,
      0,
      0,
      1.170879,
      NULL,
      NULL,
      NULL,
      3.491167,
      0.640159,
      NULL,
      NULL,
      0.279295,
      0.979156,
      NULL,
      NULL,
      0.302302,
      NULL,
      1,
      435,
      3,
      1.000365,
      0,
      1.017948,
      NULL,
      NULL,
      NULL,
      1,
      1.165089,
      0,
      1.455036,
      1.708913,
      0,
      1.713551,
      0.808998,
      1.227838,
      1.210251,
      NULL,
      1.890839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.308189,
      1.847068,
      0.848459,
      2.616209,
      1,
      1,
      2,
      1,
      1.550069,
      1.231967,
      1,
      0.870818,
      NULL,
      1.318098,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      1.862677,
      0.345682,
      NULL,
      3.223992,
      2,
      NULL,
      1.845919,
      1,
      NULL,
      0.334225,
      NULL,
      NULL,
      1.842171,
      1.969533,
      NULL,
      1.057013,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.550145,
      0.751022,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.453321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.822014,
      NULL,
      1,
      NULL,
      0.455766,
      NULL,
      1,
      NULL,
      6.009787,
      3.594601,
      0.520428,
      NULL,
      20,
      NULL,
      1.384465,
      1.977467,
      0.409837,
      '00430',
      '',
      '',
      1.100713,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


