set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8926078';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-9-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '2031314',
      2.451796,
      0.403941,
      3,
      0,
      NULL,
      0.322000,
      0,
      NULL,
      NULL,
      ' 7-12-1998',
      31,
      NULL,
      5.584046,
      3.541266,
      1.958487,
      NULL,
      110.883126,
      NULL,
      201,
      136.910747,
      1,
      '10-27-1982',
      ' 5-15-1984',
      '10-19-1988',
      0.389358,
      0,
      1.184897,
      0,
      1,
      0.473330,
      NULL,
      1.896240,
      1.091630,
      460,
      10,
      15.233802,
      7.841815,
      13.419246,
      5.234354,
      NULL,
      18.456494,
      2,
      3,
      7.475115,
      0.452983,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      46.219180,
      NULL,
      7,
      9.054715,
      2,
      0,
      NULL,
      0.379960,
      0,
      1,
      1,
      0,
      2.385201,
      3.156630,
      0,
      3.666252,
      NULL,
      2.779429,
      NULL,
      0.515388,
      1,
      0,
      0.798411,
      NULL,
      NULL,
      0.739752,
      NULL,
      NULL,
      0,
      1,
      1.817470,
      0.135568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0.961667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.249503,
      4,
      0.682134,
      1,
      NULL,
      3,
      3,
      NULL,
      1.830806,
      0,
      0,
      3.277264,
      0,
      1.507204,
      0.790882,
      0.605723,
      0,
      0.030766,
      1,
      NULL,
      NULL,
      NULL,
      2.649527,
      NULL,
      0.680649,
      0.581773,
      4.570919,
      5.677466,
      1.691291,
      0,
      NULL,
      NULL,
      1.439301,
      0.435194,
      5,
      NULL,
      1.287102,
      1,
      2.222891,
      1,
      0.059289,
      NULL,
      0,
      3,
      5,
      4,
      2,
      0,
      ' 2-26-1987',
      339,
      NULL,
      706.344539,
      NULL,
      0.561015,
      NULL,
      0.196428,
      1.096184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.458967,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.438480,
      NULL,
      1905.137908,
      NULL,
      0.827652,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.608117,
      NULL,
      0.621794,
      NULL,
      4.078113,
      NULL,
      NULL,
      NULL,
      NULL,
      1.097143,
      1.683440,
      0.428653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.409040,
      1.155158,
      1,
      1,
      NULL,
      1.305532,
      NULL,
      1977.827918,
      1.861150,
      1,
      NULL,
      NULL,
      NULL,
      2.644319,
      NULL,
      2.096269,
      0.005727,
      3,
      NULL,
      1.285543,
      NULL,
      1,
      1.372960,
      2.252771,
      1.917340,
      2.962973,
      3,
      3,
      2,
      1.796243,
      1,
      0,
      3,
      1,
      1,
      0.750630,
      NULL,
      NULL,
      0.440710,
      0,
      1.091098,
      2.392177,
      NULL,
      6.533781,
      0,
      0.971317,
      2,
      NULL,
      NULL,
      11.634033,
      2,
      4,
      3,
      NULL,
      3.367448,
      3,
      NULL,
      NULL,
      3,
      1.059315,
      NULL,
      52,
      46.790732,
      48.345406,
      1.318895,
      1,
      2,
      '42231',
      '02204',
      '34024',
      1.110818,
      '',
      '',
      NULL,
      2,
      '30432',
      '32310',
      NULL,
      1.498045,
      37,
      NULL,
      NULL,
      1,
      20,
      NULL,
      NULL,
      11.975942,
      3,
      1,
      NULL,
      NULL,
      1.355144,
      NULL,
      1.001797,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.617090,
      NULL,
      NULL,
      1.004814,
      NULL,
      NULL,
      3,
      3,
      0.755934,
      0,
      2.978521,
      3,
      1,
      0,
      0.924404,
      0.182679,
      NULL,
      NULL,
      1.449687,
      2.850726,
      1.342368,
      NULL,
      NULL,
      NULL,
      3,
      9.291429,
      NULL,
      1.892582,
      NULL,
      NULL,
      NULL,
      NULL,
      0.577517,
      NULL,
      NULL,
      NULL,
      3.712181,
      3.701011,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3.753980,
      NULL,
      1,
      0.706277,
      0,
      0,
      1.551455,
      0.174298,
      0,
      3.711807,
      1.496575,
      1.486096,
      0,
      1.041899,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.062993,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.606096,
      NULL,
      NULL,
      1,
      1,
      1.021579,
      NULL,
      0.479225,
      NULL,
      0,
      NULL,
      NULL,
      6,
      0,
      4,
      0.968788,
      0.735830,
      1.299158,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.106804,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.457346,
      NULL,
      NULL,
      1.253442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.375656,
      2,
      2,
      NULL,
      2,
      0.930060,
      1,
      NULL,
      NULL,
      NULL,
      3,
      3.979886,
      3,
      2.861050,
      5.587440,
      0.110943,
      NULL,
      NULL,
      3,
      1.119889,
      3.048292,
      0,
      2,
      0.975262,
      2,
      4.559971,
      NULL,
      3,
      1.293884,
      3.544035,
      1,
      NULL,
      NULL,
      2,
      0.005566,
      NULL,
      1.788363,
      1,
      1,
      4.056574,
      4.731821,
      NULL,
      3,
      0,
      3.489851,
      2.038581,
      0.299719,
      3.618396,
      0,
      NULL,
      0.852801,
      0,
      0.451792,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.007429,
      NULL,
      NULL,
      3.171409,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.688119,
      NULL,
      NULL,
      3,
      2.470807,
      0.349589,
      NULL,
      NULL,
      3.293320,
      NULL,
      NULL,
      NULL,
      4.458455,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.690240,
      NULL,
      NULL,
      NULL,
      0.095857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.496592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.288509,
      NULL,
      NULL,
      NULL,
      0.672506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.325747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.333001,
      NULL,
      NULL,
      NULL,
      1.179007,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      6,
      3,
      NULL,
      100.352397,
      NULL,
      0,
      NULL,
      NULL,
      0.106145,
      NULL,
      NULL,
      0.140786,
      10.501119,
      0.608156,
      NULL,
      13,
      2.769854,
      1.479952,
      NULL,
      NULL,
      2.892113,
      37.236195,
      NULL,
      276.857786,
      83,
      0,
      0.848500,
      NULL,
      1,
      1.295928,
      3,
      NULL,
      NULL,
      1,
      3.151763,
      1.318778,
      3,
      1,
      2,
      1.290184,
      0,
      1.250920,
      0,
      NULL,
      1.830820,
      NULL,
      NULL,
      NULL,
      0.828101,
      NULL,
      NULL,
      NULL,
      2.485323,
      NULL,
      48.975984,
      NULL,
      3.892292,
      26.359395,
      44,
      0.890905,
      3.908693,
      0,
      NULL,
      2.017587,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.110633,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.187821,
      NULL,
      NULL,
      1.514298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.048385,
      3.124062,
      5,
      2,
      0,
      0.110206,
      0.145471,
      0.708004,
      6,
      1,
      0,
      NULL,
      2,
      0.740101,
      NULL,
      1,
      0,
      NULL,
      3.266063,
      2,
      NULL,
      1.936144,
      0,
      NULL,
      1,
      3.122743,
      NULL,
      0,
      1,
      NULL,
      2.733767,
      0,
      NULL,
      0,
      1.774038,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.845959,
      NULL,
      NULL,
      0.866937,
      NULL,
      0,
      0,
      1.610346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.814524,
      0.319042,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3.832693,
      NULL,
      0.622873,
      NULL,
      0.070298,
      NULL,
      0,
      NULL,
      1.249402,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.535390,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1.840435,
      NULL,
      NULL,
      10,
      1.909130,
      NULL,
      0.084249,
      NULL,
      32,
      51.182427,
      2.434258,
      NULL,
      7.710316,
      '41301',
      '44041',
      '33440',
      0.812320,
      NULL,
      '',
      '',
      6.975923,
      '01144',
      '24422',
      '2034');
commit;
end;
/


