set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9032579';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '4120021',
      NULL,
      1.174551,
      0,
      0,
      '4201',
      0.471240,
      0,
      NULL,
      NULL,
      ' 7-21-1995',
      5,
      NULL,
      4,
      0.522005,
      0.179160,
      ' 0-12-1981',
      12.314713,
      NULL,
      86,
      NULL,
      0,
      ' 6-20-1996',
      ' 7-20-1999',
      ' 4- 1-1992',
      3,
      2,
      0.702505,
      2.608817,
      NULL,
      3,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      9.094800,
      NULL,
      7.910303,
      NULL,
      4.536358,
      3.210599,
      5,
      1.843700,
      2,
      1,
      0.556612,
      0,
      0,
      NULL,
      3,
      1.064438,
      0,
      NULL,
      0.129731,
      0,
      1.977100,
      3.008484,
      1.091922,
      0.442611,
      2.370935,
      1.049326,
      0.494593,
      NULL,
      NULL,
      0.664639,
      0,
      NULL,
      1,
      1.052279,
      1,
      0,
      3,
      NULL,
      1.592385,
      NULL,
      NULL,
      NULL,
      2.178792,
      1,
      3.022841,
      7.348956,
      NULL,
      7,
      3.749440,
      0.977665,
      NULL,
      NULL,
      0.245827,
      1.137349,
      0.296498,
      1.989077,
      0,
      2,
      0.333774,
      2,
      0.360365,
      0.695134,
      1.472452,
      1,
      NULL,
      0,
      1,
      4.396725,
      0.058449,
      2,
      0,
      1.272982,
      NULL,
      NULL,
      3.735763,
      1.883479,
      1.144912,
      0,
      1,
      2.261536,
      0,
      5.990535,
      1,
      NULL,
      0,
      NULL,
      0.664573,
      0.576056,
      0.465792,
      0.594971,
      0,
      0,
      0,
      0.259944,
      1.809449,
      NULL,
      NULL,
      0.351343,
      2.832790,
      2,
      1.107304,
      1,
      1.271349,
      NULL,
      4.683988,
      1.787002,
      0,
      0.887235,
      1,
      NULL,
      5.724232,
      0,
      0,
      6,
      NULL,
      6.610968,
      3,
      7,
      1.481836,
      8.026184,
      9,
      NULL,
      2.885646,
      3.274322,
      0.352653,
      NULL,
      132.796688,
      NULL,
      45,
      1.866636,
      2.640452,
      NULL,
      8.874526,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.588320,
      2,
      NULL,
      1.981896,
      NULL,
      NULL,
      NULL,
      1.767742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.421150,
      NULL,
      60.965766,
      NULL,
      1.958048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.160277,
      0.946863,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      NULL,
      1,
      NULL,
      2,
      0.655889,
      NULL,
      NULL,
      NULL,
      10.932110,
      NULL,
      2,
      3,
      0.667613,
      8.808849,
      ' 3- 9-1983',
      221.450129,
      ' 1-23-1978',
      NULL,
      NULL,
      3.477030,
      0,
      0.495258,
      2,
      1.731465,
      NULL,
      1.189527,
      0.364500,
      1.168855,
      2.783121,
      34,
      2,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.820491,
      1.811273,
      3.331940,
      2,
      2,
      NULL,
      3,
      0.946666,
      0.701798,
      5,
      3,
      3.193550,
      0.983091,
      2,
      1.098702,
      0,
      0.483600,
      0,
      NULL,
      1.329382,
      1,
      NULL,
      0,
      1,
      0,
      1.685016,
      1.741154,
      0,
      1,
      3.974681,
      NULL,
      0,
      5.744227,
      6.580941,
      0.558600,
      2.071975,
      4,
      5.478516,
      NULL,
      0.232665,
      1.822834,
      0.131620,
      0,
      14.879627,
      NULL,
      3,
      NULL,
      NULL,
      69.463300,
      97,
      2.251363,
      0.103555,
      1,
      '11131',
      '',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      55,
      NULL,
      NULL,
      26,
      0,
      0.013872,
      5,
      2,
      3.547684,
      0,
      0.159274,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.234866,
      3.030936,
      NULL,
      1.399374,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.116456,
      0.680563,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.147493,
      2.749704,
      0,
      1.436555,
      NULL,
      NULL,
      3.588631,
      1,
      1,
      1.417303,
      1.920610,
      NULL,
      NULL,
      NULL,
      NULL,
      3.431654,
      2.008348,
      6,
      3,
      0.278646,
      NULL,
      0.962693,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.089646,
      0,
      0,
      1.666518,
      NULL,
      1.646362,
      NULL,
      3.146772,
      1.607150,
      3,
      NULL,
      3.493469,
      0.599781,
      1.629992,
      0.807537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.921852,
      2,
      NULL,
      0.119024,
      0,
      NULL,
      NULL,
      NULL,
      0.385159,
      1.135443,
      1.228804,
      15.916414,
      0.948140,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.833947,
      3.051054,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.803234,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.511198,
      NULL,
      NULL,
      1.463847,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.301179,
      4,
      0,
      NULL,
      NULL,
      2.037916,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      4.101235,
      0,
      4.996683,
      1,
      NULL,
      3,
      3,
      2,
      1,
      3,
      1.709638,
      2.813879,
      3,
      NULL,
      0.002801,
      0.140986,
      7.619072,
      6,
      0.210937,
      NULL,
      1,
      NULL,
      NULL,
      0.516737,
      0.156263,
      0.907379,
      0,
      0.166946,
      1.170063,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.306024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.593364,
      NULL,
      NULL,
      0.492877,
      NULL,
      NULL,
      1.078132,
      NULL,
      NULL,
      1.655205,
      NULL,
      NULL,
      2.113376,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.702373,
      NULL,
      NULL,
      0.792874,
      NULL,
      NULL,
      1.189802,
      0.740345,
      2,
      1,
      3.237402,
      NULL,
      1.502985,
      NULL,
      9.038640,
      NULL,
      NULL,
      NULL,
      64.078583,
      NULL,
      NULL,
      NULL,
      3.441807,
      NULL,
      NULL,
      NULL,
      3.203472,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.298353,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.217105,
      NULL,
      NULL,
      NULL,
      0.455324,
      NULL,
      NULL,
      NULL,
      0.056517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.385021,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.047805,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.556067,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      0.419639,
      0,
      1.194009,
      1,
      3,
      0,
      2,
      1,
      0,
      22.445943,
      2.552644,
      0.126503,
      NULL,
      NULL,
      0.853924,
      0,
      3.200404,
      2.661674,
      NULL,
      2.092737,
      1.596101,
      NULL,
      NULL,
      1.540292,
      NULL,
      NULL,
      747,
      1.832810,
      0.346507,
      0.217109,
      NULL,
      0,
      1.380542,
      1,
      0,
      NULL,
      1.555296,
      0.093225,
      0.180278,
      0,
      1,
      NULL,
      0.839649,
      1,
      1.762018,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.547412,
      1,
      NULL,
      4.827221,
      1,
      3,
      NULL,
      2.786141,
      10.842499,
      NULL,
      1,
      1,
      0.217228,
      1.270175,
      NULL,
      0,
      0.012259,
      NULL,
      0,
      1.471912,
      NULL,
      0.332262,
      0.789543,
      NULL,
      2.365518,
      0.881163,
      NULL,
      0,
      3.857162,
      NULL,
      0.540178,
      2,
      NULL,
      0.022057,
      1.211021,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.168785,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.638210,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.783396,
      0.063098,
      NULL,
      1.086790,
      NULL,
      NULL,
      64,
      NULL,
      3.162847,
      0,
      1.816289,
      '32204',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.797097,
      '',
      '',
      '');
commit;
end;
/


