set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9303545';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-2-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '4021214',
      2,
      1.839893,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      ' 4-18-1989',
      1.800052,
      NULL,
      1.416925,
      1.993599,
      NULL,
      NULL,
      33,
      0,
      179.689479,
      66,
      3,
      ' 1-23-1990',
      '10-24-1992',
      '10- 5-1997',
      3,
      0,
      2.066879,
      0,
      0,
      1.954969,
      0,
      0,
      0.840560,
      168,
      8.064504,
      6.433042,
      0,
      NULL,
      NULL,
      4,
      18,
      1.026066,
      1.397958,
      2.282204,
      NULL,
      1,
      0.618266,
      1,
      0,
      NULL,
      1,
      0,
      0.119761,
      NULL,
      93.459698,
      5,
      1,
      6,
      1,
      1.217006,
      0,
      NULL,
      1,
      1,
      1.910785,
      7.354488,
      0,
      1.785368,
      1,
      0,
      0,
      3.646451,
      NULL,
      NULL,
      0,
      NULL,
      1.774258,
      NULL,
      NULL,
      1.962898,
      1.677845,
      3.250300,
      3.529028,
      1.554579,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.582027,
      2,
      1,
      NULL,
      3,
      0.423612,
      NULL,
      0.098476,
      0.886201,
      0,
      3,
      3,
      1,
      1,
      1,
      3,
      1,
      5.842692,
      1.232893,
      1,
      NULL,
      NULL,
      2.870889,
      5.382404,
      NULL,
      0.861599,
      NULL,
      0.929056,
      1.511561,
      1.218308,
      0.253075,
      0.987221,
      NULL,
      1,
      1.152011,
      1,
      1.124149,
      1.586559,
      1.402188,
      0,
      1.818050,
      NULL,
      0,
      0,
      NULL,
      1.635731,
      7,
      1,
      4.707955,
      0,
      1.885306,
      2.262478,
      7.384714,
      4.337233,
      7.214717,
      0,
      NULL,
      4,
      1,
      2.711443,
      4.261440,
      0.620312,
      NULL,
      4,
      6.441719,
      2,
      NULL,
      2.283455,
      NULL,
      6.056491,
      3.339927,
      5,
      2,
      ' 1-14-1996',
      352.791943,
      ' 6- 4-1994',
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      1.408846,
      1.198729,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.374959,
      NULL,
      2,
      0,
      1.063284,
      1.151678,
      0,
      0,
      0,
      2,
      5.013565,
      1.128526,
      1,
      2.753540,
      1,
      NULL,
      1.359413,
      5,
      0,
      5,
      4.906028,
      7.302058,
      9.059157,
      2,
      1.065050,
      NULL,
      NULL,
      3.964616,
      12,
      2.625336,
      5.670090,
      3,
      NULL,
      4,
      NULL,
      3,
      ' 3-11-1986',
      5,
      1.507902,
      1.254933,
      1,
      NULL,
      3.084923,
      1,
      3.369553,
      1.965983,
      0,
      0,
      2,
      56.981248,
      0.199443,
      0.808716,
      NULL,
      NULL,
      NULL,
      0.557435,
      0,
      2.290173,
      2.629533,
      3.938635,
      3.014670,
      1.178488,
      NULL,
      NULL,
      0,
      3.526151,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.072491,
      1,
      0.604473,
      0.275574,
      0,
      0.336077,
      1,
      1.127188,
      NULL,
      0.213296,
      0,
      1.616816,
      0,
      1,
      NULL,
      0,
      11.692979,
      3,
      0.051020,
      9.947151,
      2.834187,
      1,
      2.939555,
      1,
      6,
      0,
      2.835431,
      NULL,
      13.626051,
      NULL,
      NULL,
      NULL,
      NULL,
      39.811080,
      30,
      1.358573,
      0,
      1,
      '03020',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      3.252810,
      1,
      107.468384,
      NULL,
      NULL,
      32.596150,
      4.881457,
      3.851831,
      3,
      3.203630,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.538115,
      0.583653,
      2,
      2.300451,
      NULL,
      NULL,
      NULL,
      NULL,
      1.206600,
      NULL,
      NULL,
      3.514166,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.861693,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2,
      4,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.880710,
      3,
      3,
      0,
      0.792426,
      1,
      2,
      0,
      NULL,
      2,
      NULL,
      0.031812,
      NULL,
      1,
      3.149422,
      2.274512,
      2,
      2,
      3,
      1,
      NULL,
      3.576542,
      2,
      0,
      2,
      1,
      2.305774,
      2.535121,
      NULL,
      NULL,
      NULL,
      0.787678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      9.718759,
      1,
      0.144258,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.583410,
      NULL,
      0.241456,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.798526,
      1,
      1.637269,
      NULL,
      NULL,
      NULL,
      7,
      1,
      0.295182,
      0.449154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.963978,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.953838,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.107546,
      0.118675,
      NULL,
      NULL,
      7.625914,
      0.206318,
      3.678337,
      7.700125,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1.339484,
      0,
      1.023246,
      NULL,
      1.829190,
      2.423757,
      NULL,
      2.911364,
      NULL,
      3,
      1,
      2,
      0.877676,
      3,
      3,
      0.456733,
      2,
      NULL,
      1.038105,
      3,
      1,
      7,
      9,
      7.380339,
      6.167727,
      3,
      NULL,
      2.343157,
      0.947806,
      6.327191,
      1.962481,
      1,
      1.836556,
      0,
      1.701683,
      2.644759,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.680796,
      NULL,
      NULL,
      1.307770,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.061249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.074204,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.827530,
      1,
      0,
      0,
      1.604420,
      0,
      NULL,
      NULL,
      8.990196,
      NULL,
      NULL,
      NULL,
      0.546435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.841276,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.998290,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.337249,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.411041,
      NULL,
      NULL,
      NULL,
      0.938321,
      NULL,
      NULL,
      NULL,
      3.558769,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.474559,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      0.637707,
      5,
      0,
      2.510845,
      145.877392,
      47,
      0.397103,
      NULL,
      19,
      1,
      NULL,
      NULL,
      0,
      55,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.962503,
      28.854610,
      7,
      0.022973,
      0,
      0.237842,
      0,
      NULL,
      1.836290,
      1,
      1,
      0,
      0.191313,
      1,
      1,
      1.664860,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.237141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.580597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.404259,
      0.448278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.987225,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.031577,
      NULL,
      NULL,
      1.573220,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.269776,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.851057,
      NULL,
      1,
      7.063914,
      3.602729,
      2.431358,
      5.543310,
      3.193150,
      16,
      1,
      0.821449,
      0.123571,
      0,
      1.386250,
      0.005953,
      0.884054,
      1.356180,
      1,
      1,
      NULL,
      0,
      0.668291,
      0,
      NULL,
      3,
      0,
      3,
      1,
      0,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      0.610376,
      0.409705,
      0.041554,
      0.909445,
      1.129252,
      0.670387,
      NULL,
      0,
      3.427660,
      3.475005,
      3.519698,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2.588615,
      3.787557,
      3,
      0.306423,
      NULL,
      3,
      2,
      2,
      1.784203,
      2.869802,
      0.967622,
      1,
      2,
      2,
      NULL,
      1,
      0.935797,
      3.952165,
      1,
      1.130379,
      0,
      NULL,
      0,
      2,
      0,
      3.277083,
      3.338174,
      NULL,
      0.715266,
      1,
      2.678506,
      3,
      0.246212,
      0.471995,
      0,
      11,
      3.641456,
      2.008580,
      0.817930,
      2.666317,
      19,
      60.059827,
      NULL,
      NULL,
      5.875354,
      '00121',
      '23114',
      '',
      1.075808,
      '',
      NULL,
      '',
      0.977273,
      '',
      NULL,
      '');
commit;
end;
/


