set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9303545';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-7-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '01',
      '13',
      31,
      16.296987,
      '4424444',
      0,
      1.875048,
      NULL,
      NULL,
      '4242',
      4.497456,
      1.110791,
      NULL,
      NULL,
      ' 2-19-1982',
      29.446290,
      0,
      NULL,
      NULL,
      NULL,
      ' 4-10-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-10-1994',
      NULL,
      ' 3-27-1974',
      1.574894,
      0,
      NULL,
      0,
      1.489313,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.187848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.878177,
      3.642021,
      3,
      NULL,
      1,
      1.384963,
      NULL,
      1,
      0,
      1.108031,
      1.890685,
      0.520567,
      1.678217,
      0.139219,
      0,
      5,
      NULL,
      0.441760,
      0,
      0.874543,
      0,
      1.507043,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.570924,
      0,
      1.102835,
      1.281490,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0.275867,
      0,
      1.506902,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.295345,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.556263,
      1,
      1.129725,
      0.099130,
      NULL,
      NULL,
      NULL,
      NULL,
      1.042558,
      NULL,
      0.798646,
      1.485193,
      NULL,
      0,
      1.104514,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.873199,
      0.885861,
      0,
      1,
      0,
      1.163659,
      0.252478,
      6,
      NULL,
      0.423897,
      1,
      0.492880,
      4.080203,
      3,
      0,
      NULL,
      1.787607,
      0.244105,
      NULL,
      7.708361,
      0.605698,
      1,
      NULL,
      1.675101,
      0,
      1,
      NULL,
      0.644266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.326247,
      1.807112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.848226,
      NULL,
      1,
      0.990360,
      1.571580,
      NULL,
      0.329556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.438797,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.285599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.122446,
      1.494145,
      5.868192,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      8.754102,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.208223,
      2.702038,
      1,
      2.072930,
      NULL,
      2.568815,
      1.318235,
      1,
      0.486456,
      2,
      2,
      0.548984,
      2,
      3.568991,
      2.114031,
      1,
      2.910785,
      NULL,
      0,
      0,
      0,
      0.783697,
      1.613339,
      1.782641,
      1,
      NULL,
      0.795671,
      0.394997,
      3.475322,
      2.704840,
      0,
      NULL,
      5.230756,
      7,
      8.542962,
      10.906345,
      NULL,
      2.090927,
      NULL,
      6.761470,
      2.466128,
      NULL,
      0.628022,
      16,
      3.759361,
      1,
      NULL,
      NULL,
      111,
      19.583816,
      NULL,
      0,
      2.483921,
      '04314',
      '',
      '',
      0.971969,
      '',
      '',
      '',
      1.709830,
      '',
      '',
      '',
      1.228843,
      25,
      258,
      19.941224,
      3,
      40,
      4,
      2,
      NULL,
      2.628366,
      2.407574,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2.761793,
      2,
      0.771067,
      1.225808,
      0.140980,
      NULL,
      NULL,
      1.634944,
      NULL,
      NULL,
      0,
      3,
      1.442819,
      1,
      NULL,
      NULL,
      3.184609,
      3.426837,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      1.458987,
      0,
      NULL,
      NULL,
      NULL,
      1.642405,
      3,
      0.826312,
      2.902122,
      0.561733,
      1.621604,
      NULL,
      1,
      1.979070,
      0,
      0.193114,
      NULL,
      NULL,
      NULL,
      1.465082,
      3.678797,
      1,
      3,
      1,
      1.160830,
      1,
      3.357661,
      1,
      2.772603,
      1,
      0,
      3,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.092368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      4.957301,
      7.261479,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.122629,
      0.980769,
      1,
      NULL,
      NULL,
      1.344112,
      1,
      1,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      4,
      5.983458,
      NULL,
      0,
      NULL,
      NULL,
      1.956624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.578856,
      NULL,
      NULL,
      0.681364,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.008907,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.605388,
      2,
      2,
      1,
      NULL,
      NULL,
      0,
      0,
      3.239639,
      NULL,
      4.835006,
      1.778390,
      0,
      5.400031,
      NULL,
      2,
      NULL,
      2.748961,
      3.938701,
      3,
      3,
      2,
      NULL,
      2,
      9,
      4,
      NULL,
      2,
      3,
      NULL,
      2,
      2.023950,
      NULL,
      NULL,
      NULL,
      3,
      3.026688,
      3,
      2,
      NULL,
      0,
      3,
      8.456492,
      3,
      NULL,
      NULL,
      1,
      5,
      1,
      NULL,
      0.650624,
      1.058288,
      0.942939,
      1,
      NULL,
      NULL,
      1.721987,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.620247,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.805927,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.199940,
      0,
      0.382093,
      0.932931,
      1.360213,
      3.244973,
      1.995686,
      NULL,
      NULL,
      5.172774,
      NULL,
      NULL,
      NULL,
      4.884764,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.335925,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.354430,
      NULL,
      NULL,
      NULL,
      3.620935,
      NULL,
      NULL,
      NULL,
      0.116302,
      NULL,
      NULL,
      NULL,
      1.851931,
      NULL,
      NULL,
      NULL,
      1.016664,
      NULL,
      NULL,
      NULL,
      1.562483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.259547,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      1,
      NULL,
      156,
      NULL,
      0,
      NULL,
      7,
      0,
      NULL,
      NULL,
      NULL,
      40.962566,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.046462,
      NULL,
      1,
      255,
      NULL,
      1,
      0,
      1.371674,
      1.956877,
      0.623826,
      1.295480,
      0.985132,
      1.953376,
      NULL,
      0,
      0.083286,
      1.895180,
      1,
      0.230287,
      NULL,
      1,
      1.301000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.716012,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.844429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.750541,
      0.495297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.059759,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3.649594,
      NULL,
      3,
      2,
      0.274746,
      0,
      5,
      0,
      1.940994,
      1.949478,
      0,
      1,
      1,
      0.033228,
      0.749433,
      NULL,
      1,
      1.684379,
      1.947341,
      1,
      NULL,
      0,
      0.416112,
      1,
      2,
      0,
      0.839126,
      0.826519,
      NULL,
      1,
      0,
      0.147103,
      NULL,
      NULL,
      0.009471,
      0.154318,
      0,
      1,
      0.056484,
      NULL,
      1,
      NULL,
      3.699717,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.426296,
      1.683516,
      NULL,
      1,
      3.663371,
      1.528290,
      NULL,
      NULL,
      NULL,
      3.516187,
      2,
      NULL,
      0,
      NULL,
      2.082341,
      2,
      1,
      0.778101,
      2.567706,
      2,
      NULL,
      NULL,
      0,
      3,
      2.125335,
      18.309933,
      NULL,
      NULL,
      0,
      1.916022,
      0.608239,
      1,
      1,
      0,
      NULL,
      8.803098,
      9,
      2.343184,
      1.980569,
      3.640214,
      68.699839,
      13.097818,
      0.642374,
      4,
      5.292124,
      NULL,
      '13240',
      '',
      0.475793,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


