set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9827986';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.565017,
      3,
      2.411139,
      3,
      NULL,
      NULL,
      1,
      3.975057,
      '321',
      '23004031',
      NULL,
      62.823070,
      '2420022',
      2,
      1.563670,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      ' 2- 7-1997',
      169,
      NULL,
      NULL,
      2,
      2,
      ' 5- 3-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      1.803946,
      ' 3-14-1976',
      ' 7-10-1990',
      ' 1-18-1975',
      3,
      1.756830,
      2,
      NULL,
      1.302553,
      1.480967,
      5.993940,
      1,
      NULL,
      NULL,
      NULL,
      2.572543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.300200,
      3,
      NULL,
      0.275904,
      1,
      NULL,
      1.695722,
      1,
      0,
      0,
      1.910206,
      0.718894,
      0.503976,
      1.738636,
      2,
      1.264461,
      2,
      0,
      1,
      0.835324,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      0.741941,
      4.418606,
      1.064461,
      3.986940,
      2,
      3.938862,
      5,
      0.881980,
      NULL,
      NULL,
      7.374961,
      1.189490,
      0.960832,
      0.567709,
      NULL,
      NULL,
      NULL,
      0.128013,
      1.734386,
      0.560496,
      1.450885,
      NULL,
      1,
      0,
      NULL,
      1.738498,
      0,
      NULL,
      1,
      NULL,
      0,
      2.841955,
      7.872943,
      0,
      1.345857,
      2,
      NULL,
      5.791558,
      0.053114,
      1,
      NULL,
      NULL,
      1.543948,
      9,
      0,
      NULL,
      7.898990,
      9.032497,
      2.567490,
      1,
      4.768045,
      5,
      0.835853,
      0.634826,
      5,
      NULL,
      1,
      1,
      NULL,
      1.487302,
      0,
      NULL,
      0.316086,
      0,
      1.645922,
      3,
      NULL,
      0,
      3,
      NULL,
      0.274731,
      1,
      NULL,
      1.756236,
      1.124894,
      0.132354,
      NULL,
      4,
      0,
      0.752314,
      4.765752,
      NULL,
      NULL,
      NULL,
      2.495434,
      1.061763,
      1,
      0,
      0,
      0.344873,
      ' 0- 1-1997',
      5,
      ' 5-29-1976',
      1.650275,
      3.923629,
      0,
      1.475564,
      2,
      NULL,
      NULL,
      2.610405,
      0.285127,
      1,
      1.813940,
      4,
      4,
      9,
      NULL,
      3.517636,
      6,
      5,
      1,
      2,
      NULL,
      1.865540,
      ' 4- 3-2002',
      4,
      ' 2-11-1984',
      6,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.302800,
      3.719425,
      2.551055,
      1.850178,
      1.481810,
      2,
      2,
      1,
      1.392597,
      NULL,
      1.899666,
      1.324889,
      NULL,
      1.776062,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.423090,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.753479,
      1.557959,
      0.065154,
      NULL,
      0.987941,
      1,
      1,
      0,
      8.402403,
      2.783888,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.074796,
      3,
      3.910019,
      1.328475,
      NULL,
      NULL,
      2,
      2,
      2,
      NULL,
      NULL,
      3,
      1.948325,
      NULL,
      NULL,
      1,
      1,
      1.739232,
      0.043260,
      NULL,
      1,
      1.615098,
      0.058681,
      NULL,
      NULL,
      0.279737,
      1.061860,
      2,
      NULL,
      NULL,
      1,
      5.744241,
      9.168068,
      5,
      9,
      2.884033,
      NULL,
      3.315157,
      2.262623,
      4.996436,
      0,
      0,
      3,
      30.192409,
      1.843759,
      2.751368,
      NULL,
      NULL,
      36,
      58.823694,
      4.364608,
      NULL,
      2.777994,
      '34012',
      '',
      NULL,
      1.157794,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.832546,
      1,
      NULL,
      NULL,
      NULL,
      0.608179,
      NULL,
      NULL,
      0.065955,
      NULL,
      0.597810,
      1,
      1,
      0.590409,
      1.410212,
      NULL,
      NULL,
      0.616629,
      NULL,
      0,
      67,
      1.416669,
      1,
      1,
      1.820216,
      0.990617,
      1.396841,
      1,
      1,
      0.251338,
      1,
      1.233317,
      0,
      0.602831,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.972930,
      1.759073,
      1,
      0.089204,
      NULL,
      0,
      1.701143,
      3,
      3,
      0.395217,
      0,
      0.555057,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      2.246745,
      NULL,
      NULL,
      0,
      NULL,
      1.970302,
      0,
      NULL,
      1.168296,
      0.301370,
      NULL,
      1.273082,
      1,
      NULL,
      1.893530,
      1.953513,
      NULL,
      1.543384,
      0.069447,
      NULL,
      0.317727,
      0,
      NULL,
      2.164624,
      NULL,
      1.739682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.755357,
      0,
      1,
      NULL,
      NULL,
      NULL,
      28.842864,
      89.349020,
      4,
      3.627280,
      3.000258,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0.553584,
      NULL,
      '',
      '');
commit;
end;
/


