set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6604647';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-11-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      2,
      '0340',
      0,
      0,
      NULL,
      NULL,
      ' 8-10-1996',
      NULL,
      NULL,
      5.561054,
      0.836444,
      14.482193,
      ' 6-27-2000',
      27,
      2.271428,
      311.740481,
      28,
      2,
      ' 3-19-1978',
      '11-21-1997',
      ' 2-26-1985',
      0,
      1.845047,
      1,
      0.589470,
      0,
      0.467910,
      2.107211,
      1.973279,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      12,
      17,
      6,
      1.007518,
      4.725206,
      NULL,
      8.614806,
      0,
      4,
      NULL,
      0.278874,
      0,
      0.682437,
      0,
      0,
      1,
      1.383869,
      NULL,
      3,
      0,
      NULL,
      2.140319,
      1,
      0.430219,
      NULL,
      3,
      0.381575,
      NULL,
      5.334289,
      1.406963,
      1.157552,
      1.405502,
      1,
      0,
      3.771953,
      1,
      1,
      5.213013,
      0.405112,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.160062,
      0.959446,
      1.841806,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.513435,
      1,
      0,
      0.552282,
      0,
      3,
      0.908330,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.231427,
      NULL,
      NULL,
      1.524341,
      0,
      1.971486,
      NULL,
      1.933744,
      3,
      6,
      0.273576,
      1,
      4,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      1.790820,
      1.452078,
      1,
      NULL,
      0,
      0,
      3.856523,
      1.420422,
      1.501036,
      0.413283,
      0,
      NULL,
      NULL,
      0,
      3,
      4.140037,
      4,
      5,
      6,
      2,
      0.732872,
      NULL,
      NULL,
      1,
      1.254135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.484621,
      0,
      2,
      2,
      0.892034,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.510039,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.539695,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.182306,
      1,
      NULL,
      3.486815,
      0,
      NULL,
      1.668475,
      NULL,
      NULL,
      NULL,
      NULL,
      0.096505,
      1.792272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      0,
      1,
      NULL,
      11,
      1.518441,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.472842,
      0,
      1,
      NULL,
      2.378003,
      2,
      NULL,
      NULL,
      3,
      3,
      3,
      2,
      11.939621,
      9,
      NULL,
      127,
      199.743740,
      70,
      33.681103,
      NULL,
      177,
      163.269985,
      123.631679,
      150,
      3.976687,
      NULL,
      1.890651,
      NULL,
      13.328846,
      1,
      NULL,
      6.442389,
      1.075325,
      2.115112,
      2,
      1,
      NULL,
      0.459268,
      4.854636,
      3,
      0.176809,
      2,
      34,
      1.352045,
      0.574061,
      NULL,
      62,
      91.583912,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      '',
      1,
      '23310',
      '',
      '',
      0.530264,
      '',
      '',
      '',
      0.413961,
      5.218222,
      278,
      6,
      3,
      5,
      3.931546,
      NULL,
      2,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.734063,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0.996717,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.777438,
      3.967687,
      3.882493,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.231994,
      1.962610,
      0,
      NULL,
      0,
      1,
      0.101924,
      1,
      NULL,
      0.131564,
      NULL,
      0.065882,
      1.773554,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.747923,
      NULL,
      NULL,
      3.461780,
      NULL,
      3,
      1.532131,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.689169,
      NULL,
      NULL,
      1.680113,
      0,
      1.116625,
      2.301382,
      2.551463,
      0,
      1,
      NULL,
      NULL,
      5.594486,
      NULL,
      0,
      0.399540,
      NULL,
      NULL,
      1.497922,
      1.096396,
      0.834490,
      3.869060,
      3,
      0,
      1,
      NULL,
      NULL,
      1.465221,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.790553,
      NULL,
      NULL,
      1.938632,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.312094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.028949,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.069426,
      1.266840,
      3.455592,
      2.411391,
      3.073130,
      1.106114,
      NULL,
      2,
      3.945335,
      3,
      NULL,
      0.053427,
      NULL,
      8.662231,
      7,
      3.076799,
      1.521341,
      0.940973,
      0,
      1,
      NULL,
      2.968968,
      3.719440,
      1,
      2.237313,
      0.268481,
      0.991227,
      4,
      0.495372,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.024522,
      0,
      0.359393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.070229,
      1,
      0,
      1,
      0.380268,
      0.853867,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.064261,
      NULL,
      NULL,
      1.250314,
      NULL,
      NULL,
      0.018009,
      NULL,
      NULL,
      1.264196,
      NULL,
      NULL,
      1.001932,
      12.082904,
      NULL,
      0,
      NULL,
      NULL,
      366,
      7.673982,
      0.273346,
      2.398857,
      NULL,
      NULL,
      1,
      0.453920,
      0,
      0.931940,
      NULL,
      1.799137,
      0.119644,
      0.475862,
      0.573896,
      1.188581,
      NULL,
      1.702264,
      1,
      0.079164,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.603954,
      NULL,
      2,
      NULL,
      0,
      44.839286,
      8,
      1.611708,
      0.578045,
      NULL,
      NULL,
      0.456034,
      NULL,
      0.741823,
      NULL,
      1,
      NULL,
      0.390891,
      NULL,
      0,
      NULL,
      0.743053,
      NULL,
      1.038141,
      NULL,
      0.284399,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.516613,
      NULL,
      0,
      NULL,
      NULL,
      2.888668,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.865057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.092205,
      0.395996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      259.470093,
      NULL,
      2.722090,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      1.719978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.793728,
      1.700689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.947716,
      1.267938,
      NULL,
      3.065849,
      NULL,
      NULL,
      NULL,
      511.157867,
      NULL,
      3.690131,
      NULL,
      1,
      NULL,
      NULL,
      1.833889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5.676075,
      9,
      2.204473,
      0,
      0,
      NULL,
      9.400254,
      1.398004,
      0.789096,
      0,
      1.829075,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.891322,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.798662,
      1.022730,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.725550,
      NULL,
      NULL,
      2.331798,
      3.449717,
      0,
      NULL,
      69,
      NULL,
      0.582954,
      1.142516,
      NULL,
      '',
      '',
      2.466606,
      '13001',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


