set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6604647';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-7-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '02',
      '10',
      33,
      NULL,
      '0113234',
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      0.568648,
      NULL,
      NULL,
      ' 3-24-1997',
      1.917929,
      NULL,
      NULL,
      1,
      0,
      ' 3-26-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 7-16-1977',
      0,
      NULL,
      NULL,
      1,
      1.454544,
      2.377446,
      1,
      1.638761,
      1,
      3,
      9.026548,
      19.590330,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      7.603970,
      1.122802,
      NULL,
      0,
      7.404739,
      1,
      1,
      0,
      0.825959,
      0.820380,
      NULL,
      1,
      1,
      0,
      3,
      0.880133,
      NULL,
      0,
      NULL,
      1.647026,
      0,
      4.782160,
      1.939444,
      NULL,
      1.145542,
      NULL,
      1.240683,
      1.932822,
      NULL,
      0.968051,
      5,
      NULL,
      3.232503,
      0,
      1.295093,
      0.498072,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      2.525890,
      1.564542,
      NULL,
      0.820893,
      3.201342,
      0.558212,
      2.094056,
      1.107348,
      1,
      0,
      0.626964,
      0.300880,
      NULL,
      1.374210,
      3.716547,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      1.913928,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.521512,
      NULL,
      NULL,
      0.985773,
      0.593143,
      2,
      0,
      1.307097,
      NULL,
      2,
      0.570544,
      0.253924,
      0,
      1,
      1,
      NULL,
      0,
      0.126153,
      1,
      1,
      1,
      1,
      NULL,
      3.083146,
      1.632319,
      NULL,
      1,
      0,
      1,
      1.167956,
      2.555368,
      2,
      6,
      NULL,
      3.226550,
      8.981138,
      7.470476,
      NULL,
      2.894430,
      5,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.685214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.483708,
      0,
      3,
      0,
      NULL,
      1.316935,
      1.984465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.033087,
      NULL,
      2,
      NULL,
      0,
      1.406900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.498579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.978233,
      NULL,
      0.514657,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.117494,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.497761,
      0.702097,
      0.875395,
      0.754968,
      1,
      1,
      NULL,
      2.974492,
      1.169448,
      0,
      1.095380,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      3,
      0.948971,
      1.494350,
      2,
      1.186766,
      2,
      0.963841,
      NULL,
      2.513510,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.867464,
      0.376778,
      1.275787,
      1.500778,
      1,
      1.860378,
      NULL,
      NULL,
      0.430899,
      5,
      7.066853,
      4.163238,
      9,
      11,
      1.048810,
      NULL,
      3.463486,
      NULL,
      2.570811,
      2,
      2.698111,
      64.377072,
      3.099507,
      3.050522,
      47.298385,
      NULL,
      108.475706,
      70.265629,
      1.745517,
      0.231712,
      0,
      '42304',
      NULL,
      '',
      NULL,
      '10444',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      11,
      36.404088,
      20,
      2.718226,
      NULL,
      4,
      3.318382,
      0,
      3.370818,
      1.450210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.265550,
      0.547732,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.472203,
      NULL,
      NULL,
      NULL,
      3,
      1.504289,
      0.230990,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.497606,
      3,
      0,
      0.570308,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.772970,
      0,
      1,
      0,
      NULL,
      NULL,
      3.964513,
      1.104987,
      0.580390,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2.833180,
      1,
      0,
      NULL,
      NULL,
      0.566882,
      NULL,
      NULL,
      3.949875,
      1,
      0,
      5,
      5,
      NULL,
      1.356340,
      1.156780,
      NULL,
      NULL,
      NULL,
      1.002013,
      NULL,
      NULL,
      NULL,
      1.627995,
      NULL,
      NULL,
      2.514325,
      3,
      NULL,
      3,
      3.393246,
      1,
      0.800408,
      NULL,
      NULL,
      0.359674,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      3.580593,
      0,
      2,
      4,
      4,
      0.222069,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.850843,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.948424,
      NULL,
      NULL,
      0.092421,
      NULL,
      NULL,
      1.125514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.707184,
      NULL,
      NULL,
      NULL,
      3.962167,
      4.371513,
      NULL,
      3,
      3.483476,
      2,
      3.840184,
      0.123835,
      2.263303,
      1.647312,
      2,
      4,
      7,
      6,
      0.604432,
      1,
      0.622082,
      0,
      3,
      2,
      NULL,
      NULL,
      3,
      2.327050,
      3.677572,
      NULL,
      NULL,
      4.232971,
      7,
      2.295257,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.319120,
      0,
      1,
      1.739013,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.795199,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.656112,
      4,
      0,
      0.106602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.965651,
      NULL,
      NULL,
      0.944693,
      NULL,
      NULL,
      0,
      4.341290,
      2.341469,
      1,
      NULL,
      0.219256,
      69,
      1.633050,
      1.926155,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.414090,
      0,
      1.837311,
      0,
      2.138056,
      0,
      NULL,
      1,
      0.401687,
      0.902752,
      3.947616,
      NULL,
      0.875287,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3.243429,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      0.990499,
      43.909617,
      42.851499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.045856,
      NULL,
      0,
      NULL,
      0.519357,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.068473,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.045627,
      NULL,
      0,
      NULL,
      0.357589,
      NULL,
      NULL,
      3.193617,
      0.036593,
      0.353984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.637124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.769573,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.126318,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      132.110451,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.535126,
      1.186475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.312711,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.724899,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.480793,
      2.986350,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      9.007634,
      0.482913,
      1,
      2.601467,
      NULL,
      4,
      0.460028,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.440443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.485716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0.112705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.859981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.745221,
      NULL,
      0.241142,
      NULL,
      NULL,
      NULL,
      1,
      6.997113,
      NULL,
      NULL,
      0,
      0.514075,
      44,
      15,
      3.913173,
      5,
      5.771202,
      '12232',
      '32304',
      '02230',
      1.985187,
      '10341',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


