set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9671395';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-10-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '33',
      0.241393,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      '4040',
      1,
      1,
      NULL,
      NULL,
      ' 3-14-1999',
      NULL,
      7,
      NULL,
      0,
      1.571247,
      ' 2-16-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-24-1983',
      ' 7- 5-2000',
      ' 0-10-1982',
      3.971530,
      0.372019,
      0.527248,
      1,
      0.863798,
      0.989708,
      1.669903,
      0,
      0,
      3,
      9.729745,
      16.012133,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.600531,
      NULL,
      1.985643,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.377477,
      2,
      9.295183,
      NULL,
      0.987133,
      1,
      NULL,
      3,
      1.470976,
      NULL,
      NULL,
      2,
      0.633430,
      0.376815,
      0,
      0.698936,
      4.210664,
      0.350117,
      0.002638,
      1.688391,
      NULL,
      NULL,
      NULL,
      NULL,
      1.656427,
      NULL,
      NULL,
      2.815400,
      2,
      3.186657,
      1,
      1,
      NULL,
      1,
      0,
      0,
      0.435778,
      1,
      0,
      0.587819,
      2.147610,
      NULL,
      0.001755,
      1,
      3,
      NULL,
      0,
      5.019252,
      NULL,
      0,
      NULL,
      4.736494,
      3,
      NULL,
      NULL,
      NULL,
      1.857358,
      NULL,
      NULL,
      0,
      0,
      3,
      0.738356,
      2,
      0.344781,
      3,
      1.983029,
      1,
      0,
      0,
      0.849250,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      6,
      1,
      1,
      1,
      NULL,
      1.894128,
      6.277643,
      NULL,
      0,
      NULL,
      1,
      4,
      2.322679,
      NULL,
      4.023452,
      6,
      7,
      NULL,
      3,
      5,
      6,
      NULL,
      3.935541,
      1.682076,
      2.915483,
      6,
      0,
      ' 0- 3-1977',
      1991.297430,
      ' 1-21-1994',
      2144,
      NULL,
      0,
      0.582276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.613672,
      0,
      0,
      1.539192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.990375,
      0,
      0.901362,
      NULL,
      6.062126,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.862488,
      2.560645,
      NULL,
      0,
      2.741963,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.913249,
      NULL,
      2,
      0.760044,
      0,
      NULL,
      3.407365,
      60.195287,
      1.667576,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.757110,
      2.528427,
      1.657728,
      0,
      1,
      NULL,
      2.726283,
      NULL,
      0,
      0.715437,
      NULL,
      3.061707,
      1,
      3.150613,
      2,
      2,
      0.230025,
      1.583503,
      0.123507,
      1,
      0.678537,
      0.475768,
      0.200721,
      0,
      0.478065,
      1,
      0.294309,
      NULL,
      NULL,
      1.730216,
      0,
      NULL,
      NULL,
      1,
      7,
      2,
      3.215637,
      3.108419,
      NULL,
      7.403585,
      3,
      1.448843,
      2.647821,
      8,
      0,
      NULL,
      32.077037,
      NULL,
      41,
      12,
      5,
      NULL,
      3.505939,
      '33041',
      '',
      '',
      0.115775,
      '',
      NULL,
      '',
      3,
      '20044',
      '',
      '',
      3.237979,
      NULL,
      517,
      43.465803,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.636981,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.474816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      1.477451,
      NULL,
      0.242951,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.680549,
      2,
      7,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.327660,
      NULL,
      NULL,
      1.377996,
      2,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      2.052408,
      0.774322,
      1.398966,
      NULL,
      NULL,
      1,
      3.794637,
      0.737669,
      NULL,
      1,
      1,
      0,
      0,
      0.129408,
      0,
      1,
      0,
      NULL,
      6.557150,
      3,
      7.838256,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.414121,
      NULL,
      NULL,
      NULL,
      3.720344,
      3.220745,
      NULL,
      NULL,
      NULL,
      4.206778,
      1.982964,
      1.330882,
      3.134854,
      0.821680,
      2,
      1,
      NULL,
      NULL,
      2.907758,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.064345,
      1,
      NULL,
      1.151309,
      NULL,
      NULL,
      1,
      0,
      4,
      NULL,
      NULL,
      2.878615,
      0.406543,
      NULL,
      NULL,
      2,
      1.251187,
      0,
      3.349737,
      0,
      0,
      1,
      1,
      NULL,
      6,
      0,
      1,
      2,
      0.150981,
      0.419824,
      3.321118,
      NULL,
      3.436990,
      3.667530,
      0.617947,
      NULL,
      3.511232,
      NULL,
      NULL,
      0,
      NULL,
      0.740941,
      4,
      1.812787,
      NULL,
      2,
      4,
      5,
      0.124535,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.638256,
      NULL,
      NULL,
      0.141293,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.181797,
      NULL,
      NULL,
      0.257312,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.496160,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      0.713683,
      1.699670,
      1.076500,
      1.158390,
      1,
      2.230544,
      0,
      NULL,
      NULL,
      2.386350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.981600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.004872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.219635,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.541693,
      5.756064,
      1.063252,
      NULL,
      NULL,
      NULL,
      1.061030,
      NULL,
      NULL,
      1.696215,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.627141,
      NULL,
      NULL,
      1.112378,
      NULL,
      NULL,
      1,
      0,
      1.397034,
      NULL,
      0.244889,
      NULL,
      NULL,
      1.794120,
      NULL,
      1,
      NULL,
      0,
      1,
      0.941038,
      1.209970,
      NULL,
      1,
      0.195743,
      1.507272,
      2.185856,
      NULL,
      1.316369,
      NULL,
      3.497429,
      NULL,
      1.352265,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      408.980605,
      NULL,
      3.523351,
      23,
      14.845862,
      1.739319,
      1,
      NULL,
      NULL,
      1.902183,
      NULL,
      2.556164,
      NULL,
      1.220095,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.612680,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.913812,
      NULL,
      0,
      0.260793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.635649,
      NULL,
      14,
      5.301174,
      0,
      1,
      NULL,
      10,
      2,
      1,
      1,
      0,
      0.347888,
      NULL,
      0,
      0,
      NULL,
      2.788479,
      NULL,
      NULL,
      0,
      0.925081,
      NULL,
      1,
      3,
      NULL,
      0,
      0.157497,
      NULL,
      2,
      2.313795,
      NULL,
      1,
      3.545060,
      NULL,
      0,
      NULL,
      NULL,
      0.700067,
      0,
      NULL,
      1,
      NULL,
      NULL,
      2.865982,
      0.166297,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.243960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.865196,
      NULL,
      NULL,
      NULL,
      3.617833,
      NULL,
      8.840305,
      2,
      0,
      2.414959,
      75,
      NULL,
      1,
      1,
      3,
      NULL,
      '31244',
      NULL,
      0,
      '',
      NULL,
      NULL,
      0.017730,
      NULL,
      '',
      '');
commit;
end;
/


