set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7931775';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-8-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      '3122',
      2.443701,
      1,
      NULL,
      NULL,
      ' 5-14-1981',
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      191.726285,
      1212.427909,
      NULL,
      NULL,
      ' 1-14-1989',
      '11-13-1986',
      1,
      0.633309,
      3.805014,
      1.988564,
      1.130845,
      3.030600,
      NULL,
      1.815815,
      NULL,
      218,
      NULL,
      14.269884,
      5,
      14.406640,
      111,
      6.875944,
      12,
      7,
      3.726997,
      NULL,
      0.255135,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      109,
      3.121101,
      5.927738,
      1.266096,
      3.744523,
      1.434772,
      NULL,
      0.020739,
      1,
      2,
      1,
      0,
      1,
      0.578940,
      2.705980,
      0.934998,
      NULL,
      4.178677,
      0,
      4.157513,
      0.037794,
      0.257739,
      0,
      NULL,
      NULL,
      0.300652,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.082821,
      1.691038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1.216185,
      1.045713,
      4.400559,
      5,
      3.479317,
      1,
      0,
      0.104440,
      0,
      1.887773,
      1,
      5,
      1,
      1,
      1,
      1.584653,
      0,
      NULL,
      1.522528,
      0,
      1,
      0.898223,
      0,
      2,
      3,
      1,
      1,
      1,
      NULL,
      2,
      NULL,
      7.419006,
      2.364287,
      1.912386,
      2,
      5.219644,
      NULL,
      NULL,
      7,
      9.771451,
      11.795852,
      10,
      NULL,
      NULL,
      1.004018,
      1,
      ' 9-10-1976',
      238.917776,
      NULL,
      771.303786,
      NULL,
      1.950960,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.395806,
      NULL,
      NULL,
      1.312066,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.407654,
      NULL,
      NULL,
      NULL,
      NULL,
      1.036121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.748284,
      NULL,
      1.052576,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.850282,
      1.635760,
      2,
      0.906804,
      1.922385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      6.334905,
      3.089255,
      0.869650,
      NULL,
      4,
      2.335496,
      2.870821,
      6,
      3.945278,
      0,
      0.565526,
      49,
      2,
      0,
      NULL,
      45,
      22.159575,
      10.185010,
      NULL,
      1.505762,
      0.105452,
      '22122',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      0.505768,
      '',
      NULL,
      NULL,
      NULL,
      8,
      273.672098,
      14.834656,
      0.683141,
      0.187102,
      11.709507,
      428,
      NULL,
      3.198394,
      1.308475,
      NULL,
      1.034199,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.099683,
      0.409973,
      0.075579,
      NULL,
      NULL,
      1,
      2.291048,
      NULL,
      1.494061,
      NULL,
      NULL,
      0.618359,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.551492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.003889,
      NULL,
      0.960128,
      NULL,
      NULL,
      NULL,
      1.580571,
      NULL,
      NULL,
      NULL,
      1.840302,
      NULL,
      2.830712,
      1,
      NULL,
      NULL,
      1.950738,
      NULL,
      NULL,
      0.726950,
      1,
      0,
      1.139616,
      NULL,
      NULL,
      1.317877,
      0,
      0.930018,
      1.602895,
      0,
      1,
      1,
      0,
      0.505885,
      0.840282,
      0.898565,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.174179,
      NULL,
      NULL,
      6.671746,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.049378,
      NULL,
      NULL,
      NULL,
      1.177030,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.609265,
      5.637211,
      3,
      0,
      2,
      3.315900,
      1,
      NULL,
      NULL,
      3.649765,
      5.008847,
      1.545493,
      0,
      NULL,
      NULL,
      0.906910,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.512946,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2.624206,
      1.057128,
      NULL,
      NULL,
      NULL,
      4,
      1.495668,
      0,
      6.057343,
      2.604534,
      2.150363,
      2,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      2.179315,
      0.541801,
      2,
      2.788878,
      1,
      3.994283,
      6.606789,
      0.372317,
      1.592796,
      2.236625,
      3.740849,
      3,
      2.854028,
      3,
      2.534456,
      1,
      3.340004,
      NULL,
      0.212269,
      NULL,
      NULL,
      8,
      3.630032,
      2.612799,
      NULL,
      NULL,
      2.382632,
      0.883893,
      0.560894,
      NULL,
      1,
      1.116443,
      NULL,
      0,
      3.093403,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.187293,
      NULL,
      NULL,
      1.414425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.492948,
      NULL,
      NULL,
      1.717665,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.784128,
      1.773094,
      NULL,
      0.904114,
      1,
      2.609790,
      1.041504,
      NULL,
      NULL,
      2,
      3.093896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.787262,
      1.150075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.235745,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0.682584,
      0.312787,
      NULL,
      NULL,
      0.047641,
      0.778879,
      NULL,
      NULL,
      0,
      0.318533,
      NULL,
      NULL,
      3,
      1.209915,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      11,
      4,
      NULL,
      NULL,
      0.776674,
      7,
      NULL,
      NULL,
      0.295043,
      408.305290,
      114.074395,
      2,
      184.405477,
      25,
      1,
      NULL,
      NULL,
      2,
      1930,
      NULL,
      NULL,
      26,
      191.727862,
      2,
      906,
      1364.937920,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.607729,
      0,
      1.219100,
      NULL,
      0.777807,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      1.586653,
      1,
      1.246277,
      1.961006,
      1.437278,
      0.252302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.580000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      6,
      2,
      11.867714,
      0.032996,
      2.344121,
      5.262101,
      1.358487,
      6,
      2.643928,
      1,
      NULL,
      17,
      NULL,
      NULL,
      10.773647,
      16.935196,
      0.383588,
      14.681058,
      1,
      3,
      NULL,
      1.710404,
      0,
      7,
      1,
      1.359737,
      NULL,
      3.289760,
      NULL,
      5,
      0,
      NULL,
      3.065091,
      2,
      2.043185,
      1.374154,
      0,
      1,
      NULL,
      1.976667,
      1.678914,
      5,
      1.882555,
      0,
      1,
      NULL,
      0.792819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.304904,
      1.358102,
      1.952029,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.861504,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.325041,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3.893004,
      NULL,
      NULL,
      0.909735,
      NULL,
      0,
      1.756509,
      1,
      6.474508,
      8,
      4,
      2.684025,
      1.099341,
      NULL,
      25.230336,
      NULL,
      3.047723,
      1,
      NULL,
      '31334',
      '',
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.121594,
      NULL,
      '',
      '');
commit;
end;
/


