set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6702192';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-2-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      '1133420',
      3,
      1,
      0,
      0,
      '4402',
      1.741843,
      0.097605,
      NULL,
      NULL,
      ' 1- 6-2002',
      NULL,
      NULL,
      2.030980,
      0.384288,
      1,
      '11-25-1976',
      0.724646,
      1,
      297,
      65,
      NULL,
      NULL,
      ' 7-23-2003',
      ' 2-22-1999',
      3,
      2,
      0.278988,
      2,
      0,
      3.970673,
      2,
      1,
      NULL,
      65,
      7.311770,
      5.838109,
      9,
      10,
      0.872654,
      5,
      15,
      NULL,
      2,
      9.419895,
      1,
      3,
      0.656596,
      0.169991,
      1.393305,
      0.860962,
      1,
      NULL,
      0,
      1,
      NULL,
      0.488074,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      0.489100,
      2,
      0.801037,
      1.219419,
      1.389561,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2.484714,
      0.910068,
      0.978726,
      NULL,
      NULL,
      0.948751,
      NULL,
      NULL,
      3.612855,
      2.441593,
      1,
      2.068137,
      NULL,
      1,
      0,
      0.231628,
      NULL,
      0.565618,
      1.074975,
      0.786757,
      0,
      0.454845,
      1,
      2.421522,
      0,
      1.308844,
      NULL,
      3,
      0,
      2.224733,
      7.304927,
      1.714321,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.261858,
      NULL,
      NULL,
      NULL,
      7.547076,
      4.750551,
      0.614829,
      4,
      NULL,
      NULL,
      5.613814,
      NULL,
      5,
      6,
      0.175150,
      6.234186,
      8,
      2.555064,
      4,
      0.121157,
      1.159477,
      3,
      0.374782,
      7,
      9,
      4,
      2.192465,
      0,
      NULL,
      1.565275,
      5,
      5,
      5,
      5.157826,
      2,
      6.856846,
      0,
      1,
      1.920214,
      10.022524,
      4,
      NULL,
      11,
      5.616982,
      0.128233,
      NULL,
      7,
      10,
      1,
      2.374899,
      NULL,
      '11-19-1986',
      110.143404,
      '10- 4-1978',
      17,
      2.247459,
      0.152397,
      1,
      2.087522,
      0.914579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.686269,
      1,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      3.891035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.597281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.328183,
      NULL,
      NULL,
      2.303888,
      NULL,
      3.445278,
      2.111810,
      0.053831,
      2.222005,
      3,
      2.991749,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.138963,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.322193,
      1.195798,
      NULL,
      0.321874,
      NULL,
      0,
      2,
      5.823652,
      3.612471,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.291286,
      2.708811,
      0.743538,
      3,
      1.051292,
      3.752811,
      2,
      2,
      2.198338,
      3,
      1.190775,
      3.925414,
      2,
      NULL,
      0,
      0,
      3.398674,
      1.162364,
      1,
      NULL,
      1.533206,
      0.290738,
      0,
      1,
      NULL,
      1.273000,
      8.859788,
      3,
      0.976652,
      11.891889,
      1.636255,
      7,
      6.741588,
      NULL,
      0.464285,
      3,
      0,
      5.931353,
      0.374183,
      1,
      2.849168,
      40,
      1,
      1.854949,
      NULL,
      NULL,
      5,
      19.055887,
      3,
      1.504157,
      2.690286,
      '21313',
      NULL,
      '',
      1.031189,
      '',
      '',
      '',
      0.573321,
      NULL,
      '',
      '',
      3,
      12.483416,
      NULL,
      1.829326,
      NULL,
      20.846077,
      7.826936,
      1.711737,
      3.322329,
      3.106774,
      1,
      1.206726,
      1.622153,
      NULL,
      NULL,
      0.501527,
      0,
      1.483245,
      2,
      1.774350,
      1,
      0.709268,
      0.983801,
      0,
      NULL,
      0.679022,
      1,
      0,
      1.886028,
      1.271307,
      NULL,
      NULL,
      NULL,
      2.471365,
      0.108940,
      NULL,
      NULL,
      NULL,
      NULL,
      1.338343,
      0,
      1.019303,
      0,
      1.039736,
      1,
      NULL,
      2.946305,
      3,
      1.935637,
      NULL,
      3.350053,
      1,
      2,
      3,
      1.751195,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.317994,
      3.967232,
      1,
      0.819895,
      1,
      2,
      1,
      0.709763,
      1,
      0,
      NULL,
      1.864458,
      3.917717,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.369523,
      NULL,
      NULL,
      0,
      4,
      1.653503,
      1,
      1.680810,
      8,
      1.362770,
      0.584204,
      NULL,
      0,
      0.288288,
      1,
      0.161335,
      0.499159,
      1.808889,
      2.434745,
      1.955078,
      2,
      0,
      NULL,
      1.374545,
      NULL,
      NULL,
      NULL,
      0,
      5,
      0,
      3.425084,
      0,
      3,
      1,
      1.857094,
      3,
      6.209848,
      NULL,
      1,
      0.629793,
      1,
      1,
      1,
      0,
      0,
      0.922734,
      NULL,
      NULL,
      1.238350,
      NULL,
      NULL,
      0.320048,
      0,
      0,
      2,
      1,
      1,
      3,
      1,
      0,
      0,
      NULL,
      0,
      0,
      3.126894,
      2,
      2.764907,
      2,
      2.056942,
      2.004291,
      3,
      1,
      2,
      2,
      NULL,
      2.182479,
      NULL,
      2.795727,
      NULL,
      0,
      3,
      NULL,
      2.131048,
      NULL,
      3,
      3,
      NULL,
      3,
      0,
      3.246457,
      NULL,
      0.764375,
      NULL,
      NULL,
      2.894757,
      2,
      7,
      1.997942,
      NULL,
      6.633298,
      2,
      0,
      1.106760,
      2,
      8,
      1,
      2,
      2,
      0.416813,
      NULL,
      1.999871,
      NULL,
      NULL,
      3.725539,
      1,
      NULL,
      NULL,
      3.581011,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.037441,
      NULL,
      NULL,
      2.154926,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.761543,
      NULL,
      0.237997,
      1.514202,
      NULL,
      2,
      0.597565,
      NULL,
      0.704906,
      3,
      NULL,
      1,
      0.584645,
      NULL,
      5.519070,
      1.979639,
      NULL,
      3,
      2.680095,
      2,
      0,
      1.788634,
      2,
      1,
      NULL,
      4,
      0,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      2.706537,
      0.739232,
      NULL,
      NULL,
      NULL,
      0.942413,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.016125,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.991821,
      0.693235,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.378171,
      NULL,
      NULL,
      0,
      2.811779,
      NULL,
      NULL,
      1.648344,
      1,
      NULL,
      NULL,
      3.470917,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.602941,
      1,
      NULL,
      NULL,
      2.171868,
      0,
      NULL,
      NULL,
      3,
      1.242558,
      NULL,
      NULL,
      NULL,
      0.733062,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      0.151532,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.246300,
      6.369364,
      0.030491,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.193002,
      NULL,
      NULL,
      1.508042,
      1.393564,
      NULL,
      1,
      NULL,
      NULL,
      1.524377,
      NULL,
      0,
      72.975458,
      10.231897,
      1,
      1,
      0,
      NULL,
      NULL,
      1.332768,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.166689,
      0.784045,
      0.851307,
      1.355328,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.769128,
      NULL,
      NULL,
      1.524907,
      0.871822,
      NULL,
      NULL,
      0.436305,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.222996,
      NULL,
      NULL,
      NULL,
      0.880381,
      NULL,
      0.110106,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1.572378,
      NULL,
      0.678854,
      NULL,
      0.835703,
      NULL,
      0,
      NULL,
      0.062464,
      1.419525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.063828,
      0,
      3,
      1.727265,
      0.636509,
      NULL,
      0.398438,
      3.406436,
      3.886852,
      NULL,
      0,
      1.482574,
      1,
      NULL,
      0.056161,
      0,
      NULL,
      1,
      3.354674,
      NULL,
      3.249293,
      NULL,
      NULL,
      2,
      2.646684,
      NULL,
      NULL,
      0,
      NULL,
      1.083812,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      0.441724,
      NULL,
      1.779244,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.201123,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.321552,
      NULL,
      3.401758,
      1.224085,
      8.985137,
      1.858168,
      NULL,
      NULL,
      38.962215,
      NULL,
      NULL,
      1.005569,
      4,
      '31424',
      '01323',
      '',
      1,
      '',
      '',
      NULL,
      0.332678,
      '',
      '',
      '');
commit;
end;
/


