set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8104004';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-7-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '1202413',
      3.445066,
      0,
      0,
      0,
      NULL,
      1.914190,
      NULL,
      NULL,
      NULL,
      ' 3-17-2003',
      NULL,
      NULL,
      NULL,
      2.757639,
      0,
      ' 4- 2-1974',
      30,
      3.673571,
      96,
      NULL,
      NULL,
      ' 6-21-1975',
      NULL,
      '10-25-1997',
      1,
      1.526064,
      0,
      NULL,
      1,
      1,
      NULL,
      1.539152,
      1,
      192,
      4,
      9.462431,
      15,
      35.860716,
      65,
      16,
      9.356688,
      5,
      NULL,
      NULL,
      1,
      0.704151,
      0,
      1,
      1.714511,
      NULL,
      1,
      NULL,
      NULL,
      0.630647,
      45,
      3.544698,
      NULL,
      6,
      2.954573,
      1.097109,
      NULL,
      1,
      0.605891,
      0.928463,
      1.520207,
      2,
      0,
      1.652959,
      NULL,
      NULL,
      NULL,
      2.298170,
      0,
      5,
      1,
      1,
      0.841143,
      NULL,
      NULL,
      0.859336,
      NULL,
      NULL,
      4,
      NULL,
      0.702234,
      1.702698,
      0,
      0.906039,
      0.367159,
      0,
      0,
      0,
      1.661508,
      1,
      0,
      1,
      NULL,
      0.975014,
      0,
      0.481570,
      NULL,
      1.751571,
      1.330592,
      NULL,
      NULL,
      3,
      2.768480,
      3.909621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      0.129499,
      NULL,
      0.159278,
      1,
      0,
      0,
      1.237159,
      1,
      1,
      0,
      1.385438,
      0.351122,
      0,
      1.326752,
      NULL,
      1.039549,
      2.972071,
      0,
      0.509762,
      2,
      NULL,
      7,
      0,
      1,
      1,
      7,
      NULL,
      NULL,
      3,
      NULL,
      7.316455,
      NULL,
      NULL,
      9,
      8,
      8,
      NULL,
      0.595687,
      8,
      4,
      NULL,
      1,
      NULL,
      NULL,
      143,
      ' 2-13-1994',
      48.538296,
      3.431781,
      1.086115,
      NULL,
      NULL,
      0.129662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.049977,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.570956,
      0.882674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.959534,
      NULL,
      0.391666,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.435056,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.210974,
      1.413432,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2.777649,
      128.399000,
      2.696229,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.236829,
      47,
      2,
      0.395205,
      0,
      '41141',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      67,
      14.933473,
      NULL,
      1,
      46,
      12,
      46.166801,
      NULL,
      2.732146,
      0.320168,
      2,
      NULL,
      NULL,
      NULL,
      1.169768,
      NULL,
      NULL,
      1.801447,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.887625,
      NULL,
      NULL,
      0.206936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.911590,
      NULL,
      NULL,
      1.788295,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      0.484961,
      NULL,
      NULL,
      NULL,
      0.536296,
      NULL,
      NULL,
      NULL,
      1.693790,
      3.593585,
      NULL,
      0.474736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1.333563,
      0.671981,
      1,
      1,
      1.524358,
      1,
      0.895258,
      0.844447,
      0.164656,
      0.138251,
      0,
      1.815426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.173860,
      1,
      0.267446,
      NULL,
      NULL,
      NULL,
      0.438845,
      NULL,
      NULL,
      NULL,
      0.317173,
      NULL,
      NULL,
      2.047513,
      0,
      1,
      1.723768,
      NULL,
      NULL,
      1.820942,
      NULL,
      NULL,
      2.375210,
      6,
      0.513702,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      7,
      3,
      NULL,
      2,
      0,
      NULL,
      1.728654,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.792376,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.661357,
      1.324896,
      NULL,
      NULL,
      0,
      1.033735,
      2,
      1,
      6.763237,
      NULL,
      3.556843,
      1,
      8.845288,
      5.489074,
      0.537562,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1.282142,
      1.008892,
      NULL,
      0,
      2,
      3,
      6,
      9.973725,
      2,
      0,
      NULL,
      2.842737,
      2.323344,
      3,
      2.779391,
      1.320844,
      1.669871,
      3,
      1.866895,
      2,
      NULL,
      3.905783,
      4,
      2.378447,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.477075,
      1.010347,
      0,
      0.689374,
      NULL,
      1.313678,
      1.236978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.021841,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.281684,
      0.577804,
      0.746332,
      1,
      1,
      0.085135,
      NULL,
      NULL,
      NULL,
      2,
      0.445743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.380482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.904038,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.640603,
      NULL,
      NULL,
      NULL,
      0,
      1.000047,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.606090,
      1,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.563824,
      93.766981,
      37.736494,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.050025,
      NULL,
      0.224445,
      3477,
      743,
      0.934136,
      NULL,
      1,
      0,
      NULL,
      1.269043,
      0.402074,
      1.246212,
      0.414973,
      NULL,
      0,
      0,
      0.814161,
      1.338665,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7,
      NULL,
      6.106910,
      2,
      NULL,
      0.226189,
      NULL,
      NULL,
      1,
      3,
      1.092029,
      19.166413,
      7,
      0.104692,
      NULL,
      NULL,
      NULL,
      0,
      8,
      NULL,
      3.883059,
      11.211160,
      NULL,
      18.035227,
      11.879979,
      0,
      NULL,
      NULL,
      1.418519,
      9.963313,
      10.127631,
      0,
      NULL,
      2.025116,
      0,
      14.406095,
      13,
      1,
      2.453842,
      13,
      3,
      13.339627,
      12.479154,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.942114,
      1.147708,
      0,
      NULL,
      0.704158,
      5,
      3.941787,
      10.899675,
      3,
      1,
      NULL,
      11.364490,
      14,
      NULL,
      1.579688,
      2,
      '24013',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


