set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8919885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      4.888745,
      NULL,
      NULL,
      3.306888,
      3.126703,
      0,
      0.353612,
      '011',
      '23411202',
      NULL,
      NULL,
      '1231402',
      NULL,
      0.730177,
      4,
      2,
      '4143',
      NULL,
      0.014941,
      NULL,
      NULL,
      ' 1-23-1975',
      NULL,
      10.167762,
      NULL,
      2.891337,
      0,
      ' 9-22-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '11-25-1996',
      1.232625,
      3,
      NULL,
      NULL,
      0.495631,
      0.758373,
      2,
      3,
      NULL,
      NULL,
      NULL,
      13,
      5.811050,
      NULL,
      NULL,
      NULL,
      NULL,
      3.306098,
      NULL,
      NULL,
      NULL,
      4.658988,
      NULL,
      0,
      0,
      1.419892,
      0.686449,
      1.707929,
      0,
      0.277629,
      1.567496,
      3,
      4.834952,
      4.109993,
      3,
      3.036488,
      0,
      0,
      1.841370,
      0.615783,
      0.993421,
      0.263854,
      0,
      0,
      NULL,
      0.580296,
      0.469713,
      1,
      1.780125,
      3,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0.218760,
      NULL,
      NULL,
      1.002205,
      1.394210,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.327819,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.306240,
      2.853063,
      0.640538,
      1.006431,
      5,
      1.571848,
      NULL,
      NULL,
      1.528082,
      NULL,
      0.607616,
      1,
      0.662296,
      1.843578,
      NULL,
      1,
      NULL,
      1.942317,
      1.231398,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.580071,
      1.704246,
      3,
      1.776371,
      NULL,
      3,
      NULL,
      6.117209,
      8.986876,
      0.575828,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.079420,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.151116,
      0,
      1.067252,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.543202,
      NULL,
      NULL,
      NULL,
      NULL,
      0.934603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.095270,
      0,
      NULL,
      1.224518,
      0.288360,
      2.840882,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.742645,
      0.622450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.154442,
      1,
      1.041388,
      1,
      0.301263,
      0.099965,
      1.290059,
      NULL,
      1.101992,
      0,
      NULL,
      NULL,
      NULL,
      5,
      0.656243,
      0,
      NULL,
      5,
      0,
      5.692900,
      3,
      3,
      2,
      3.711075,
      5,
      NULL,
      3,
      NULL,
      1,
      0,
      0,
      NULL,
      0.057530,
      0.399342,
      0.137658,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      0,
      0,
      1.822070,
      0.689373,
      9,
      10.834135,
      4.854840,
      2,
      2,
      0.239521,
      2,
      3.541884,
      3,
      0.743276,
      3,
      3.904608,
      25,
      2.018519,
      1.576211,
      NULL,
      NULL,
      NULL,
      NULL,
      5.416172,
      4.825934,
      1.013059,
      '2101',
      '32034',
      '',
      0,
      '12442',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.930669,
      12,
      16,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.017877,
      0.787381,
      0,
      1,
      NULL,
      NULL,
      0.264455,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.506200,
      NULL,
      NULL,
      3.107209,
      2.629827,
      NULL,
      NULL,
      NULL,
      NULL,
      1.692228,
      NULL,
      NULL,
      1.562465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.856861,
      NULL,
      4,
      1,
      0.640581,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.665560,
      NULL,
      NULL,
      1.522934,
      NULL,
      NULL,
      1.338626,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.820083,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.793067,
      3.142736,
      3,
      2.079632,
      1.642325,
      2,
      0,
      0.926933,
      0.992108,
      NULL,
      NULL,
      NULL,
      2.941738,
      0.937351,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.222258,
      NULL,
      NULL,
      0.298439,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.543247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.677847,
      NULL,
      NULL,
      0.014224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.165318,
      NULL,
      NULL,
      NULL,
      4.404459,
      6,
      5.013987,
      2.604696,
      NULL,
      3.676857,
      NULL,
      0.466487,
      NULL,
      2.395374,
      0.199220,
      3,
      0.959561,
      1,
      0.564454,
      0,
      4,
      4,
      4.953295,
      6,
      1.499462,
      0.312433,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.878661,
      0.596741,
      0,
      1.178148,
      0.781486,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.587250,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      9.602517,
      NULL,
      1,
      NULL,
      NULL,
      0.034227,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.366085,
      0,
      1.944310,
      1,
      1.149217,
      0,
      0,
      0,
      1.905524,
      0.553868,
      1,
      1.829810,
      NULL,
      NULL,
      0,
      0.696288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      5,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.741693,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.393635,
      NULL,
      NULL,
      0.916639,
      NULL,
      NULL,
      1.692484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.673464,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      5.264726,
      NULL,
      0.458555,
      NULL,
      NULL,
      NULL,
      12.022835,
      2.652461,
      4.183127,
      2.021574,
      '1241',
      '42440',
      '',
      NULL,
      '22132',
      NULL,
      '',
      0,
      '',
      NULL,
      '');
commit;
end;
/


