set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8505820';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-1-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '01',
      '31',
      18,
      31.270785,
      '4301234',
      3,
      1.414251,
      6,
      2,
      '4401',
      4.807129,
      NULL,
      NULL,
      NULL,
      ' 0- 1-1990',
      14,
      45.940696,
      NULL,
      0,
      13.153337,
      ' 8-26-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-11-1989',
      NULL,
      ' 5-14-2002',
      1.927885,
      0.452255,
      0.263083,
      2,
      0,
      0.705396,
      NULL,
      1.731245,
      NULL,
      NULL,
      2.575155,
      19.750522,
      7.537051,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.676192,
      1.574083,
      0,
      NULL,
      NULL,
      NULL,
      0.678956,
      NULL,
      NULL,
      0,
      NULL,
      2.911147,
      3.980621,
      1,
      2,
      NULL,
      2.903965,
      1,
      1.574873,
      NULL,
      NULL,
      0,
      0.166005,
      1,
      0.433675,
      1.633053,
      1,
      1,
      0.413375,
      2.349802,
      0.648737,
      0,
      1,
      NULL,
      NULL,
      1.899831,
      NULL,
      NULL,
      9.888733,
      2.846487,
      NULL,
      2.069198,
      0,
      1,
      NULL,
      NULL,
      0.062134,
      1.242041,
      NULL,
      NULL,
      0.681958,
      3,
      0,
      1.836098,
      0,
      0.725564,
      NULL,
      1,
      1.466224,
      0.934448,
      8.098935,
      0.464930,
      3.430584,
      1.025447,
      1,
      NULL,
      NULL,
      0.655697,
      NULL,
      NULL,
      1,
      0.480516,
      NULL,
      0,
      1.792116,
      1.661461,
      1.299819,
      NULL,
      0,
      0,
      1,
      1,
      0,
      1.616366,
      0,
      0,
      1,
      1,
      0,
      NULL,
      0.355446,
      9.588954,
      0,
      0,
      6.215430,
      0,
      7.448197,
      NULL,
      3,
      NULL,
      NULL,
      0.019249,
      0,
      0,
      1,
      1,
      2,
      1,
      NULL,
      7,
      0,
      1.941659,
      2.565054,
      9,
      1.044397,
      NULL,
      NULL,
      3.416292,
      ' 5- 7-1987',
      312,
      ' 0-20-1986',
      12,
      2,
      0.320686,
      0,
      NULL,
      0.075355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.284770,
      6.580708,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3,
      2.235052,
      1.860124,
      NULL,
      0.857268,
      1.132022,
      1.327268,
      0.519767,
      11,
      3.226583,
      1.928942,
      2.405930,
      2,
      1,
      1.556626,
      2,
      1,
      8.477516,
      0.274906,
      1,
      1.720518,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.664251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.023153,
      1.250102,
      0,
      0.776543,
      1,
      1,
      0,
      3,
      NULL,
      0,
      0.117356,
      NULL,
      NULL,
      NULL,
      1.157771,
      0,
      2.959171,
      0,
      3.634954,
      3.788583,
      NULL,
      2,
      NULL,
      NULL,
      3,
      2,
      NULL,
      3.843913,
      NULL,
      NULL,
      7,
      NULL,
      1,
      0.457455,
      0.306668,
      0.186422,
      NULL,
      1.950814,
      0,
      0.670071,
      0.177897,
      1.194524,
      3.510504,
      NULL,
      5.237693,
      0.607961,
      5.995527,
      7,
      7,
      1.321940,
      3.930507,
      5,
      3.249515,
      3,
      4.848120,
      0,
      2.797233,
      3.231953,
      50.456481,
      3.099009,
      NULL,
      14.296131,
      NULL,
      2,
      1,
      2.998609,
      1,
      2,
      '31423',
      '',
      NULL,
      0.494531,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0.639529,
      9.313978,
      NULL,
      NULL,
      0.718708,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3.805506,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.586649,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.375687,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.943207,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.699900,
      NULL,
      NULL,
      0.405205,
      NULL,
      NULL,
      1,
      3.678044,
      1.914050,
      1,
      0.799661,
      NULL,
      NULL,
      NULL,
      0.218983,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.196746,
      NULL,
      NULL,
      1.048602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.542982,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.376699,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.857070,
      NULL,
      NULL,
      1.239770,
      NULL,
      NULL,
      0.440997,
      NULL,
      NULL,
      0.857462,
      NULL,
      NULL,
      0.080550,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.570382,
      NULL,
      NULL,
      0.150905,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.165205,
      NULL,
      NULL,
      1.384623,
      NULL,
      NULL,
      0.988847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.841386,
      NULL,
      NULL,
      0.061184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.315800,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.685179,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.340505,
      0,
      0.697951,
      0.178434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.065363,
      0.281209,
      0.515288,
      NULL,
      NULL,
      1.254918,
      NULL,
      NULL,
      2.915437,
      0,
      1,
      1,
      NULL,
      NULL,
      1.459181,
      NULL,
      NULL,
      0.517260,
      NULL,
      0.472505,
      373,
      1,
      0.933748,
      0,
      0,
      1.804917,
      0,
      NULL,
      0.266686,
      0.064791,
      0.511526,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.758929,
      0.142559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.735581,
      NULL,
      7,
      1,
      1.253770,
      2,
      3.107187,
      7.719095,
      1.531330,
      2.686688,
      0,
      1,
      0,
      NULL,
      0.476515,
      NULL,
      NULL,
      0,
      0.551698,
      NULL,
      1,
      0.515583,
      NULL,
      2.783473,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.111747,
      1.854172,
      NULL,
      0.932823,
      NULL,
      NULL,
      0,
      1.078635,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.870363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.570489,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      1.972013,
      4,
      1.468617,
      NULL,
      NULL,
      NULL,
      34,
      4,
      2.742923,
      0.665775,
      '23121',
      '',
      '',
      1.704117,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


