set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8505820';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-2-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.679648,
      3.575857,
      NULL,
      5.353830,
      0,
      0,
      3.070506,
      0,
      '334',
      '10004011',
      25,
      43.563028,
      NULL,
      5,
      0,
      0,
      NULL,
      '4231',
      1.241304,
      0,
      NULL,
      NULL,
      ' 1- 6-1998',
      178.320464,
      NULL,
      NULL,
      2,
      1.977687,
      ' 0-17-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      2.594447,
      NULL,
      ' 5- 8-2002',
      ' 2-20-1979',
      1.683884,
      NULL,
      1,
      NULL,
      0,
      1,
      6.053364,
      1.795059,
      1.064616,
      5.968566,
      4.102435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.016104,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1.821052,
      1.454245,
      1,
      0.078841,
      2.039313,
      0,
      1.850518,
      3,
      3,
      2,
      NULL,
      4.962102,
      1,
      1,
      1.566744,
      9.902750,
      1,
      1,
      0.013286,
      NULL,
      1,
      1,
      NULL,
      2.077200,
      0,
      5,
      0,
      0.638743,
      NULL,
      NULL,
      NULL,
      0.504198,
      NULL,
      NULL,
      0,
      0.582964,
      3.207663,
      NULL,
      1.336487,
      0.882185,
      NULL,
      NULL,
      0.125367,
      1,
      3,
      0,
      NULL,
      3.417259,
      2.022173,
      NULL,
      NULL,
      NULL,
      1.607169,
      0.181926,
      NULL,
      2.940400,
      8,
      0,
      2.883662,
      0.053860,
      0,
      NULL,
      NULL,
      1.513784,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      4,
      NULL,
      1.863239,
      0.447776,
      0,
      1,
      2.026353,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      3,
      0,
      1.230198,
      1,
      4.772184,
      1.529623,
      0.398534,
      1,
      2.219644,
      5.352045,
      2.343377,
      1.785785,
      1.936199,
      NULL,
      6,
      1,
      4.969789,
      1.975684,
      7.606155,
      9.488363,
      11.705909,
      NULL,
      NULL,
      2,
      NULL,
      1.900823,
      ' 3-26-1974',
      138,
      ' 1-28-1981',
      15.757520,
      NULL,
      0,
      0.221140,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.511538,
      1,
      0.762765,
      1,
      0.046831,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.141414,
      NULL,
      NULL,
      NULL,
      NULL,
      3.404348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      1,
      NULL,
      3.136479,
      0.527975,
      NULL,
      NULL,
      NULL,
      0.128952,
      NULL,
      0.500039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.933702,
      1,
      1.506046,
      0,
      0,
      0,
      0.228922,
      3.833730,
      2,
      0.003312,
      0.299360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      0,
      3.487839,
      1.782329,
      2,
      1.008534,
      NULL,
      0.928394,
      1.307268,
      3,
      0.788240,
      2.862012,
      0,
      NULL,
      0,
      1.301608,
      1.302719,
      0.062356,
      5,
      NULL,
      0,
      0.088612,
      0,
      NULL,
      5.078735,
      0,
      4,
      0,
      NULL,
      NULL,
      0.802290,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.358138,
      0.587719,
      3,
      1,
      40.221841,
      0.375994,
      1,
      30.391167,
      NULL,
      59,
      66,
      2,
      NULL,
      0,
      '11134',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      3,
      43.311582,
      143,
      NULL,
      0.983743,
      NULL,
      1,
      3.976867,
      3.803049,
      1.800145,
      NULL,
      2,
      1.561818,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.810619,
      NULL,
      NULL,
      1,
      NULL,
      0.165668,
      NULL,
      NULL,
      NULL,
      0.300749,
      1,
      0.876257,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.998459,
      NULL,
      NULL,
      5.471225,
      NULL,
      3,
      1,
      1.088708,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.442924,
      NULL,
      0.451191,
      1.396443,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.737648,
      0,
      1,
      1.905857,
      2,
      0.209395,
      NULL,
      0,
      1.719686,
      2,
      0,
      0.389237,
      2.747509,
      3,
      0,
      0.281299,
      NULL,
      NULL,
      0.059413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.830413,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.149626,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.351383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.051089,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.425601,
      NULL,
      NULL,
      1.962417,
      NULL,
      NULL,
      NULL,
      1,
      1.567694,
      0.321921,
      0.875763,
      0,
      NULL,
      1,
      1.539132,
      5,
      0,
      0.407582,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1.520294,
      0,
      0.856145,
      1,
      NULL,
      7,
      0,
      0.948768,
      3.058516,
      1.038954,
      0,
      1.784234,
      NULL,
      1,
      3,
      1.833275,
      1.671836,
      2.698928,
      0.858021,
      1.187113,
      8,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.781359,
      1,
      6.120938,
      0,
      1,
      NULL,
      1.754608,
      0,
      3.839366,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.512349,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.468535,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.590419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.453274,
      1.401282,
      0,
      1.186964,
      2.911914,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.775369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.550336,
      NULL,
      NULL,
      NULL,
      3.394996,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.960731,
      3.404167,
      1,
      NULL,
      NULL,
      1.177614,
      NULL,
      NULL,
      1.118388,
      NULL,
      NULL,
      1.749293,
      NULL,
      NULL,
      1.250361,
      NULL,
      NULL,
      1,
      NULL,
      0,
      325.837639,
      0.392692,
      1,
      1.149899,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      0.462990,
      1,
      NULL,
      1.803160,
      1.164190,
      0,
      1.523580,
      1.994454,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.187906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      4,
      0.818003,
      1,
      3.229855,
      NULL,
      7.983735,
      0.257671,
      0,
      NULL,
      0.798871,
      0,
      0,
      0,
      0,
      0,
      1.307337,
      1.321998,
      1.828729,
      NULL,
      0,
      0,
      2,
      0,
      0,
      1.680627,
      1.023744,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0.277504,
      1.095389,
      0.482301,
      0,
      NULL,
      0.517290,
      2.444153,
      0,
      1.072288,
      1,
      3,
      0.810367,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.701726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.395196,
      1,
      1.675106,
      0,
      1,
      NULL,
      0.909639,
      6,
      NULL,
      3.095965,
      1.422509,
      0,
      18,
      NULL,
      2.472335,
      3,
      NULL,
      '22010',
      '',
      '',
      1.903959,
      NULL,
      '',
      NULL,
      0.676796,
      '',
      '',
      '');
commit;
end;
/


