set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8423044';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-7-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '3342123',
      3.127481,
      1.450923,
      1,
      0,
      '2212',
      2,
      1,
      NULL,
      NULL,
      NULL,
      16,
      NULL,
      2.235076,
      3,
      0,
      ' 6-12-1984',
      45,
      4.769259,
      161,
      100,
      3.312201,
      ' 8-25-1998',
      ' 3-24-1974',
      ' 6- 9-2000',
      3,
      0,
      2,
      NULL,
      NULL,
      3.380945,
      2,
      1.328802,
      NULL,
      18.752417,
      8,
      4,
      0.469271,
      10,
      0.392728,
      3,
      19,
      2.740710,
      3,
      NULL,
      1,
      0.566826,
      1,
      NULL,
      1,
      0.889940,
      0,
      NULL,
      NULL,
      NULL,
      0.116597,
      3,
      0.660987,
      5.683525,
      1,
      6,
      1,
      0,
      1.055891,
      1,
      NULL,
      5.479911,
      0,
      NULL,
      1.407584,
      0,
      1.452818,
      5.014611,
      NULL,
      5,
      NULL,
      1,
      1.407655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.307528,
      0,
      0,
      NULL,
      3,
      0,
      3,
      0.674800,
      0.855979,
      1.810291,
      3.635213,
      NULL,
      NULL,
      2.506838,
      1,
      0,
      0,
      0,
      0.778996,
      2,
      0,
      2.384612,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.637338,
      0,
      5.559098,
      0.681588,
      NULL,
      0,
      0.933654,
      1,
      1.155497,
      0,
      0,
      1,
      1.635630,
      0,
      0,
      0.103134,
      1.206645,
      NULL,
      0,
      1,
      0.322090,
      0,
      5.065258,
      1,
      NULL,
      5.302717,
      0,
      4,
      1,
      0,
      3.430831,
      NULL,
      NULL,
      0.078113,
      5,
      1,
      9,
      5,
      NULL,
      1,
      0.359734,
      1,
      NULL,
      NULL,
      0,
      3.379172,
      ' 7-12-1979',
      376,
      NULL,
      NULL,
      NULL,
      0.917556,
      1.556321,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.447552,
      NULL,
      0.643353,
      NULL,
      0.646215,
      0,
      3.622306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      55.758005,
      2,
      1,
      3,
      NULL,
      0.144769,
      0,
      0,
      1.339493,
      8,
      2.426742,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      9,
      0.692754,
      7.211357,
      5.629298,
      0,
      1,
      2,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.847000,
      1.803977,
      0.238131,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3.750771,
      1.464221,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.671769,
      3,
      0,
      2,
      NULL,
      1,
      0,
      0.854534,
      NULL,
      1,
      2.928653,
      0.788735,
      2,
      3,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      0.120172,
      1,
      1,
      0.009917,
      0,
      1.233033,
      0.658287,
      1.224431,
      1.152153,
      1,
      NULL,
      NULL,
      1.904608,
      10,
      8,
      6.732047,
      5,
      NULL,
      2.726421,
      1,
      1.898962,
      1,
      47.551032,
      3.047056,
      1,
      NULL,
      1,
      14,
      41.112340,
      NULL,
      NULL,
      1.666853,
      NULL,
      '',
      '',
      1.192780,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1.252654,
      NULL,
      113.435668,
      29,
      NULL,
      2,
      NULL,
      3.790071,
      3,
      2,
      3.726551,
      1.917675,
      0.445485,
      NULL,
      NULL,
      0,
      NULL,
      0.496284,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2,
      1,
      1.801732,
      NULL,
      NULL,
      2.044259,
      0.131050,
      3,
      2,
      0.984302,
      2,
      1.629221,
      NULL,
      NULL,
      1.680873,
      NULL,
      NULL,
      NULL,
      4,
      2,
      1.723313,
      1.553835,
      NULL,
      NULL,
      NULL,
      3.339444,
      0.348694,
      2.381867,
      2,
      2,
      0,
      1,
      1,
      2.900278,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.200291,
      1,
      2.647344,
      1,
      1.380438,
      1.538359,
      0.199573,
      3,
      NULL,
      1.060637,
      1,
      3,
      0.387600,
      1.077440,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.568085,
      NULL,
      NULL,
      7.252740,
      7,
      NULL,
      NULL,
      1.893848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.830561,
      2.080997,
      NULL,
      NULL,
      NULL,
      0.815895,
      NULL,
      NULL,
      2.732983,
      1.664268,
      NULL,
      1.253993,
      NULL,
      NULL,
      5,
      0.503892,
      0.881011,
      0.805014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.063282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3.901811,
      1,
      NULL,
      NULL,
      NULL,
      3.725432,
      0,
      2.649661,
      5.277047,
      7.427974,
      0,
      NULL,
      0.293305,
      1.232882,
      1.313329,
      1,
      0,
      0.616737,
      2,
      0.416668,
      0,
      1.276065,
      7,
      0.946493,
      5,
      2.550348,
      1,
      3,
      1,
      1,
      NULL,
      2,
      NULL,
      1,
      3.331292,
      2.810438,
      NULL,
      4.835457,
      5,
      4.015635,
      3,
      1.022672,
      0,
      0.659603,
      NULL,
      3.017417,
      1,
      1.304292,
      0.267393,
      0,
      1,
      0.220801,
      NULL,
      NULL,
      5.011495,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.268020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.872239,
      NULL,
      NULL,
      1.937499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.998552,
      1.452873,
      1.879644,
      1,
      NULL,
      0.852676,
      NULL,
      NULL,
      NULL,
      10,
      5.185630,
      NULL,
      NULL,
      3,
      3.635385,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.099893,
      2,
      NULL,
      NULL,
      NULL,
      1.769877,
      NULL,
      NULL,
      NULL,
      3.180252,
      NULL,
      NULL,
      0,
      3.937026,
      NULL,
      NULL,
      1,
      0.576070,
      NULL,
      NULL,
      1.457154,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.040993,
      NULL,
      NULL,
      1.364688,
      0,
      NULL,
      NULL,
      0,
      0.657813,
      NULL,
      NULL,
      2.706132,
      2.904240,
      NULL,
      NULL,
      3.312609,
      1.541016,
      NULL,
      NULL,
      1.390017,
      2.690058,
      NULL,
      NULL,
      1,
      1.326767,
      NULL,
      NULL,
      2,
      3.329122,
      NULL,
      NULL,
      NULL,
      1.596653,
      NULL,
      NULL,
      3,
      NULL,
      1.604155,
      0.477547,
      NULL,
      0.837245,
      11.557437,
      3.656698,
      1,
      NULL,
      1.925324,
      1,
      NULL,
      NULL,
      0.499897,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.101255,
      NULL,
      NULL,
      1,
      13,
      1.358825,
      31,
      0,
      1.478866,
      0,
      0,
      1.871848,
      0,
      1.493445,
      1,
      0,
      1.246980,
      0.569026,
      1,
      1,
      0.695430,
      NULL,
      NULL,
      1.938251,
      1,
      0.976256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.439671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.680608,
      0,
      0,
      3.126587,
      3.282987,
      4,
      14.048966,
      3,
      2.429856,
      1,
      1,
      NULL,
      NULL,
      1.093853,
      1,
      NULL,
      1.148861,
      1.891928,
      NULL,
      0.263168,
      1.940458,
      NULL,
      0.802723,
      1,
      NULL,
      NULL,
      1.587400,
      NULL,
      2,
      0.057061,
      NULL,
      1.426083,
      3.345822,
      NULL,
      1,
      NULL,
      NULL,
      1.049780,
      0.533159,
      NULL,
      1,
      1.945648,
      NULL,
      0.908025,
      1.602049,
      0.039646,
      NULL,
      NULL,
      2.503158,
      NULL,
      2.657071,
      NULL,
      0.613630,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.786861,
      NULL,
      1.722031,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      14.564840,
      1.222235,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.451448,
      4.305281,
      5.875377,
      0,
      NULL,
      NULL,
      50.213485,
      20.483323,
      4.666843,
      0,
      NULL,
      NULL,
      '',
      '',
      0.610346,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


