set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      NULL,
      3,
      0.425146,
      4,
      NULL,
      '1444',
      NULL,
      1,
      NULL,
      NULL,
      ' 7-19-1998',
      22,
      NULL,
      1.737705,
      3.623877,
      2.172393,
      NULL,
      NULL,
      0.104259,
      78.071255,
      NULL,
      1,
      ' 2-13-1984',
      '10-21-1991',
      NULL,
      1,
      1.147744,
      1,
      2,
      0,
      0,
      NULL,
      1,
      1,
      6.043433,
      NULL,
      NULL,
      4,
      7.321827,
      20.181826,
      4.572204,
      NULL,
      8,
      2,
      0,
      NULL,
      NULL,
      1.028797,
      3,
      2.130901,
      0,
      0.178911,
      0.140945,
      NULL,
      1.591381,
      0,
      3.254519,
      1.313397,
      1.248249,
      1,
      NULL,
      2.393260,
      0,
      1,
      1.938987,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.562140,
      1.804392,
      7.946396,
      NULL,
      1.744184,
      0,
      0.763757,
      1.800049,
      NULL,
      NULL,
      1.218497,
      NULL,
      NULL,
      0,
      NULL,
      1.933298,
      0.538299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.595764,
      1.192846,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.126124,
      0.071216,
      5,
      1.610349,
      1.163942,
      NULL,
      1,
      1,
      1,
      NULL,
      1.904015,
      0.857060,
      1,
      1.415746,
      NULL,
      NULL,
      1.455562,
      1,
      0,
      NULL,
      1.504548,
      1,
      0.277794,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.973087,
      0.922845,
      1,
      1,
      2.105260,
      0.422905,
      1.778516,
      NULL,
      1,
      1.029874,
      3,
      0.359488,
      NULL,
      6.811062,
      NULL,
      5,
      0,
      NULL,
      0,
      ' 7- 3-1998',
      101,
      NULL,
      NULL,
      3,
      1.716736,
      1.894191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1.308058,
      1,
      NULL,
      1.335818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      0.124341,
      0,
      NULL,
      0,
      0.327415,
      0,
      7.392530,
      6.937238,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.712812,
      0.587317,
      2.158314,
      NULL,
      4,
      1.924857,
      1.839331,
      NULL,
      NULL,
      NULL,
      1.923505,
      7.741897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.683777,
      1,
      1,
      0.794337,
      NULL,
      0,
      2,
      19.129480,
      0.950996,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      4.093569,
      1,
      3,
      1,
      NULL,
      5,
      1,
      3,
      3,
      4.270837,
      1,
      NULL,
      0,
      6.157652,
      1.516458,
      0,
      0,
      0,
      0.376312,
      1.821160,
      0,
      1.659818,
      1,
      0.636429,
      0.482348,
      1.995944,
      2,
      1.950943,
      0,
      5.798490,
      10.906469,
      1.822772,
      0,
      3.120983,
      5,
      2.341570,
      2.986837,
      6,
      3,
      2,
      2,
      40,
      2.074970,
      NULL,
      NULL,
      66.440533,
      NULL,
      NULL,
      2,
      0.499094,
      0,
      '34134',
      '20302',
      '44431',
      1,
      NULL,
      NULL,
      '',
      1,
      NULL,
      NULL,
      '',
      1,
      6.571431,
      NULL,
      22,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.950636,
      2,
      0.807280,
      NULL,
      0.381842,
      1,
      0.269306,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.203808,
      3,
      2.999439,
      0,
      NULL,
      NULL,
      1.229878,
      NULL,
      NULL,
      0.652283,
      NULL,
      NULL,
      1.451058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      4,
      NULL,
      1,
      1.429056,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.542326,
      NULL,
      NULL,
      1.121467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.412984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.344257,
      NULL,
      NULL,
      0,
      1.941702,
      1.277347,
      1,
      NULL,
      NULL,
      4,
      0,
      0,
      1,
      NULL,
      NULL,
      1.511095,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.934511,
      NULL,
      NULL,
      1.701781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.609729,
      NULL,
      NULL,
      1.240475,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.369721,
      NULL,
      NULL,
      1.135222,
      4.627151,
      1,
      0.792569,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.757133,
      0.087741,
      2.169046,
      NULL,
      0,
      3.846916,
      0,
      0,
      2.302599,
      0,
      0,
      0,
      NULL,
      3.472958,
      0.027042,
      0,
      NULL,
      2,
      0.134318,
      1.675698,
      7,
      1,
      NULL,
      0.989790,
      NULL,
      NULL,
      3,
      6.620490,
      1,
      NULL,
      NULL,
      0.658383,
      NULL,
      0.360679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.554490,
      NULL,
      0.838971,
      0.929108,
      1,
      0,
      0,
      NULL,
      NULL,
      3.485850,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.808257,
      NULL,
      NULL,
      NULL,
      0.167481,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.042330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.386011,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.971273,
      NULL,
      NULL,
      NULL,
      2.692701,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.035444,
      NULL,
      NULL,
      NULL,
      3.893264,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      17.090731,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.759052,
      0,
      1,
      0.964500,
      0.947480,
      1.936744,
      NULL,
      NULL,
      1.024519,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.763501,
      NULL,
      NULL,
      1.771639,
      NULL,
      NULL,
      0.819786,
      NULL,
      1,
      NULL,
      13.120703,
      0.257737,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      3,
      NULL,
      1.030853,
      NULL,
      2,
      0,
      NULL,
      1.200428,
      0.087898,
      0,
      0.448380,
      NULL,
      0.855285,
      NULL,
      2,
      NULL,
      1.227697,
      NULL,
      3,
      NULL,
      0.683213,
      NULL,
      229,
      NULL,
      1.446882,
      33.934826,
      NULL,
      1.941876,
      2,
      2,
      NULL,
      0.114251,
      NULL,
      1,
      NULL,
      0.651215,
      NULL,
      0.132774,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3.502863,
      NULL,
      1.546414,
      NULL,
      0.745629,
      NULL,
      1.191752,
      NULL,
      NULL,
      NULL,
      1.705592,
      NULL,
      NULL,
      NULL,
      1,
      1.293591,
      0.761902,
      2,
      NULL,
      NULL,
      NULL,
      1.222325,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.318120,
      NULL,
      0,
      1,
      0.358435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      35.092206,
      NULL,
      NULL,
      NULL,
      0.280981,
      NULL,
      1,
      NULL,
      0,
      0.552464,
      1.908465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.143096,
      NULL,
      NULL,
      0.822403,
      NULL,
      1.764442,
      NULL,
      NULL,
      NULL,
      1,
      0.667131,
      0,
      NULL,
      3.656745,
      NULL,
      NULL,
      NULL,
      517,
      NULL,
      0.018247,
      NULL,
      1.249952,
      NULL,
      1,
      0.196105,
      2,
      NULL,
      NULL,
      0.725937,
      0,
      0.995669,
      0,
      0,
      0.686101,
      NULL,
      1.328500,
      0,
      3,
      NULL,
      2.329069,
      7.000722,
      1,
      3.690930,
      0.837235,
      NULL,
      0,
      NULL,
      0,
      1.980542,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.044885,
      NULL,
      NULL,
      2,
      NULL,
      1.991248,
      NULL,
      NULL,
      NULL,
      0.139427,
      NULL,
      0.986795,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.779216,
      1,
      NULL,
      0.006371,
      1,
      NULL,
      0.393646,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.745270,
      NULL,
      1.692387,
      NULL,
      1,
      NULL,
      3,
      4.513588,
      5.679264,
      1,
      NULL,
      NULL,
      75,
      NULL,
      5,
      0.779967,
      NULL,
      '40102',
      '13044',
      '01321',
      1,
      '',
      '',
      NULL,
      3,
      '10244',
      '',
      '');
commit;
end;
/


