set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8115606';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      2.056903,
      2.770134,
      0.992599,
      0,
      3.397118,
      3,
      0.249780,
      '121',
      NULL,
      28,
      NULL,
      '3414033',
      2.535562,
      0,
      6,
      2,
      '0413',
      1.175295,
      0,
      NULL,
      NULL,
      '11- 0-1976',
      128,
      NULL,
      NULL,
      0,
      2.420443,
      ' 8-18-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      0.349490,
      NULL,
      ' 8- 7-1981',
      '11-22-1980',
      NULL,
      1,
      NULL,
      1.907993,
      0,
      NULL,
      NULL,
      NULL,
      1.708363,
      0,
      2.981041,
      2.946419,
      5.318919,
      NULL,
      NULL,
      NULL,
      NULL,
      6.251001,
      0,
      NULL,
      0.743294,
      NULL,
      0.946016,
      1.941142,
      1.706140,
      0.947785,
      1,
      2,
      NULL,
      1,
      1.235477,
      1.394791,
      1,
      3,
      2.131593,
      0,
      1,
      NULL,
      7.215378,
      NULL,
      NULL,
      4,
      1.991796,
      2.274804,
      NULL,
      1,
      1,
      0.340778,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      0.261807,
      NULL,
      NULL,
      3,
      3.390963,
      1.458963,
      1.788498,
      1.532903,
      1,
      0,
      0,
      1.435422,
      2.418036,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.153782,
      2,
      0,
      0,
      NULL,
      5.096215,
      NULL,
      3.567528,
      NULL,
      NULL,
      NULL,
      NULL,
      1.392710,
      NULL,
      NULL,
      0,
      0.504595,
      2,
      0,
      4,
      0,
      3.856750,
      0,
      1,
      1.454424,
      0.315097,
      1,
      0.550087,
      0,
      0,
      0,
      NULL,
      1.798541,
      0.883516,
      NULL,
      0,
      0,
      4.275357,
      0,
      3.800036,
      0.751872,
      NULL,
      0.783918,
      NULL,
      4,
      5,
      1,
      1.536277,
      NULL,
      2.722613,
      0.789686,
      2,
      NULL,
      5,
      4,
      0.860316,
      1,
      3,
      4,
      NULL,
      1,
      1,
      1,
      ' 7-24-1975',
      304.622750,
      ' 2-23-1990',
      25,
      NULL,
      1,
      1.595189,
      0.117321,
      1.416598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.383294,
      NULL,
      0.292309,
      3.991797,
      1.642103,
      1.798797,
      0.923071,
      1.208028,
      0.153764,
      0.149196,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.288722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.690339,
      0,
      1.229125,
      NULL,
      NULL,
      NULL,
      0.564108,
      NULL,
      5.655640,
      0.586877,
      0.857031,
      7,
      5.868591,
      1.996743,
      NULL,
      NULL,
      1.418638,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.009575,
      0,
      3,
      2.337732,
      2.010635,
      1.977027,
      NULL,
      NULL,
      NULL,
      1.037031,
      1,
      0.172352,
      2.982872,
      3.987532,
      2,
      0,
      1.868110,
      3,
      NULL,
      1,
      1.726482,
      3,
      1.265896,
      2.935355,
      3.423185,
      3.276395,
      0.077921,
      0.822178,
      NULL,
      1.031793,
      1,
      NULL,
      1,
      1.425111,
      NULL,
      0.931271,
      0,
      0.725098,
      NULL,
      3,
      NULL,
      NULL,
      6.223915,
      7.529590,
      0.441827,
      10,
      1,
      3.741659,
      2,
      4,
      3,
      NULL,
      3,
      NULL,
      1.859020,
      1.207612,
      57,
      NULL,
      27.783583,
      50.562625,
      2,
      NULL,
      NULL,
      '31024',
      '',
      '',
      1,
      '',
      '',
      '',
      4,
      NULL,
      '3043',
      '',
      0.026539,
      1,
      NULL,
      22,
      1.810362,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.157737,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.649775,
      1,
      0,
      1.745256,
      NULL,
      NULL,
      1.197622,
      NULL,
      NULL,
      2.171565,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.667309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.390026,
      NULL,
      NULL,
      1,
      1.926574,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.373274,
      NULL,
      1.222292,
      0.177924,
      NULL,
      NULL,
      1.512416,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.804342,
      NULL,
      0.128708,
      1,
      2.625976,
      0,
      0,
      0,
      3.785409,
      1.406041,
      3,
      0.717496,
      1.429290,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.833668,
      NULL,
      0,
      NULL,
      2.250520,
      0.684077,
      0,
      0.723333,
      NULL,
      NULL,
      NULL,
      1.553224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.595356,
      0,
      1.604791,
      0.380088,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.910101,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.161874,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.325088,
      1,
      NULL,
      2.438403,
      1.666431,
      1,
      1,
      1,
      1.093512,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      1,
      1,
      1,
      0.436057,
      1,
      NULL,
      NULL,
      1,
      0,
      3,
      3,
      1.048531,
      3,
      0.164514,
      1,
      2.203567,
      1.462394,
      2.930540,
      0,
      3,
      3,
      4,
      0.577363,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.589998,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.049441,
      NULL,
      NULL,
      1.005349,
      NULL,
      NULL,
      0.323032,
      NULL,
      NULL,
      0.451713,
      NULL,
      NULL,
      1.274496,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      2.481976,
      1,
      1.659710,
      1,
      NULL,
      0.077299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23,
      NULL,
      NULL,
      NULL,
      1.179943,
      NULL,
      NULL,
      NULL,
      2.748546,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.410178,
      NULL,
      NULL,
      NULL,
      0.754743,
      NULL,
      NULL,
      NULL,
      0.375870,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.843816,
      NULL,
      NULL,
      NULL,
      1.207974,
      NULL,
      NULL,
      NULL,
      1.536682,
      NULL,
      NULL,
      NULL,
      2.718787,
      NULL,
      NULL,
      NULL,
      0.677565,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.210292,
      NULL,
      NULL,
      NULL,
      1.658215,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.114117,
      NULL,
      NULL,
      NULL,
      3,
      3.593902,
      1,
      0.998914,
      10,
      0.430508,
      0,
      NULL,
      NULL,
      1.367567,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.226657,
      NULL,
      8,
      0,
      NULL,
      0,
      1.098014,
      NULL,
      0.018832,
      0.942398,
      NULL,
      0.349751,
      NULL,
      1,
      1,
      1.551439,
      0.669083,
      1.814744,
      1.322447,
      1,
      1.014830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.318853,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.608106,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.637460,
      1.659601,
      1.387515,
      1,
      0.384546,
      NULL,
      NULL,
      1.916488,
      NULL,
      0.867859,
      1.756361,
      1.997957,
      0,
      NULL,
      0.186765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      4,
      9.687392,
      0,
      NULL,
      20,
      3,
      1.898770,
      NULL,
      0.787980,
      2,
      NULL,
      2,
      NULL,
      NULL,
      2.236217,
      2.600446,
      NULL,
      0,
      0,
      NULL,
      3.306508,
      1.302195,
      NULL,
      1.967256,
      1.235498,
      NULL,
      2,
      0,
      NULL,
      1.906381,
      NULL,
      NULL,
      1,
      1.435693,
      NULL,
      1.559844,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.319584,
      1.379275,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.635138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      4,
      NULL,
      NULL,
      2.275155,
      0.343887,
      0.105397,
      52.323800,
      81,
      2.971681,
      NULL,
      1,
      NULL,
      NULL,
      '',
      0.011751,
      '',
      '',
      NULL,
      5,
      '41233',
      '4043',
      '');
commit;
end;
/


