set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5613373';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-2-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '2144030',
      NULL,
      1,
      1,
      1,
      '4414',
      0,
      0.161539,
      NULL,
      NULL,
      ' 0- 1-2000',
      1,
      NULL,
      1.232763,
      3,
      0,
      ' 3- 8-1993',
      2.862443,
      0.016010,
      7.055697,
      120.421734,
      3.116852,
      ' 8- 6-1997',
      ' 8-20-1983',
      ' 5- 7-1990',
      2.035062,
      0.033652,
      2.029964,
      2.380887,
      0.148449,
      3,
      3.502242,
      0,
      1,
      16,
      7.107278,
      19.665588,
      0,
      21.186614,
      8,
      1.218724,
      12,
      4.693358,
      NULL,
      3,
      1.577173,
      1.949988,
      0,
      1,
      1.801757,
      1,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      7,
      1,
      2,
      2,
      0,
      0.893149,
      6,
      1.839039,
      1.942721,
      1.859211,
      0,
      0,
      9,
      NULL,
      4.818806,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      5.488934,
      1,
      1,
      0.860864,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1.264059,
      3.207870,
      5.983795,
      1,
      2.860812,
      1,
      1,
      1.049510,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      5.453571,
      0.385871,
      4,
      5,
      NULL,
      4.159324,
      8.754619,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.781924,
      1,
      5.813343,
      2.976359,
      4,
      1.800443,
      2.572685,
      0.560182,
      1,
      NULL,
      3,
      0,
      1.161677,
      2,
      8.110035,
      1,
      7,
      1.110193,
      9.523294,
      2.197656,
      NULL,
      NULL,
      6.529551,
      1,
      4,
      2,
      2.870191,
      3,
      NULL,
      291.764020,
      ' 1- 9-2000',
      11.872296,
      1.015155,
      0.567201,
      3,
      1.532541,
      1,
      NULL,
      3,
      0.078228,
      1.240857,
      2.753428,
      9.541083,
      6,
      1.595686,
      1.088714,
      1.039872,
      4,
      NULL,
      NULL,
      2.242254,
      2.215234,
      3.283231,
      NULL,
      2,
      ' 9- 2-1987',
      4,
      NULL,
      2.460696,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.281971,
      0,
      NULL,
      NULL,
      NULL,
      2.527518,
      1,
      NULL,
      NULL,
      0,
      3.387323,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.820633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      0,
      0,
      1,
      1.584897,
      1.213021,
      198.092826,
      0,
      1.860235,
      64,
      3.210207,
      7.100223,
      0.846997,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.247020,
      2.624829,
      3,
      5,
      2.087331,
      NULL,
      1.762934,
      5,
      1.732165,
      NULL,
      0.414540,
      NULL,
      NULL,
      1.745182,
      1.577976,
      1,
      0,
      0,
      0.769460,
      0.211845,
      NULL,
      0.471399,
      3.441202,
      0,
      11,
      6,
      NULL,
      7.960687,
      7,
      6.669941,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3.183169,
      2.079811,
      NULL,
      17.836142,
      40,
      NULL,
      0,
      0,
      4.366139,
      '10024',
      '04423',
      '',
      1.717852,
      '',
      '',
      '',
      1.963954,
      '',
      NULL,
      '',
      0.101152,
      33.756443,
      166,
      48,
      2,
      2,
      15.046599,
      NULL,
      1,
      NULL,
      2,
      3,
      1.504864,
      NULL,
      NULL,
      1.659035,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.025184,
      1.634118,
      1.215869,
      3.364681,
      2.238745,
      0,
      0.509342,
      NULL,
      NULL,
      0,
      0.005948,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.284192,
      NULL,
      NULL,
      NULL,
      2.270809,
      5.155277,
      3,
      2,
      0,
      1,
      1.206485,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.891528,
      1.831258,
      1.253332,
      NULL,
      NULL,
      1.558638,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.625697,
      NULL,
      NULL,
      1.863240,
      NULL,
      NULL,
      1,
      1,
      NULL,
      4,
      0,
      1.025775,
      NULL,
      1,
      0.003662,
      0,
      0.181241,
      0.508607,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0.120406,
      2,
      3,
      NULL,
      0,
      1.789794,
      1,
      1,
      0.200805,
      2,
      5,
      NULL,
      2,
      1.508953,
      NULL,
      2.549265,
      0,
      0,
      2,
      1.394624,
      2.540426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.876966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.279598,
      5,
      0,
      1.341914,
      1,
      NULL,
      NULL,
      2.525952,
      NULL,
      2,
      0,
      NULL,
      NULL,
      2.850133,
      1.146012,
      0.151336,
      0.973732,
      NULL,
      NULL,
      5,
      0.557143,
      1,
      2,
      0.021511,
      0.087219,
      1,
      NULL,
      NULL,
      3,
      1.689416,
      3,
      1.363122,
      1.492778,
      3.030696,
      7,
      0.017684,
      NULL,
      2.568221,
      0,
      4,
      1.168176,
      3.863986,
      2.181865,
      NULL,
      NULL,
      1.381334,
      1.701628,
      3,
      1.656433,
      NULL,
      7,
      7,
      NULL,
      23,
      NULL,
      NULL,
      0,
      1.904699,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.708797,
      0,
      NULL,
      1.923585,
      3,
      NULL,
      3,
      0,
      NULL,
      NULL,
      3.773591,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.884338,
      NULL,
      NULL,
      3.163401,
      1.167102,
      NULL,
      6.674964,
      0.283400,
      NULL,
      2.978192,
      1.326889,
      1.552093,
      0.550203,
      1.948657,
      1,
      3.773954,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.151835,
      1.091916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.224864,
      0.840450,
      NULL,
      NULL,
      0.535426,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.567978,
      3.580782,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      1.296945,
      NULL,
      NULL,
      1.973819,
      1,
      NULL,
      NULL,
      0.925864,
      0.650452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.547967,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      0.945978,
      NULL,
      NULL,
      NULL,
      3,
      20.194653,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.209189,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      167.840788,
      7.254970,
      0.862657,
      2.219713,
      1.505610,
      1.456338,
      NULL,
      2.518812,
      1.362005,
      0,
      3.186621,
      2.853574,
      3,
      0.723040,
      1,
      NULL,
      2,
      NULL,
      0,
      1,
      NULL,
      1,
      1.509943,
      NULL,
      NULL,
      NULL,
      3.862509,
      3,
      3,
      3,
      0,
      271.794543,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.178086,
      1.218013,
      1.543723,
      0,
      1,
      0,
      0.050230,
      1.276598,
      NULL,
      3.361891,
      0,
      1,
      1.430870,
      NULL,
      0,
      0.045189,
      NULL,
      1,
      NULL,
      NULL,
      2.198898,
      0.879666,
      1,
      1,
      1.032914,
      1,
      1.454808,
      1.958186,
      NULL,
      0.806474,
      0.625467,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      77,
      NULL,
      0.954899,
      NULL,
      1.254856,
      NULL,
      0.001340,
      NULL,
      0,
      0.098640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.240782,
      NULL,
      1.193740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.932982,
      NULL,
      0.197579,
      NULL,
      0,
      NULL,
      NULL,
      1.103695,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.719884,
      3.550566,
      NULL,
      NULL,
      NULL,
      1.819869,
      NULL,
      205,
      NULL,
      NULL,
      NULL,
      1.034233,
      NULL,
      0.897324,
      1,
      1.807810,
      2,
      14,
      1.473361,
      NULL,
      NULL,
      NULL,
      0.390799,
      1.695241,
      1,
      0.436461,
      0,
      2,
      1,
      0,
      2,
      3,
      0.825292,
      0.868258,
      NULL,
      3,
      3.577384,
      0.969769,
      3,
      2,
      1,
      3,
      NULL,
      1.123742,
      2.933536,
      3.531094,
      0.604772,
      NULL,
      1.883658,
      1.403899,
      1.255562,
      NULL,
      0.962630,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      2,
      2.110207,
      0.639221,
      NULL,
      0.265609,
      NULL,
      1.042563,
      0.729670,
      1,
      3,
      1,
      1.298838,
      3.102526,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.817532,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.921543,
      NULL,
      0,
      NULL,
      1.248158,
      42.444585,
      3.864785,
      NULL,
      1.055532,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.767245,
      1,
      0,
      1,
      0.310275,
      4.397987,
      11,
      5,
      2,
      NULL,
      3,
      NULL,
      16,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11024',
      0.070249,
      NULL,
      '',
      NULL,
      0,
      '',
      NULL,
      NULL);
commit;
end;
/


