set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726236';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-7-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      3,
      1.917832,
      0,
      NULL,
      NULL,
      2.991839,
      1.358631,
      NULL,
      NULL,
      ' 6-25-1975',
      1.853501,
      NULL,
      2.300929,
      1,
      0.248757,
      '10-10-1996',
      103,
      2.734633,
      197,
      133,
      NULL,
      NULL,
      NULL,
      NULL,
      1.525133,
      3,
      1,
      1,
      0,
      1,
      3.704697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      8.177296,
      1.361284,
      25,
      1.993220,
      1,
      9,
      0,
      NULL,
      2,
      0.233290,
      0,
      1.678878,
      NULL,
      0.790904,
      0.354370,
      0.605956,
      1.970006,
      5.282955,
      3.720172,
      NULL,
      NULL,
      6.468569,
      1,
      0,
      4,
      0.188090,
      0.477245,
      5,
      1.089858,
      1.053686,
      0,
      8,
      1.201059,
      4.780445,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.061156,
      NULL,
      NULL,
      NULL,
      0.102694,
      NULL,
      1,
      0,
      1.720342,
      2,
      1.367670,
      1,
      1,
      1,
      0.523450,
      3,
      1,
      NULL,
      1.307859,
      1.155810,
      1.055177,
      0.799277,
      0.505608,
      4.007779,
      3.259883,
      NULL,
      0,
      3.980450,
      0,
      0.737285,
      NULL,
      NULL,
      0.112392,
      NULL,
      NULL,
      0,
      NULL,
      2.215556,
      0,
      6.816840,
      NULL,
      NULL,
      0,
      1.016593,
      1,
      4,
      0,
      0.622782,
      1,
      1,
      NULL,
      1,
      0.462829,
      NULL,
      NULL,
      0,
      1,
      0.653297,
      1,
      NULL,
      NULL,
      1.663763,
      NULL,
      0,
      0,
      0.936382,
      NULL,
      0.810243,
      0,
      NULL,
      1,
      NULL,
      0.596891,
      NULL,
      0,
      2.299222,
      4,
      6,
      0.638703,
      0,
      4,
      7.763096,
      NULL,
      ' 0-26-1990',
      NULL,
      ' 8-17-1995',
      1,
      NULL,
      NULL,
      NULL,
      3.296445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      5,
      NULL,
      1,
      4.155401,
      0.220786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.225512,
      1,
      1,
      0.762043,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      2,
      15,
      0.763328,
      0.734223,
      NULL,
      NULL,
      NULL,
      0,
      1.670198,
      NULL,
      0.685031,
      2.286640,
      1,
      NULL,
      1.581096,
      3.653034,
      1,
      0,
      NULL,
      NULL,
      0.774993,
      0.092246,
      NULL,
      5,
      3,
      NULL,
      1.576532,
      0.397242,
      1,
      1.110493,
      1.452514,
      NULL,
      1,
      0,
      1.402441,
      NULL,
      0.968322,
      5.763166,
      0.624803,
      1,
      8.337713,
      4.266853,
      NULL,
      9.959486,
      NULL,
      NULL,
      1.654094,
      4.378940,
      3,
      0.418939,
      2.343946,
      NULL,
      2.010207,
      3.266828,
      NULL,
      7.626140,
      35.136918,
      42,
      3,
      5,
      0.682873,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      79.798667,
      31,
      NULL,
      0.047414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.987092,
      0.912408,
      2.174710,
      3.758595,
      0.852557,
      1,
      NULL,
      NULL,
      0.835559,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.962152,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.432007,
      NULL,
      NULL,
      0.283413,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.272060,
      5,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.952742,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.160423,
      NULL,
      NULL,
      0.995462,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.618120,
      NULL,
      NULL,
      0.921426,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.767811,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.245038,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.422700,
      NULL,
      NULL,
      0.931296,
      NULL,
      NULL,
      1.734509,
      NULL,
      NULL,
      0.333847,
      NULL,
      NULL,
      1.777983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.438464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.439251,
      NULL,
      NULL,
      1.076683,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.391809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.837027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.596273,
      0,
      0.856334,
      1.819230,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.412380,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.348723,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.320298,
      NULL,
      0.409439,
      0,
      3.269192,
      0,
      NULL,
      NULL,
      1.420674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.892960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.759775,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.102248,
      NULL,
      NULL,
      NULL,
      0.883900,
      NULL,
      NULL,
      NULL,
      0.581331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.244452,
      0.790378,
      NULL,
      1.594473,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.684582,
      NULL,
      NULL,
      0,
      NULL,
      1.124065,
      15,
      0,
      0.386757,
      3.247397,
      0,
      1,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.327826,
      1,
      NULL,
      1,
      0,
      1.666621,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.059096,
      NULL,
      NULL,
      NULL,
      7.202486,
      NULL,
      1.523881,
      NULL,
      53,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.164865,
      NULL,
      1.591124,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.586558,
      NULL,
      0.174941,
      NULL,
      0.741360,
      NULL,
      0.613664,
      NULL,
      1.444989,
      NULL,
      1.283984,
      NULL,
      1,
      NULL,
      1.689791,
      NULL,
      1.077491,
      0.690710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      2.082221,
      9,
      0,
      NULL,
      2,
      NULL,
      NULL,
      2.271414,
      2,
      0.655419,
      0.812908,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.858301,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.672072,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.431238,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.071029,
      NULL,
      NULL,
      NULL,
      1.602578,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.146490,
      4.415463,
      2.832512,
      0.719927,
      '40032',
      '43224',
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      '',
      NULL,
      '');
commit;
end;
/


