set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9512010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-4-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '2410033',
      NULL,
      0,
      2,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      ' 5- 8-1996',
      54,
      NULL,
      NULL,
      NULL,
      2.716163,
      ' 4- 0-1991',
      5,
      5.253729,
      NULL,
      25.205982,
      3.884422,
      ' 4- 2-2003',
      NULL,
      ' 4-25-2001',
      1,
      1,
      0.794214,
      0,
      NULL,
      1,
      3,
      NULL,
      0.852200,
      5,
      1,
      6,
      NULL,
      21.564714,
      14,
      3,
      12.400075,
      2.779592,
      2.491784,
      5,
      0.400789,
      1,
      0,
      NULL,
      1,
      NULL,
      1.871919,
      2,
      1,
      2,
      0.802759,
      2.212820,
      0.294760,
      1,
      2,
      3.990308,
      NULL,
      NULL,
      4,
      0,
      0.926646,
      2,
      0,
      4,
      NULL,
      NULL,
      2,
      3.501440,
      1.823291,
      5.301429,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      0,
      1,
      2.687734,
      3,
      1.929157,
      3.572681,
      1,
      1,
      2.914519,
      NULL,
      2,
      3,
      NULL,
      NULL,
      2,
      7,
      3.202193,
      9,
      0.303759,
      NULL,
      0,
      0.671625,
      NULL,
      NULL,
      0.725408,
      NULL,
      NULL,
      1.272586,
      1,
      6.248611,
      0.597503,
      4,
      6.882144,
      0,
      0,
      4.177513,
      0.191105,
      7.990065,
      3.930471,
      0,
      5.937708,
      NULL,
      NULL,
      NULL,
      0.550154,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.125555,
      1.349044,
      0,
      3,
      1.475772,
      1,
      1,
      4.437674,
      0,
      1.317770,
      5,
      0.193644,
      0.407573,
      2,
      0,
      3.309084,
      3,
      1,
      4,
      NULL,
      3.335585,
      4.643846,
      1,
      0,
      2.947801,
      NULL,
      18.822067,
      ' 5-27-1977',
      5,
      2,
      0,
      2.304183,
      3.113638,
      1.508413,
      NULL,
      NULL,
      1.386133,
      1.220835,
      0.376794,
      1,
      NULL,
      4.373864,
      5.043230,
      0,
      NULL,
      3.137471,
      2.445697,
      NULL,
      0.802647,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.266724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.924860,
      0.824859,
      3.718773,
      1.970787,
      1,
      0,
      1,
      NULL,
      1,
      1,
      3,
      5.533890,
      0.569124,
      NULL,
      NULL,
      3.349075,
      0.675591,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.536946,
      0.986719,
      1,
      0.583996,
      0,
      1.589696,
      0,
      1,
      21.148408,
      0.821471,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.578052,
      2.364130,
      2,
      NULL,
      NULL,
      3.136152,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      4,
      3,
      1.999483,
      0,
      1,
      1,
      0,
      0,
      1,
      1.173406,
      0,
      0,
      0,
      1,
      0,
      0.152073,
      NULL,
      0.543895,
      NULL,
      1.435747,
      5.618047,
      2.460972,
      5.940080,
      NULL,
      1,
      0,
      6,
      1,
      NULL,
      3.541887,
      46,
      NULL,
      1,
      NULL,
      35,
      11,
      18,
      0,
      4,
      5.309348,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0.056152,
      '',
      '',
      '',
      NULL,
      37.273359,
      69.420520,
      6.588701,
      0.152017,
      20,
      2.258367,
      3.492666,
      0,
      0.001020,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.999999,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.886107,
      0.796524,
      2,
      0.999044,
      2,
      0.148909,
      2.748852,
      3.603434,
      0.940936,
      NULL,
      2.044293,
      1.233234,
      1,
      3,
      NULL,
      1.362528,
      1.954994,
      1,
      0.677976,
      5.008338,
      0,
      2.370907,
      2.033371,
      1,
      3,
      NULL,
      0.892165,
      NULL,
      NULL,
      NULL,
      NULL,
      1.215018,
      3,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.226013,
      1.552543,
      3.456565,
      3,
      0,
      0,
      NULL,
      0,
      NULL,
      0.348795,
      NULL,
      0.445246,
      1,
      1.238476,
      NULL,
      0,
      2.391915,
      1.685540,
      1.951628,
      NULL,
      NULL,
      0.771082,
      2.385206,
      0.045105,
      3,
      9.492395,
      1,
      NULL,
      1.452279,
      NULL,
      NULL,
      1.172483,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.911125,
      2.071341,
      3.030008,
      0.587409,
      NULL,
      NULL,
      3.338296,
      2.921703,
      1.299600,
      NULL,
      3.081736,
      0,
      1,
      3,
      2.642514,
      NULL,
      4.019391,
      4.375237,
      0.704819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.881171,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2.856169,
      0,
      4,
      NULL,
      1,
      0.198651,
      1.039638,
      1,
      3.120914,
      0,
      2.336323,
      4.091913,
      3.361314,
      2,
      4,
      1.444240,
      1.434193,
      5,
      4.847001,
      0.058871,
      3,
      1,
      0,
      0.590243,
      0.835906,
      NULL,
      3,
      3.900524,
      1.545230,
      1,
      5,
      3.470867,
      1,
      NULL,
      NULL,
      1.839552,
      NULL,
      NULL,
      2,
      1.490325,
      NULL,
      3.270800,
      2,
      NULL,
      4.752387,
      6.928460,
      3.621462,
      5,
      3.727320,
      1.981259,
      2.859043,
      2,
      1,
      0.587569,
      1,
      2,
      0,
      1.695937,
      3.278901,
      NULL,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.636307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.649719,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.991985,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      0.177488,
      NULL,
      NULL,
      3,
      1.847805,
      NULL,
      2,
      NULL,
      NULL,
      2,
      1,
      NULL,
      7,
      2.653015,
      NULL,
      0.241533,
      0.966695,
      NULL,
      3.645370,
      0,
      0.676811,
      3,
      0,
      NULL,
      NULL,
      5.918099,
      NULL,
      NULL,
      NULL,
      1.987646,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.973164,
      NULL,
      NULL,
      NULL,
      0.048989,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.685801,
      0.695729,
      NULL,
      NULL,
      0.632415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0.250114,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.766791,
      1,
      NULL,
      NULL,
      0,
      0.135107,
      NULL,
      NULL,
      0.625094,
      1.235987,
      NULL,
      NULL,
      3.162613,
      1,
      NULL,
      NULL,
      1.597139,
      0,
      NULL,
      NULL,
      14.453036,
      1.384418,
      NULL,
      NULL,
      NULL,
      0.327895,
      4,
      1.919320,
      3,
      6,
      2.689122,
      3,
      0.806492,
      1.136798,
      1.789176,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.489398,
      1,
      0.151990,
      1,
      NULL,
      NULL,
      1.919932,
      NULL,
      0.254631,
      0,
      10,
      2.818554,
      NULL,
      0,
      NULL,
      0.360371,
      1,
      NULL,
      NULL,
      1,
      0.947484,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.955323,
      0,
      0,
      1,
      NULL,
      0.243438,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2.011988,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      23.779940,
      NULL,
      NULL,
      1.164715,
      1.960463,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.991034,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.153562,
      NULL,
      0.960288,
      NULL,
      NULL,
      NULL,
      0.062054,
      NULL,
      1.848812,
      0,
      0.595136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.484614,
      NULL,
      0.821724,
      NULL,
      816,
      NULL,
      2.792129,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.648839,
      NULL,
      2.188725,
      NULL,
      1.238048,
      NULL,
      1,
      NULL,
      114,
      NULL,
      0,
      NULL,
      1.167893,
      NULL,
      0.457380,
      NULL,
      1.373278,
      NULL,
      0.148316,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.750809,
      NULL,
      0.591277,
      NULL,
      14.379504,
      NULL,
      NULL,
      NULL,
      2,
      1.036130,
      0,
      NULL,
      3.341456,
      NULL,
      770,
      NULL,
      0.246650,
      NULL,
      NULL,
      NULL,
      1.043483,
      NULL,
      3.060727,
      0,
      12.280739,
      NULL,
      3,
      1.682880,
      NULL,
      NULL,
      1,
      NULL,
      0.806709,
      1,
      NULL,
      0,
      NULL,
      0.821059,
      1.599929,
      NULL,
      NULL,
      2,
      1.547490,
      0,
      0,
      1.088320,
      NULL,
      2.943908,
      NULL,
      1,
      2,
      1,
      0.630735,
      1,
      1,
      0,
      NULL,
      1,
      1,
      0.918842,
      NULL,
      1,
      1,
      NULL,
      0,
      3.107282,
      1,
      1.821567,
      0.180120,
      1,
      1,
      NULL,
      1,
      1.140675,
      1,
      2.787187,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.468765,
      0,
      1.268255,
      0,
      1,
      1,
      NULL,
      5.584102,
      3,
      2.995442,
      2.228496,
      NULL,
      87.893797,
      0.719007,
      NULL,
      3,
      NULL,
      '02204',
      NULL,
      '01401',
      1,
      '',
      '',
      '',
      0.325808,
      '',
      NULL,
      '');
commit;
end;
/


