set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9512010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-12-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '4', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      NULL,
      3,
      7,
      9,
      NULL,
      NULL,
      3.863428,
      '040',
      '30013304',
      42.625295,
      42,
      NULL,
      4,
      NULL,
      3,
      0,
      NULL,
      4.381141,
      1.176528,
      NULL,
      NULL,
      ' 8-28-2002',
      51,
      24.385765,
      NULL,
      1,
      1,
      ' 7- 9-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 9-1982',
      NULL,
      ' 3-19-1992',
      NULL,
      1.041997,
      3,
      NULL,
      3,
      NULL,
      2,
      1.888825,
      1,
      2,
      11.538773,
      11.770553,
      5.704480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.073055,
      3,
      0,
      1.042965,
      NULL,
      1,
      1.174334,
      1,
      0.826824,
      0,
      0,
      3,
      1,
      4,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.100636,
      1.819113,
      0,
      0.207659,
      NULL,
      0.609436,
      1.153246,
      3.922704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.537063,
      1.697291,
      1.480829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.009444,
      1.481477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.290026,
      4,
      NULL,
      1.429062,
      4,
      NULL,
      3.284190,
      1,
      NULL,
      1,
      0.834876,
      1.674966,
      NULL,
      3,
      1,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0.033440,
      3.364452,
      0,
      0,
      2,
      1,
      NULL,
      0.521571,
      1.947687,
      1.362021,
      1.632249,
      1.167341,
      NULL,
      0,
      1.736284,
      3,
      11,
      0,
      NULL,
      5.367728,
      9.743887,
      5.877476,
      3.368133,
      7.671476,
      3,
      5,
      5,
      0.114235,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.184511,
      1,
      0,
      NULL,
      1.269564,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.774674,
      0,
      0,
      1.085356,
      0,
      1.805036,
      NULL,
      NULL,
      NULL,
      1.636163,
      0,
      0.796288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1.004974,
      NULL,
      NULL,
      NULL,
      2,
      1.507431,
      NULL,
      3.260178,
      NULL,
      3.912447,
      1,
      NULL,
      NULL,
      0.613767,
      3.733492,
      0,
      2.303451,
      NULL,
      3.826019,
      0.260702,
      3.262006,
      1.328555,
      NULL,
      NULL,
      0,
      0,
      0,
      0.510447,
      0.522756,
      0,
      1,
      1,
      1.191338,
      0.508312,
      2.530100,
      1.905624,
      3,
      NULL,
      1,
      5.293474,
      0,
      0.997075,
      0.324670,
      2,
      3,
      1,
      NULL,
      NULL,
      10,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      3,
      '43124',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      2.181376,
      80.756598,
      25.800988,
      2,
      23,
      2,
      8.950273,
      NULL,
      3,
      1.037831,
      2,
      0,
      NULL,
      NULL,
      0.356747,
      NULL,
      NULL,
      1.780324,
      3.835496,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      3.615278,
      1.741505,
      0.835157,
      1,
      3.409818,
      2.558654,
      NULL,
      2,
      NULL,
      0.095373,
      NULL,
      3,
      2.051183,
      0.336853,
      0,
      8.362687,
      5,
      NULL,
      0.920448,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      0,
      2,
      0,
      0,
      0.987022,
      0,
      1,
      3,
      2.887491,
      3.161149,
      1,
      3.823445,
      NULL,
      1,
      1.010897,
      2,
      2.595305,
      3,
      1.554330,
      0,
      0,
      0.428181,
      0.481806,
      0,
      1,
      2.300733,
      0.521190,
      3.749578,
      NULL,
      NULL,
      7.136413,
      NULL,
      3.966945,
      1,
      NULL,
      NULL,
      NULL,
      1.560482,
      NULL,
      NULL,
      NULL,
      0.408732,
      NULL,
      NULL,
      2.926521,
      NULL,
      1,
      2,
      2,
      0.966894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.771214,
      NULL,
      0.105898,
      NULL,
      0,
      3,
      1.235004,
      5.251984,
      2.659154,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.507748,
      NULL,
      NULL,
      3,
      0,
      1,
      3,
      2,
      NULL,
      1,
      1.993038,
      0,
      NULL,
      2,
      0,
      2.204396,
      3,
      0.927913,
      1.962424,
      1.026685,
      3.698314,
      2.970193,
      NULL,
      0.983246,
      NULL,
      1.850094,
      0,
      2.567733,
      0,
      1.753170,
      3,
      3,
      3,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      2,
      1,
      1.023109,
      NULL,
      0.976466,
      2,
      2.898807,
      3,
      0,
      5,
      6.179547,
      5.067789,
      2.717463,
      7.829324,
      NULL,
      3.545538,
      5,
      7,
      1,
      3,
      3.230272,
      NULL,
      2.620226,
      1,
      NULL,
      3.644702,
      4,
      NULL,
      NULL,
      50.414469,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.061677,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.927330,
      NULL,
      1.405099,
      1,
      NULL,
      0.066413,
      0,
      NULL,
      0.134789,
      1.159940,
      NULL,
      1.091804,
      NULL,
      NULL,
      1,
      0.535933,
      NULL,
      2,
      0.104054,
      NULL,
      NULL,
      2.663041,
      NULL,
      7.712899,
      5.363624,
      NULL,
      NULL,
      1.412571,
      0.111730,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      22.913893,
      NULL,
      NULL,
      NULL,
      NULL,
      2.933140,
      NULL,
      NULL,
      0.633785,
      1.926111,
      NULL,
      NULL,
      0.758104,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.222482,
      3.998532,
      NULL,
      NULL,
      0.431209,
      0.819760,
      NULL,
      NULL,
      1.007071,
      0,
      NULL,
      NULL,
      0.614023,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.680976,
      1.931249,
      NULL,
      NULL,
      0.755130,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.977674,
      NULL,
      NULL,
      0.576660,
      1,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.184384,
      5.709844,
      0.871730,
      NULL,
      2.595177,
      NULL,
      0.516706,
      2.674075,
      1,
      NULL,
      NULL,
      1.239368,
      NULL,
      NULL,
      0.525600,
      4.904172,
      0.163764,
      0.051505,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      114,
      14.265756,
      NULL,
      NULL,
      1.989265,
      2,
      0,
      1.354682,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      0.846168,
      1.293574,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      119,
      NULL,
      2.054664,
      25.889681,
      12.980740,
      2.260987,
      NULL,
      11,
      NULL,
      0.745867,
      NULL,
      1.374591,
      NULL,
      0.391644,
      NULL,
      NULL,
      NULL,
      1.263346,
      NULL,
      0.818239,
      NULL,
      0.160530,
      NULL,
      0,
      NULL,
      0.536397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.335113,
      NULL,
      0.114025,
      1,
      0.096139,
      0.689405,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.110773,
      NULL,
      1,
      NULL,
      1.674166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.833539,
      2,
      NULL,
      3,
      NULL,
      10.743454,
      313,
      2,
      0.880869,
      0,
      0.668477,
      0,
      0.777188,
      0.073332,
      NULL,
      NULL,
      NULL,
      1.677626,
      3.376975,
      NULL,
      1,
      37.502519,
      335.548716,
      0.698476,
      NULL,
      1,
      1,
      NULL,
      1,
      0.413997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.618424,
      1,
      2,
      1,
      0.762557,
      NULL,
      NULL,
      1.003642,
      1,
      0,
      3,
      3,
      3.561085,
      0.571913,
      0.986966,
      NULL,
      707,
      2,
      0,
      1,
      1.275775,
      0,
      1,
      3,
      1.372712,
      16.199967,
      NULL,
      NULL,
      NULL,
      3.363326,
      9.949358,
      0.564187,
      0.722355,
      0,
      1.597291,
      1,
      NULL,
      3.919301,
      0.096952,
      0.468013,
      1,
      1,
      3,
      0,
      0.241709,
      1,
      0.534277,
      0,
      3.547901,
      1,
      1.624231,
      1.358285,
      NULL,
      1,
      1,
      NULL,
      1.852695,
      1.891718,
      1.987871,
      0.383947,
      2,
      0,
      0.680750,
      1.850523,
      1.242219,
      0.688495,
      1.616490,
      1,
      1.377855,
      3.352994,
      NULL,
      0.756845,
      NULL,
      0.808705,
      NULL,
      3.636514,
      2.357621,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.084428,
      1,
      1,
      1.153855,
      0.615061,
      NULL,
      7,
      7,
      4,
      0,
      NULL,
      NULL,
      75,
      9.779380,
      3.319964,
      1.413305,
      2,
      '41444',
      '11043',
      '',
      0,
      NULL,
      '',
      '',
      0.635079,
      '',
      '',
      '');
commit;
end;
/


