set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9503953';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-1-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      2,
      1,
      0.744499,
      1.031474,
      1.855150,
      2.842147,
      2,
      '431',
      '00411224',
      6,
      30,
      '0342342',
      NULL,
      1,
      2,
      1,
      '4401',
      1.751294,
      0,
      NULL,
      NULL,
      ' 2-12-1989',
      122.578505,
      104.566674,
      NULL,
      3,
      0,
      ' 2-29-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      ' 6-28-1992',
      ' 4- 0-1998',
      NULL,
      NULL,
      1.197922,
      0,
      0,
      0,
      0.368199,
      1.183446,
      0.065596,
      NULL,
      NULL,
      1.322842,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.347146,
      0,
      NULL,
      1,
      1,
      1.494126,
      0,
      1,
      0,
      1.145095,
      22,
      5,
      NULL,
      2.372684,
      0,
      5.030310,
      NULL,
      1,
      2.632295,
      0.431928,
      1,
      NULL,
      1.235233,
      1,
      1.077685,
      0,
      0,
      7,
      1.928458,
      1,
      0,
      1,
      1.305012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.684076,
      2.649973,
      1,
      0,
      0.842052,
      2,
      3.531724,
      2,
      1,
      0.647339,
      0,
      0,
      1,
      2,
      NULL,
      0,
      0.485829,
      0,
      3,
      NULL,
      1,
      4.428906,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.802840,
      NULL,
      NULL,
      1,
      2,
      1.865279,
      NULL,
      4.726147,
      0.473170,
      0,
      1.157987,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.140276,
      1,
      1,
      NULL,
      0.211482,
      1.929951,
      0,
      0.339380,
      1.017418,
      1,
      1,
      0,
      0,
      0.469338,
      3.810439,
      NULL,
      0.882551,
      3.639411,
      1,
      3,
      NULL,
      NULL,
      1,
      7,
      6.592813,
      6,
      6,
      3.725674,
      2.929217,
      3.644672,
      3.842707,
      2,
      NULL,
      1194.134645,
      '10-29-1987',
      282.221534,
      0,
      1,
      0.817119,
      2,
      1.194012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.995386,
      0,
      1,
      0,
      NULL,
      0,
      0,
      1.565636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.863453,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3.556960,
      1,
      2.151555,
      1.083578,
      0.721268,
      1,
      0,
      0.542224,
      1,
      0.693916,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0,
      NULL,
      1,
      0.680991,
      NULL,
      38,
      NULL,
      1.428375,
      4,
      65,
      13.164846,
      4.655604,
      1,
      NULL,
      4,
      3.692939,
      NULL,
      3.914604,
      1.420046,
      3,
      0,
      4.465778,
      3,
      NULL,
      3.254671,
      0,
      1,
      0.081003,
      0.058346,
      1,
      0.871864,
      1.054223,
      0.384942,
      1,
      1,
      1.661779,
      NULL,
      0,
      0,
      1.193572,
      NULL,
      NULL,
      0,
      2.109439,
      3.085466,
      0.185521,
      6,
      7.708197,
      0,
      3,
      3.398641,
      5.813524,
      2,
      NULL,
      2.947566,
      45,
      0,
      1,
      45.788253,
      NULL,
      NULL,
      58,
      2.449172,
      4.768343,
      NULL,
      '20413',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      4.755617,
      '4011',
      '32120',
      '',
      1.230801,
      41,
      188,
      23,
      0.611486,
      59,
      7.698317,
      5,
      2.247233,
      3,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0.185880,
      NULL,
      NULL,
      2.917341,
      1.837768,
      0.579420,
      1,
      NULL,
      NULL,
      0.229883,
      0.598335,
      1,
      3.585150,
      1.471632,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.838122,
      NULL,
      NULL,
      5.002613,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.369329,
      0.436319,
      1,
      3.372691,
      NULL,
      1.381535,
      3,
      NULL,
      1,
      3,
      0,
      0,
      1,
      1,
      1.543785,
      0,
      3,
      3.938719,
      NULL,
      0.077952,
      3.362551,
      3.518174,
      0.589989,
      0.180458,
      3.202496,
      0.971836,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.653416,
      NULL,
      NULL,
      0.239654,
      1.500046,
      0,
      7,
      3.194258,
      7.713805,
      0.200212,
      1.135899,
      NULL,
      NULL,
      NULL,
      3.781152,
      1.792160,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3,
      0.525022,
      NULL,
      NULL,
      NULL,
      1.593439,
      NULL,
      NULL,
      5,
      0,
      2.552384,
      3,
      0.498007,
      2,
      1.173248,
      NULL,
      NULL,
      5,
      1,
      4.412381,
      NULL,
      NULL,
      NULL,
      0.544909,
      NULL,
      NULL,
      1.955364,
      NULL,
      NULL,
      1.961087,
      NULL,
      NULL,
      1.767027,
      NULL,
      NULL,
      1.281891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.010665,
      NULL,
      NULL,
      4.222958,
      NULL,
      0.910511,
      1.129595,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      2,
      1.321702,
      1,
      NULL,
      3.600883,
      NULL,
      NULL,
      1,
      NULL,
      0.905757,
      NULL,
      NULL,
      3.258430,
      3,
      2.978047,
      2.273745,
      3.881596,
      NULL,
      0.171543,
      9.895478,
      6,
      6,
      5,
      NULL,
      3.783758,
      0,
      0,
      3,
      NULL,
      1,
      NULL,
      1,
      1,
      2,
      NULL,
      NULL,
      0.189560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.097585,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.864792,
      NULL,
      NULL,
      1.478978,
      NULL,
      NULL,
      0.022010,
      1.559452,
      NULL,
      1.713586,
      NULL,
      1.817042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.141108,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.137136,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.272524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.493677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.207281,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.783535,
      NULL,
      NULL,
      NULL,
      2.027276,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.854322,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.528545,
      0.807688,
      NULL,
      NULL,
      2,
      NULL,
      4,
      2.850241,
      10.094306,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.558669,
      4.427445,
      3,
      0.432125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.168744,
      0,
      1,
      1.494787,
      1,
      0,
      0,
      0,
      0,
      1,
      0.643748,
      NULL,
      1,
      1.666946,
      1.657484,
      0.614557,
      1.459833,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.673110,
      1.997422,
      NULL,
      NULL,
      3.231060,
      NULL,
      1.239602,
      NULL,
      1.130697,
      NULL,
      1.011182,
      NULL,
      0.471687,
      0.950426,
      NULL,
      1,
      3.082250,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.294506,
      NULL,
      0,
      0.349119,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.443252,
      NULL,
      NULL,
      0,
      NULL,
      1.944421,
      2.702395,
      NULL,
      0,
      0.810520,
      NULL,
      NULL,
      1.643889,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.122566,
      1.445612,
      NULL,
      0.873448,
      NULL,
      1,
      NULL,
      0.090568,
      NULL,
      0,
      NULL,
      3.813947,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.647986,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      39,
      0.088538,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.381502,
      NULL,
      1.388241,
      0.711586,
      NULL,
      NULL,
      49.768884,
      43,
      2.906089,
      4,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '',
      '',
      1,
      '1014',
      '43044',
      '');
commit;
end;
/


