set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9503953';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.485076,
      0.329905,
      NULL,
      3.232995,
      0.363429,
      3,
      0,
      0.241385,
      '304',
      '41314421',
      NULL,
      36.303726,
      '4044312',
      2.278346,
      NULL,
      1,
      0,
      '2421',
      3,
      1.806663,
      NULL,
      NULL,
      NULL,
      134.403758,
      101,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.887114,
      ' 9- 3-1999',
      ' 9-14-1989',
      ' 7- 7-1975',
      NULL,
      NULL,
      3,
      1.404587,
      NULL,
      1,
      2,
      0.870088,
      NULL,
      NULL,
      3.237949,
      5.017320,
      3.630955,
      NULL,
      NULL,
      NULL,
      NULL,
      5.050755,
      0,
      NULL,
      1.386941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.334769,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.630905,
      NULL,
      NULL,
      0,
      1.303132,
      1,
      1.146684,
      1,
      0,
      0,
      5,
      1.004083,
      0.583527,
      1.206930,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.548696,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.743709,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.031903,
      1.643515,
      0,
      1.548030,
      0.886189,
      NULL,
      1.603757,
      NULL,
      0,
      1.516845,
      0.894151,
      0.860771,
      3.197753,
      0.887928,
      1,
      NULL,
      0.096123,
      NULL,
      1,
      NULL,
      0.324011,
      3.360198,
      NULL,
      0,
      NULL,
      5.696589,
      7.931414,
      NULL,
      NULL,
      4.684679,
      1,
      3,
      7.251294,
      1.595270,
      4,
      4.954695,
      4,
      3,
      6,
      7.658641,
      7.483431,
      3.983842,
      6.579994,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.117932,
      0.022107,
      NULL,
      0,
      0,
      NULL,
      1.532512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.555087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.734200,
      1,
      3,
      3,
      0,
      1.344589,
      1.173852,
      3.076547,
      2.851646,
      1,
      NULL,
      1.919950,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      0.933697,
      0,
      NULL,
      1,
      NULL,
      26,
      2.760936,
      2,
      71.218523,
      NULL,
      123,
      NULL,
      0,
      NULL,
      NULL,
      5.289461,
      5,
      NULL,
      3.985643,
      5,
      3.798770,
      3.117384,
      NULL,
      5,
      4,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.422735,
      1.962508,
      NULL,
      0,
      NULL,
      NULL,
      1.449618,
      1,
      0.055911,
      1.993947,
      1,
      0.554841,
      0,
      4,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0.574376,
      5,
      3.793414,
      2,
      NULL,
      17.171371,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      109,
      1.140278,
      4,
      1,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      3.583832,
      '2031',
      NULL,
      '',
      1.851324,
      47.243674,
      NULL,
      NULL,
      0,
      31.501236,
      4.680815,
      NULL,
      4.377026,
      2,
      2,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.474233,
      NULL,
      0.951463,
      NULL,
      NULL,
      1,
      1.034264,
      0,
      2.818842,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1.571143,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.268151,
      NULL,
      NULL,
      0.217468,
      NULL,
      NULL,
      0.497368,
      4,
      NULL,
      1.214366,
      0.580608,
      NULL,
      NULL,
      NULL,
      NULL,
      0.863933,
      3,
      1,
      2,
      NULL,
      1.565285,
      2,
      NULL,
      0.905441,
      3.787678,
      NULL,
      0,
      1,
      1.494439,
      0.378848,
      1.431360,
      1.787587,
      3,
      1,
      2,
      1,
      NULL,
      1.575760,
      3,
      0.820229,
      0.574047,
      3.196296,
      NULL,
      0,
      NULL,
      NULL,
      0.143663,
      NULL,
      NULL,
      3,
      3.628608,
      0.056395,
      4.957814,
      NULL,
      5.514561,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.800942,
      1.589469,
      3,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1.502172,
      0.000812,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.650093,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1,
      NULL,
      NULL,
      1.147072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.361725,
      NULL,
      NULL,
      3.226080,
      1,
      0.817726,
      1,
      0,
      0.714317,
      1,
      3,
      0.881517,
      1.202227,
      NULL,
      NULL,
      0,
      0.997103,
      1.688649,
      2.493257,
      0,
      2.236865,
      3,
      NULL,
      0,
      NULL,
      NULL,
      4.831033,
      0.480577,
      1.579007,
      3,
      1.691338,
      3,
      3.385458,
      3.879154,
      1.559070,
      3.801088,
      1,
      2.016096,
      2.185843,
      1.952038,
      1,
      4,
      3.514000,
      0,
      NULL,
      3.439278,
      1.323538,
      2.725466,
      0.540551,
      1.400403,
      NULL,
      1.931118,
      1,
      1.451418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.107557,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.339869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.653519,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      3.857994,
      0,
      1.893254,
      NULL,
      0,
      5.024514,
      1,
      NULL,
      5,
      5.459612,
      NULL,
      NULL,
      3.071405,
      1.129624,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.809422,
      1,
      NULL,
      0.168460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.592304,
      NULL,
      NULL,
      NULL,
      1.422806,
      NULL,
      NULL,
      NULL,
      0.290972,
      0.903847,
      0,
      NULL,
      1.974531,
      0,
      1,
      NULL,
      3,
      1,
      3.129122,
      NULL,
      3,
      NULL,
      0.104989,
      NULL,
      2,
      1.769356,
      0.017456,
      NULL,
      2,
      1.838072,
      0,
      NULL,
      2,
      1.017231,
      1.654382,
      NULL,
      15.554389,
      2,
      0.256829,
      NULL,
      1,
      1,
      2,
      2,
      4,
      2,
      103,
      27,
      0.740211,
      32,
      11.119953,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      2.063572,
      NULL,
      1,
      0.313308,
      NULL,
      NULL,
      0.077143,
      NULL,
      1.594588,
      221,
      1,
      0,
      1,
      1.528759,
      0,
      0,
      1.158837,
      1.276974,
      NULL,
      1.074958,
      1.113903,
      0,
      1.928768,
      NULL,
      1,
      0,
      1,
      1.923194,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.285960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.546350,
      NULL,
      NULL,
      0.557958,
      0.477428,
      1.481998,
      NULL,
      1.843338,
      0.113593,
      3,
      3.677298,
      1,
      1,
      0,
      0.343621,
      0,
      0.362591,
      1,
      3,
      NULL,
      0.769446,
      1,
      NULL,
      1,
      0.484386,
      1.967665,
      1.228462,
      0.779432,
      3.444143,
      0,
      1.366705,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      1.145207,
      0.787718,
      3,
      3.017131,
      1.052054,
      0.995623,
      1.480705,
      0.585191,
      3,
      1.671842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.381068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.115906,
      1.446684,
      0,
      0.305235,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      43.130443,
      84.779490,
      3.319901,
      NULL,
      1,
      '40304',
      NULL,
      '',
      0.668484,
      NULL,
      '',
      '',
      7.985189,
      '0302',
      '3124',
      '03442');
commit;
end;
/


