set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9503953';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.364762,
      2.001219,
      1.253848,
      1,
      NULL,
      1.140361,
      3.919541,
      0,
      NULL,
      '40014344',
      0,
      64,
      '4432202',
      NULL,
      0.532593,
      0,
      3,
      '3432',
      5.072926,
      NULL,
      NULL,
      NULL,
      ' 0- 0-1979',
      163.266847,
      119.098172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 9- 2-1994',
      ' 3-19-1975',
      ' 0-22-1980',
      NULL,
      2,
      3,
      1.115435,
      0,
      2,
      0.907795,
      2.014847,
      NULL,
      NULL,
      NULL,
      1,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      2.680433,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.112811,
      6.886257,
      1.061489,
      1,
      1,
      NULL,
      0.570864,
      0,
      1,
      0.361742,
      1.031087,
      1.381784,
      0,
      1,
      1.721656,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0,
      NULL,
      0.811296,
      0.953409,
      NULL,
      NULL,
      NULL,
      2.402580,
      0,
      NULL,
      0.803940,
      3,
      3,
      1,
      3,
      0,
      NULL,
      2.451906,
      0.608628,
      1,
      NULL,
      9.604261,
      NULL,
      NULL,
      1.560314,
      NULL,
      NULL,
      NULL,
      1.639346,
      NULL,
      NULL,
      1.997194,
      0,
      1.932994,
      0,
      0.130553,
      0,
      1,
      NULL,
      0,
      0,
      1,
      3.588223,
      1,
      NULL,
      1.832493,
      0.667218,
      1.937889,
      0.619011,
      1,
      NULL,
      1.254051,
      1,
      1.353171,
      5,
      1,
      1.761530,
      5.980367,
      1.761148,
      0,
      1,
      1.563389,
      0.422188,
      5.164565,
      6.711445,
      0,
      3.231587,
      5.473670,
      1.360405,
      NULL,
      1.121468,
      NULL,
      4,
      0.309761,
      0.565366,
      1.627021,
      5.100815,
      5,
      0.846060,
      NULL,
      NULL,
      ' 2-27-1995',
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.853731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.163721,
      1,
      NULL,
      1,
      1,
      NULL,
      0.515041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.406246,
      NULL,
      NULL,
      1,
      1,
      1.588980,
      1.993464,
      0,
      2.926047,
      1.644320,
      2.692088,
      0,
      NULL,
      3.398082,
      2.503075,
      0,
      2.487702,
      0,
      0,
      4,
      3,
      0,
      0,
      0.390529,
      NULL,
      NULL,
      NULL,
      0,
      1.700399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.531396,
      2,
      0,
      0.338602,
      0,
      1.893413,
      0.153631,
      1.415709,
      24,
      2.558980,
      1.668327,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      5,
      5,
      2,
      0.259623,
      5,
      1.994597,
      0,
      NULL,
      4,
      4.301726,
      0,
      1,
      2,
      0,
      1.530788,
      0.782230,
      1.733446,
      0,
      1,
      1,
      NULL,
      1.348973,
      0.682270,
      0,
      1.652813,
      1,
      0.330174,
      3,
      0.753793,
      0.584704,
      6,
      0.825201,
      1,
      4,
      NULL,
      1.442970,
      0.009926,
      5.334859,
      NULL,
      NULL,
      1,
      3.959656,
      2,
      3,
      12.128596,
      NULL,
      70,
      57.905654,
      5.667943,
      1.126383,
      3.616137,
      '12202',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0,
      '0012',
      '',
      '',
      2,
      43.375599,
      278,
      68.595936,
      1.133326,
      68,
      12,
      1,
      NULL,
      0,
      3.968355,
      0,
      1.411693,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      1.028278,
      0.678500,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.350773,
      NULL,
      NULL,
      1.129488,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.340887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.433154,
      1.654722,
      7.064597,
      0.544135,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.023637,
      2,
      2,
      NULL,
      NULL,
      NULL,
      3,
      1.733082,
      1,
      NULL,
      1,
      0,
      2.841697,
      1,
      0.582914,
      3.501922,
      2.689627,
      0,
      NULL,
      2.181606,
      NULL,
      NULL,
      0,
      0,
      3,
      0.762866,
      0,
      3.533806,
      NULL,
      NULL,
      NULL,
      0.546645,
      NULL,
      NULL,
      1.070679,
      1,
      1,
      2.107534,
      4,
      NULL,
      0,
      1.999424,
      NULL,
      NULL,
      NULL,
      1.917413,
      1.871449,
      0.147624,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.079773,
      0.289384,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2,
      1.216001,
      2.652468,
      0,
      0,
      1.444940,
      NULL,
      NULL,
      5.529252,
      NULL,
      0.132118,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.958601,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.759619,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.726767,
      2,
      5.970793,
      0,
      NULL,
      NULL,
      0.029739,
      1.476766,
      2,
      3,
      3,
      2,
      3,
      3.127376,
      2,
      NULL,
      2.837770,
      6,
      0,
      3,
      2.600152,
      3.150277,
      2.587777,
      0.301446,
      1.610819,
      3,
      2.182177,
      3,
      2.048153,
      NULL,
      7.584485,
      NULL,
      1,
      4,
      NULL,
      NULL,
      NULL,
      1,
      1.975141,
      NULL,
      0.108140,
      0.671389,
      0,
      0.021339,
      3.870228,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.710112,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.846952,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      3,
      0,
      2,
      NULL,
      8.014696,
      1.064523,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.305535,
      0.767221,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      1.954080,
      0.963466,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.935428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.824064,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.447481,
      NULL,
      2,
      NULL,
      3,
      NULL,
      3,
      0,
      0.511303,
      NULL,
      3.307068,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      17,
      2,
      0.569618,
      NULL,
      1.064652,
      3.709772,
      NULL,
      3,
      NULL,
      3,
      68.620178,
      16,
      0.880419,
      12,
      NULL,
      0.941024,
      NULL,
      NULL,
      1.454683,
      NULL,
      NULL,
      1.385991,
      NULL,
      2,
      0.260733,
      NULL,
      NULL,
      1,
      NULL,
      0.025074,
      230.643242,
      NULL,
      1.669275,
      NULL,
      NULL,
      NULL,
      1,
      0.697743,
      0,
      NULL,
      NULL,
      1.487519,
      1,
      1.152339,
      NULL,
      0.416361,
      NULL,
      1.135586,
      1.510439,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.172701,
      0,
      1.853208,
      NULL,
      NULL,
      1.789169,
      0.883926,
      1,
      1.475083,
      0,
      NULL,
      2,
      1,
      0,
      1.155039,
      1.471379,
      NULL,
      0.164890,
      0,
      NULL,
      1.157455,
      0.034852,
      0,
      0,
      0,
      0.046433,
      0,
      0.206808,
      1,
      NULL,
      0.276971,
      0.500891,
      2.736802,
      NULL,
      NULL,
      NULL,
      1.211952,
      1,
      0.787662,
      1.324866,
      0,
      NULL,
      0,
      0.238314,
      0,
      NULL,
      1,
      0.172273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.800078,
      0.138723,
      0.124493,
      1,
      0.584540,
      0,
      3,
      4.948535,
      0,
      NULL,
      NULL,
      NULL,
      66,
      51.808933,
      3.819935,
      2.542243,
      0,
      '00214',
      '4212',
      '',
      0,
      NULL,
      '',
      NULL,
      4,
      '3424',
      '3403',
      '21142');
commit;
end;
/


