set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9915007';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      2.118438,
      0.006991,
      NULL,
      NULL,
      1,
      1,
      '403',
      NULL,
      NULL,
      25,
      '0014214',
      3,
      1.017192,
      3,
      0,
      '2002',
      5.778474,
      NULL,
      NULL,
      NULL,
      '10- 2-1977',
      NULL,
      25,
      NULL,
      2.445350,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-21-1980',
      3,
      0,
      2.438849,
      3,
      1.102258,
      3,
      0.479015,
      1.061212,
      1.603681,
      90.011884,
      10,
      13.792144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      3.557033,
      NULL,
      0.683689,
      2.909874,
      0,
      NULL,
      NULL,
      0.183035,
      1.718069,
      0,
      0,
      0.990100,
      0,
      2.161206,
      NULL,
      4.238194,
      0.780407,
      3,
      0,
      NULL,
      2.904384,
      NULL,
      NULL,
      0,
      2,
      0.220339,
      2,
      2,
      3.767216,
      0.332412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.894974,
      NULL,
      2,
      3.049368,
      1.317221,
      NULL,
      NULL,
      NULL,
      NULL,
      2.649668,
      3.029996,
      NULL,
      0,
      1,
      0.738964,
      1,
      0,
      NULL,
      0,
      3.358167,
      1,
      1,
      2.220180,
      1.321861,
      0,
      2.367993,
      NULL,
      NULL,
      NULL,
      0.514384,
      NULL,
      NULL,
      0.638725,
      NULL,
      0.536673,
      0,
      5,
      NULL,
      NULL,
      1.870063,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      0.064103,
      0,
      1.851577,
      2,
      NULL,
      3.411739,
      NULL,
      1.800951,
      2,
      4.836245,
      0.213255,
      8,
      3.631503,
      NULL,
      NULL,
      2.816117,
      NULL,
      3.441861,
      NULL,
      1,
      0.805700,
      7,
      0.465088,
      11.100592,
      11.627299,
      6.160655,
      6.130898,
      6,
      NULL,
      5,
      2,
      0.411820,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.606856,
      1.641114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.900620,
      1,
      0,
      0.736620,
      1,
      1.782819,
      0,
      1.912697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.877837,
      NULL,
      NULL,
      NULL,
      NULL,
      1.100215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.972545,
      0.986523,
      0,
      NULL,
      NULL,
      NULL,
      1.800011,
      7,
      0.729854,
      3.103135,
      1,
      3.739141,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.294207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.217709,
      NULL,
      0.354561,
      2.641454,
      1.383525,
      0.354933,
      0,
      1.729197,
      NULL,
      2.230104,
      1,
      NULL,
      NULL,
      NULL,
      4.035585,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5.832804,
      1,
      3,
      4.000705,
      NULL,
      3.114695,
      2,
      1.154737,
      NULL,
      2,
      0.444761,
      0.559154,
      0,
      NULL,
      1,
      1.500066,
      1,
      0.023146,
      1,
      0,
      1,
      0.156926,
      1.878558,
      NULL,
      3.072985,
      0,
      2,
      7,
      1.401518,
      3.717460,
      3,
      0.227989,
      NULL,
      0,
      7.661471,
      NULL,
      3.449376,
      2,
      31,
      1,
      1,
      18.600456,
      NULL,
      NULL,
      NULL,
      0,
      1.990630,
      NULL,
      '03043',
      '',
      NULL,
      0.070153,
      '',
      '',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.130852,
      NULL,
      105.329183,
      NULL,
      0,
      32,
      0,
      0,
      0.188719,
      1.871887,
      NULL,
      NULL,
      0.452170,
      NULL,
      NULL,
      1.745523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.326433,
      NULL,
      NULL,
      1.835961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.176702,
      NULL,
      NULL,
      0.845063,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.268734,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2.364068,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.041506,
      NULL,
      0,
      2,
      0.895337,
      NULL,
      1.944688,
      2.938755,
      0.458100,
      1.932118,
      2,
      1,
      0,
      1.499901,
      3,
      0,
      1,
      NULL,
      NULL,
      1.915681,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.303049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.386611,
      NULL,
      0.235661,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      0.098926,
      1.524413,
      NULL,
      NULL,
      0.449807,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      0.164089,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.169954,
      NULL,
      NULL,
      6.843612,
      9.371771,
      1.672737,
      2.788372,
      2.827755,
      1.011551,
      0.027706,
      NULL,
      NULL,
      6.597675,
      2,
      4,
      6.838713,
      8.687521,
      3.234919,
      0,
      NULL,
      NULL,
      0,
      0.453089,
      0,
      NULL,
      2.551273,
      NULL,
      3.970624,
      0,
      0.263126,
      11,
      8,
      4.979914,
      1,
      1,
      3,
      NULL,
      0.981229,
      3,
      2.182944,
      0,
      1,
      2.347388,
      1,
      3.576486,
      9,
      8.853208,
      1,
      5.293767,
      6.744642,
      3,
      0,
      2,
      2.738840,
      0,
      NULL,
      1.030344,
      0,
      1.586508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.734739,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.545533,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0.834796,
      0,
      3.765231,
      NULL,
      NULL,
      NULL,
      3.937197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.307205,
      1,
      NULL,
      NULL,
      0.801842,
      NULL,
      NULL,
      NULL,
      0.860949,
      NULL,
      NULL,
      NULL,
      3.922678,
      1.778251,
      NULL,
      NULL,
      0,
      1.386863,
      NULL,
      NULL,
      1.538591,
      1,
      NULL,
      NULL,
      1.705270,
      0.251732,
      NULL,
      NULL,
      2,
      0.399835,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.679570,
      NULL,
      NULL,
      NULL,
      2.465468,
      0,
      NULL,
      NULL,
      3.467804,
      2,
      NULL,
      NULL,
      1.258527,
      1,
      NULL,
      NULL,
      NULL,
      3.208293,
      NULL,
      NULL,
      0,
      0.137116,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      85,
      3.418169,
      1,
      73.048666,
      2,
      0.203867,
      NULL,
      NULL,
      2,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.658216,
      NULL,
      1.533260,
      215.362093,
      NULL,
      1.676223,
      0.307138,
      0,
      NULL,
      1.196007,
      0,
      1,
      NULL,
      0.020086,
      0,
      0.563334,
      NULL,
      0.580162,
      0,
      0,
      0,
      0.393521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.395427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.199840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.224847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.294868,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.002421,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.340677,
      NULL,
      1.371196,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.930002,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.996890,
      0,
      6.829534,
      1.722261,
      NULL,
      3,
      3.297427,
      0.260331,
      3,
      0,
      0,
      0.441450,
      1.955387,
      0.832941,
      1,
      0,
      0.109083,
      0,
      1.662381,
      0,
      2,
      0.695768,
      NULL,
      1,
      1,
      1.066696,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.498706,
      0.260900,
      NULL,
      1,
      2.793165,
      NULL,
      0.171845,
      0,
      1.396608,
      0.186540,
      3.844284,
      3.257708,
      3.110029,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.956208,
      0,
      1.021601,
      1,
      0.735610,
      1,
      0,
      NULL,
      0,
      2.958732,
      0,
      NULL,
      32.510815,
      NULL,
      3.770499,
      3.267930,
      1.747268,
      '02002',
      '',
      '',
      0,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL);
commit;
end;
/


