set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7101619';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      5.333142,
      0,
      8,
      3,
      5.571222,
      2.003176,
      NULL,
      NULL,
      '341',
      NULL,
      12,
      40,
      '1330142',
      1.226745,
      0.370982,
      2,
      NULL,
      '0022',
      1.833387,
      0,
      NULL,
      NULL,
      ' 1-21-1993',
      8,
      NULL,
      NULL,
      0.277894,
      NULL,
      ' 3-24-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      2.364209,
      ' 1-21-2002',
      ' 4-15-1987',
      ' 9- 5-1975',
      NULL,
      NULL,
      3.894601,
      2.555231,
      0,
      1.177672,
      7,
      0.045890,
      0,
      7,
      2,
      13,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.195114,
      3.345780,
      NULL,
      NULL,
      1,
      4,
      0.667431,
      NULL,
      1.395830,
      1.583702,
      1.347552,
      0.615184,
      1.943893,
      0.042516,
      0.565864,
      8.877463,
      8.332867,
      0,
      0.711655,
      1.509293,
      1,
      1.613743,
      0,
      8.525818,
      1.137514,
      1.319823,
      NULL,
      1.214435,
      0.890625,
      1,
      8.020194,
      0.551845,
      1.693779,
      0.497614,
      0,
      0.689123,
      NULL,
      NULL,
      1.561457,
      NULL,
      NULL,
      4,
      1.463144,
      0,
      1.983487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.686054,
      0.340234,
      5,
      1.463376,
      0,
      0,
      0,
      NULL,
      NULL,
      1.481460,
      NULL,
      NULL,
      1.391205,
      NULL,
      1.721844,
      1.013912,
      1.730228,
      3,
      0,
      0.838696,
      0,
      1.682270,
      0,
      0.589097,
      1,
      4,
      0,
      NULL,
      NULL,
      0.383008,
      1,
      NULL,
      0.579207,
      0.811335,
      0,
      0.114238,
      1,
      0,
      1,
      7,
      1.235618,
      5,
      NULL,
      NULL,
      0,
      9,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      1.101638,
      3,
      5,
      9,
      0,
      1.651801,
      NULL,
      0,
      ' 2-26-1974',
      NULL,
      '11-10-1986',
      1829,
      3.465924,
      0,
      1.219539,
      3.142834,
      1.372755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.650694,
      1,
      0,
      0,
      1,
      1.498058,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.295761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5.362707,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.461096,
      3,
      0,
      0.251427,
      NULL,
      3.661025,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.794468,
      2.837788,
      2.707019,
      2,
      NULL,
      3,
      3,
      NULL,
      3.154011,
      3,
      1.627987,
      NULL,
      NULL,
      NULL,
      NULL,
      1.610261,
      NULL,
      1,
      5,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.405326,
      0,
      NULL,
      0.284382,
      0.206408,
      1,
      4.960261,
      8.194215,
      3,
      9,
      3,
      NULL,
      NULL,
      1.355021,
      3.188050,
      NULL,
      0,
      0.329626,
      54,
      3.533432,
      2.215099,
      60,
      NULL,
      44.811348,
      18,
      NULL,
      0.120325,
      2.357937,
      '20410',
      '',
      '',
      0.026717,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1,
      17,
      102,
      7,
      1,
      62,
      2.962653,
      0,
      1.213533,
      0.474312,
      NULL,
      2,
      0.297394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.088371,
      2,
      1.251101,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.360033,
      NULL,
      NULL,
      0.518599,
      NULL,
      NULL,
      8.239933,
      NULL,
      2.147722,
      1.405693,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.090890,
      2,
      NULL,
      1.926968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.685198,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.130491,
      5,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.144794,
      NULL,
      NULL,
      NULL,
      0.304164,
      NULL,
      NULL,
      3.899520,
      NULL,
      1.639218,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      NULL,
      2,
      NULL,
      NULL,
      0.942959,
      0.105542,
      NULL,
      NULL,
      NULL,
      1.908335,
      NULL,
      0.382653,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.932646,
      NULL,
      NULL,
      7,
      0.801253,
      0.175435,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.132658,
      NULL,
      NULL,
      1.046756,
      0.561872,
      1.924535,
      3,
      0.289705,
      3.134448,
      1.203184,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      3,
      2,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      0.502658,
      1.616493,
      NULL,
      1,
      10,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.025277,
      NULL,
      0.636323,
      1.196333,
      3,
      NULL,
      NULL,
      0.566727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.407512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.726833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.731147,
      0,
      1,
      NULL,
      1.145647,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.818694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.709364,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0.158740,
      NULL,
      NULL,
      NULL,
      3.710893,
      NULL,
      NULL,
      0,
      0,
      0.785112,
      1.524486,
      NULL,
      NULL,
      3,
      1,
      0,
      1,
      NULL,
      NULL,
      0.933413,
      NULL,
      NULL,
      0.943109,
      NULL,
      1,
      NULL,
      13.178746,
      0,
      2.998221,
      1.408262,
      0.954988,
      1,
      0.346090,
      0,
      1,
      1.979530,
      3,
      1,
      0,
      0.426759,
      1,
      0.916545,
      1.888759,
      1,
      0.370354,
      NULL,
      NULL,
      NULL,
      1.023173,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.211605,
      NULL,
      292,
      NULL,
      NULL,
      NULL,
      16,
      1.073817,
      0,
      NULL,
      NULL,
      1.548268,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.334552,
      NULL,
      NULL,
      NULL,
      0.452111,
      NULL,
      3,
      NULL,
      0.478766,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.817959,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.112216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.723473,
      3,
      4.734713,
      3,
      2,
      7.186527,
      0.739038,
      5,
      11.769393,
      2,
      3.236117,
      NULL,
      1.749023,
      1,
      NULL,
      0,
      1.358230,
      NULL,
      0.345037,
      0,
      NULL,
      1.876565,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.436274,
      0.349223,
      NULL,
      1,
      1.256738,
      NULL,
      2,
      NULL,
      NULL,
      1.723457,
      1,
      NULL,
      1.429170,
      2,
      NULL,
      1.303505,
      0,
      NULL,
      0.256451,
      1,
      1.237227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.184451,
      NULL,
      1,
      NULL,
      0,
      NULL,
      5.243651,
      2,
      4.231200,
      3.145521,
      1,
      0,
      NULL,
      13.526852,
      5.020644,
      NULL,
      1.751950,
      '04312',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


