set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9030238';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      '1324330',
      3,
      0,
      0,
      1,
      '0322',
      NULL,
      1.392364,
      NULL,
      NULL,
      ' 0- 6-1992',
      33,
      NULL,
      4.002564,
      1,
      0.454439,
      ' 0-26-1996',
      NULL,
      1,
      NULL,
      54.018072,
      1,
      ' 8-27-1979',
      ' 5- 5-1997',
      '10- 3-1979',
      1,
      2,
      NULL,
      0,
      0.988715,
      0.500626,
      NULL,
      1.234545,
      1.339669,
      132.093715,
      4,
      9,
      NULL,
      27,
      104,
      NULL,
      25.776780,
      0,
      2.015921,
      NULL,
      NULL,
      0.603609,
      0,
      1,
      0.875705,
      0,
      NULL,
      1.861726,
      0.209409,
      1.711365,
      75,
      9.343122,
      4,
      2.074849,
      1,
      0.748032,
      0,
      NULL,
      1,
      NULL,
      0.744707,
      0.738039,
      1.258247,
      1.468154,
      0,
      0,
      1.572194,
      2,
      NULL,
      0.492187,
      1.951906,
      1.427377,
      0.623670,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.047709,
      0.068519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.977234,
      3,
      0.077520,
      2.203149,
      1.452149,
      1.517519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.545122,
      2.281302,
      0.709739,
      4,
      3,
      NULL,
      3,
      NULL,
      0.521399,
      1,
      1,
      0,
      1,
      0,
      0.142441,
      0.838575,
      1.283622,
      3,
      NULL,
      NULL,
      7,
      NULL,
      1.947542,
      4,
      3.345652,
      1,
      4,
      3.394128,
      0.132859,
      5,
      5.084508,
      6,
      2,
      4.452210,
      1,
      1,
      6,
      7,
      2.341538,
      2,
      3,
      8,
      2.283227,
      4,
      0.037366,
      NULL,
      NULL,
      NULL,
      ' 0-18-1977',
      NULL,
      ' 1- 0-1975',
      NULL,
      2.018949,
      1,
      0,
      NULL,
      1.402635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.477195,
      1.911001,
      0,
      0.330187,
      NULL,
      NULL,
      0.651403,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.361982,
      1.900788,
      2.287895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.743890,
      1.483458,
      4,
      2,
      0,
      1.686491,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.844195,
      1.797501,
      0,
      1.347040,
      0.487977,
      1.517703,
      3,
      29,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.825603,
      1.152869,
      3.220709,
      0.462165,
      0.997775,
      3.518259,
      3.014209,
      2.588044,
      3.890232,
      NULL,
      1.532329,
      1,
      0,
      1.719297,
      3,
      NULL,
      1,
      NULL,
      1.898667,
      5.428577,
      1.038950,
      0,
      1,
      0.678779,
      1.292775,
      0.322968,
      0.494013,
      0.793163,
      1.949470,
      1,
      NULL,
      0,
      10,
      8.399598,
      5,
      9.002041,
      6.523767,
      3.566252,
      2.939326,
      3,
      5.793859,
      NULL,
      2.375881,
      NULL,
      NULL,
      0,
      0,
      NULL,
      38,
      24.624671,
      1,
      NULL,
      1.218675,
      3,
      NULL,
      '01333',
      '',
      0,
      NULL,
      '',
      '',
      3,
      '1114',
      '340',
      NULL,
      0,
      30.297442,
      442.830687,
      8,
      NULL,
      13,
      NULL,
      167,
      NULL,
      0,
      NULL,
      0,
      1.147090,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.516757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.558525,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.489329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.213855,
      NULL,
      NULL,
      5.001560,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.622249,
      NULL,
      NULL,
      NULL,
      0,
      1.837824,
      0,
      3.219872,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.321591,
      0,
      0,
      0,
      3,
      1,
      0.682540,
      NULL,
      2.131646,
      0,
      1,
      1.396762,
      1,
      1.133793,
      0.183919,
      3.687798,
      2.160934,
      NULL,
      2,
      2.999462,
      0,
      2,
      1.446779,
      1.582214,
      6,
      NULL,
      3,
      0,
      1.664028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.055945,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.129468,
      NULL,
      NULL,
      3.763933,
      2.748651,
      NULL,
      5.955404,
      NULL,
      NULL,
      1.839424,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1.027655,
      2.909410,
      2.930699,
      0,
      1.218312,
      NULL,
      NULL,
      0.974343,
      NULL,
      NULL,
      2.472330,
      1,
      3,
      1,
      NULL,
      NULL,
      4,
      6.640394,
      3.692464,
      0.652740,
      NULL,
      0,
      3.442313,
      1.936094,
      0,
      5,
      4.936041,
      7.993719,
      7,
      2,
      3.860659,
      2,
      4,
      7.298097,
      1,
      2,
      3.379818,
      2.842515,
      3,
      NULL,
      2.969714,
      3.136862,
      1.649249,
      NULL,
      7,
      6,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3.783853,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.370155,
      6,
      3.212876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.027121,
      1.809408,
      0.243061,
      1,
      1.867267,
      0,
      0.298284,
      NULL,
      NULL,
      1.119985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.046376,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.174897,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.382695,
      NULL,
      NULL,
      3.155850,
      NULL,
      NULL,
      1.568631,
      NULL,
      NULL,
      0.950807,
      0,
      1.889553,
      NULL,
      0,
      0,
      0.023232,
      NULL,
      NULL,
      1.913226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.385185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.577027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      11.244679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.236982,
      NULL,
      NULL,
      NULL,
      1.099042,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      402.435617,
      99.993042,
      1.870937,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      317.738134,
      67.210578,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      212,
      3.258046,
      2897,
      NULL,
      0,
      1,
      1,
      1.247593,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      0.613446,
      NULL,
      0.918788,
      NULL,
      NULL,
      1.876485,
      1,
      1.901988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      7.990232,
      NULL,
      3.102447,
      0.114469,
      4.405787,
      5.311556,
      3.382414,
      1,
      0.392372,
      1.517647,
      0,
      NULL,
      NULL,
      0.382521,
      NULL,
      0.297610,
      1,
      NULL,
      0.375866,
      1.866849,
      NULL,
      NULL,
      1.255897,
      NULL,
      3.684721,
      NULL,
      NULL,
      0,
      2.135876,
      NULL,
      2.851785,
      0,
      NULL,
      3,
      0,
      NULL,
      0,
      0,
      NULL,
      2.454575,
      2,
      NULL,
      NULL,
      1.708047,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.302563,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.882220,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.668305,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.983426,
      0,
      0,
      1,
      NULL,
      0.311649,
      NULL,
      1.748879,
      NULL,
      2.923807,
      6,
      3.505912,
      1,
      1,
      1,
      NULL,
      NULL,
      2,
      0.895272,
      4,
      '11234',
      '04021',
      '42142',
      0.055803,
      '',
      '',
      '',
      1,
      NULL,
      '402',
      NULL);
commit;
end;
/


