set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8937818';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.000863,
      0,
      2.172673,
      1.370552,
      NULL,
      1.688421,
      3,
      NULL,
      '341',
      '0',
      NULL,
      77.571021,
      '4442130',
      3,
      1.847171,
      0,
      1,
      NULL,
      6,
      0,
      NULL,
      NULL,
      ' 4-28-1994',
      31.380755,
      34.111551,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.611803,
      NULL,
      NULL,
      ' 8- 0-1986',
      3,
      3,
      NULL,
      2,
      NULL,
      2,
      1,
      3,
      NULL,
      NULL,
      NULL,
      5,
      1.141887,
      NULL,
      NULL,
      NULL,
      NULL,
      4.567273,
      3,
      NULL,
      1.313979,
      NULL,
      1.974244,
      1,
      1.234695,
      NULL,
      1.674688,
      NULL,
      NULL,
      0.343544,
      1.340515,
      0,
      NULL,
      1,
      3.613590,
      5,
      0,
      0.539916,
      NULL,
      NULL,
      NULL,
      3.686170,
      0,
      3.866914,
      4,
      4.250175,
      1,
      8.843232,
      0.333992,
      NULL,
      3.129284,
      5,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0,
      1.337417,
      3.154912,
      1,
      1.063201,
      0.325857,
      1.105160,
      1.401070,
      0,
      0,
      1.433393,
      2,
      1.386935,
      0,
      0.171833,
      1,
      1.785660,
      1,
      NULL,
      0.336494,
      NULL,
      8,
      0,
      NULL,
      0.755811,
      1.826064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.846684,
      1.562876,
      0,
      0,
      1,
      1.727196,
      1,
      NULL,
      0.153939,
      0.130669,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.504841,
      1.680701,
      NULL,
      1,
      3.509345,
      NULL,
      1,
      2,
      0.537299,
      NULL,
      5,
      4.327903,
      1.511253,
      0.951732,
      NULL,
      9.356139,
      6,
      4.595679,
      NULL,
      5.377102,
      7,
      4,
      1.398088,
      0,
      0,
      3.655914,
      NULL,
      23,
      ' 5-28-1989',
      8.103393,
      3,
      1.187568,
      NULL,
      5.126588,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.989120,
      0,
      4.864298,
      NULL,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      71,
      2.384092,
      3.159012,
      6,
      NULL,
      0.614772,
      0,
      0.539577,
      3.427338,
      2.474053,
      NULL,
      3.860099,
      3,
      2.086987,
      1.993453,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      3.278750,
      0,
      2,
      1,
      0,
      6.969584,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.661145,
      0.093917,
      1.840575,
      12,
      0.721565,
      1.852504,
      NULL,
      NULL,
      NULL,
      2.689158,
      1.984414,
      1,
      NULL,
      2.207683,
      NULL,
      5,
      0,
      3.735566,
      2.748692,
      3,
      NULL,
      5.541282,
      0.857153,
      NULL,
      0,
      1,
      NULL,
      1,
      1.347522,
      0,
      0.870250,
      0,
      1.718722,
      1.512583,
      0,
      0,
      1,
      1,
      2.898227,
      1,
      NULL,
      3,
      3,
      4.137400,
      1,
      1,
      NULL,
      1.252419,
      2,
      1,
      3,
      0.286746,
      0,
      8,
      1,
      1,
      23,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      '41221',
      '',
      '',
      NULL,
      '',
      '',
      '',
      2,
      '04013',
      '',
      '',
      0,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.786984,
      NULL,
      NULL,
      NULL,
      0.921258,
      1.982781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.403679,
      NULL,
      0,
      256.040238,
      1.667040,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      0.246364,
      0.608184,
      0,
      0.487114,
      0.476060,
      1,
      NULL,
      1,
      0.277976,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.092684,
      2,
      1.945179,
      3.154728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.560024,
      0,
      0.922710,
      0.529989,
      NULL,
      NULL,
      NULL,
      3.812268,
      NULL,
      NULL,
      2.601113,
      NULL,
      NULL,
      1.667309,
      NULL,
      0,
      2,
      NULL,
      0.491025,
      NULL,
      NULL,
      1.914392,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.597649,
      NULL,
      0,
      1,
      NULL,
      0,
      1.782606,
      NULL,
      3.168313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.795286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.660101,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.551882,
      NULL,
      3.392577,
      0.501378,
      NULL,
      NULL,
      70.798719,
      NULL,
      1.229665,
      2.953496,
      NULL,
      '31330',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      3.707515,
      NULL,
      '',
      '');
commit;
end;
/


