set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8813791';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-5-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '4330223',
      1,
      1.207389,
      5,
      2,
      '0242',
      0,
      0.455439,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      3.941350,
      1,
      0.983750,
      ' 7-26-1986',
      37.423222,
      NULL,
      180,
      93,
      3.515852,
      ' 9-29-2000',
      ' 5-25-1980',
      '10-10-1998',
      NULL,
      0,
      2.919504,
      3.666926,
      NULL,
      2,
      2,
      3.107197,
      NULL,
      NULL,
      NULL,
      10.519818,
      5,
      NULL,
      NULL,
      2,
      7.715684,
      1.990478,
      0.258468,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      2,
      9.790536,
      1.706641,
      3.425372,
      3,
      1.363489,
      NULL,
      7,
      0,
      0,
      1.871718,
      5,
      6,
      0.689181,
      0,
      4,
      1,
      2,
      0,
      NULL,
      NULL,
      2,
      0,
      4,
      7,
      0.314707,
      1,
      0.867433,
      1.620025,
      0,
      3.563268,
      3,
      1,
      0.158429,
      1.637983,
      1,
      1,
      0,
      1,
      0.284963,
      3.083183,
      0,
      3.833753,
      5,
      1,
      NULL,
      9,
      NULL,
      NULL,
      0.233331,
      1,
      NULL,
      NULL,
      NULL,
      1.794933,
      2.924075,
      NULL,
      NULL,
      9,
      NULL,
      6,
      NULL,
      2,
      1.479083,
      0,
      0.007360,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.625853,
      0,
      0.120995,
      NULL,
      NULL,
      0.550538,
      3,
      4.278011,
      5,
      7.903599,
      5,
      2,
      NULL,
      5,
      6,
      3,
      1,
      3.743025,
      7,
      6.214315,
      0,
      7.269713,
      8,
      2.621954,
      7,
      0,
      6.169190,
      3,
      7,
      5.617436,
      5,
      7,
      3,
      ' 9- 8-1977',
      48.790998,
      ' 9-27-1980',
      10,
      1.956391,
      0.291479,
      0.423991,
      2.851191,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.727521,
      0,
      2.653735,
      NULL,
      3.018262,
      NULL,
      0.448253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.363225,
      NULL,
      1.508125,
      NULL,
      1,
      6.471210,
      0,
      NULL,
      2.750460,
      NULL,
      NULL,
      1.809497,
      NULL,
      2,
      0,
      1,
      3.828963,
      6,
      NULL,
      6,
      5.407339,
      1,
      2,
      1,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      2,
      3.118397,
      NULL,
      NULL,
      NULL,
      8.542043,
      NULL,
      1,
      0,
      0,
      1.302077,
      NULL,
      0,
      1,
      1,
      NULL,
      0.070751,
      NULL,
      1,
      0.337332,
      NULL,
      NULL,
      NULL,
      1,
      1.494115,
      2.228694,
      NULL,
      1.633576,
      2.736080,
      0,
      NULL,
      NULL,
      1.428396,
      3.207123,
      NULL,
      1,
      2,
      3.106077,
      1,
      1,
      3.781109,
      1.829968,
      5.419098,
      NULL,
      0,
      0,
      1.986462,
      1.464878,
      NULL,
      157.911324,
      26.063227,
      2.849533,
      0,
      NULL,
      1.967305,
      6.909370,
      8,
      5,
      3,
      NULL,
      4.024096,
      4,
      1.709424,
      4,
      0.686170,
      3,
      3.994213,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      67,
      2.454327,
      NULL,
      NULL,
      '34130',
      NULL,
      '',
      0.699868,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0.655784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.871902,
      3.152387,
      0.494162,
      NULL,
      NULL,
      1.807924,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.736538,
      NULL,
      NULL,
      1.378490,
      NULL,
      NULL,
      0.873420,
      NULL,
      1.119986,
      11600,
      NULL,
      NULL,
      0.966684,
      0.211473,
      NULL,
      NULL,
      NULL,
      NULL,
      1.207339,
      1.409881,
      1.200987,
      1,
      0,
      1.337245,
      1.764318,
      1,
      0,
      1,
      3,
      NULL,
      1.724860,
      NULL,
      NULL,
      NULL,
      1.474592,
      NULL,
      0,
      NULL,
      2,
      NULL,
      27,
      NULL,
      2.565105,
      NULL,
      10,
      0.185403,
      NULL,
      NULL,
      NULL,
      1.525361,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.565471,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.183582,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.443322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.607685,
      1.492074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.336664,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      129,
      NULL,
      1,
      NULL,
      1.617593,
      NULL,
      0.202687,
      NULL,
      3,
      0.099167,
      0.480641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.929094,
      1.800878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.416850,
      NULL,
      1,
      NULL,
      0.956807,
      NULL,
      149.015285,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      14,
      37.135350,
      2.059741,
      0,
      NULL,
      3,
      3,
      3.864545,
      1,
      7.222021,
      0.840646,
      1,
      0,
      0.298587,
      0.436598,
      2.722738,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3.902185,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3.080471,
      NULL,
      0.514477,
      0.094184,
      NULL,
      NULL,
      1.678233,
      NULL,
      0.075444,
      0,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      66.091117,
      59,
      1.284517,
      1,
      5.535880,
      '10423',
      '34134',
      '03130',
      0.794840,
      '',
      '',
      '',
      1.763835,
      '',
      '',
      '');
commit;
end;
/


