set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9424759';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-5-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '12',
      '44',
      0.054596,
      38.112105,
      '0324120',
      1.181574,
      0.458074,
      0,
      3,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      ' 8- 8-1981',
      8.547249,
      39,
      NULL,
      NULL,
      0.462636,
      ' 6-21-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      1.897209,
      '11-27-2001',
      ' 0- 1-1977',
      '10-10-1990',
      NULL,
      1,
      0.649245,
      2,
      1.471969,
      1,
      2,
      0,
      NULL,
      1.470264,
      5.348322,
      18,
      4.867791,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.093271,
      3.587882,
      1,
      1.108512,
      1.920989,
      1,
      0.049463,
      0.670328,
      NULL,
      1,
      NULL,
      2.366670,
      5,
      5,
      3.395918,
      2.235052,
      0,
      NULL,
      1,
      3.446664,
      0.271437,
      5.652284,
      0,
      1,
      1.629497,
      0,
      3,
      NULL,
      0.323905,
      NULL,
      2.890868,
      1,
      1.658151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.271343,
      3.465720,
      0.495812,
      NULL,
      0.849992,
      NULL,
      1.859446,
      0.897332,
      3,
      1.566666,
      0,
      1.587641,
      NULL,
      1,
      1.558046,
      1,
      NULL,
      2,
      1,
      0.726017,
      1.069527,
      1.744854,
      6.666481,
      1.021060,
      0,
      0.726056,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.558805,
      1,
      NULL,
      1.132674,
      NULL,
      0.239926,
      NULL,
      0.646186,
      NULL,
      0.254085,
      1,
      0.895981,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.705439,
      2.139668,
      0,
      0.800743,
      0,
      0.605543,
      2.566484,
      7,
      2.598205,
      0,
      9,
      2,
      1.100384,
      8,
      1,
      2.521199,
      NULL,
      6,
      4,
      4,
      6.934490,
      7,
      0,
      7.697406,
      4,
      4.577822,
      4.774255,
      1,
      ' 9- 9-1986',
      198,
      ' 5-21-1994',
      153,
      0,
      0,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1.947618,
      1.257060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.801051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.690776,
      3,
      1,
      2,
      1,
      0.508534,
      NULL,
      0,
      3.557450,
      7.603071,
      3.102682,
      0.357174,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0.885580,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.253914,
      1,
      1.111400,
      1,
      0.640091,
      0.837079,
      2,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      7,
      1.979543,
      1,
      4,
      1,
      1.495683,
      0.922889,
      0.446691,
      NULL,
      NULL,
      7,
      1,
      NULL,
      2.432479,
      1.164127,
      2.824030,
      0,
      1.774364,
      0.763553,
      1.942536,
      0,
      0,
      NULL,
      0.587877,
      1.519678,
      NULL,
      NULL,
      1,
      NULL,
      1.030180,
      1.630560,
      NULL,
      NULL,
      0.780659,
      3.308163,
      3,
      5.975474,
      0.770765,
      NULL,
      2.272973,
      7,
      2.983106,
      NULL,
      3,
      37,
      0,
      0.930500,
      39.110362,
      NULL,
      19,
      62.436958,
      1,
      5,
      0,
      '40123',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      2,
      26,
      6,
      32.926206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      3.501929,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.966293,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      7.650485,
      0.907728,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      2.846401,
      0,
      2.674139,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.459610,
      1,
      NULL,
      1.589219,
      3.525698,
      1.279774,
      0.494856,
      1.015247,
      0.834429,
      3,
      0,
      NULL,
      2.783985,
      NULL,
      NULL,
      NULL,
      1.694950,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.025328,
      0.745844,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.658979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.457935,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.539888,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.864826,
      NULL,
      NULL,
      1.772129,
      NULL,
      NULL,
      1.866694,
      3,
      0,
      0,
      NULL,
      NULL,
      2,
      3.042981,
      4.610431,
      5.575120,
      4.267748,
      NULL,
      0,
      NULL,
      NULL,
      0.908878,
      0.223986,
      3.139540,
      1.143981,
      2.881784,
      3,
      3.405218,
      1.215157,
      0,
      1.576324,
      1,
      NULL,
      1.929827,
      1.456505,
      2.052586,
      2,
      1,
      3,
      3.449834,
      2,
      2.087369,
      3,
      2,
      3.243311,
      NULL,
      3,
      6.548682,
      NULL,
      4,
      5,
      2,
      3,
      NULL,
      1,
      1,
      1,
      0.774973,
      0,
      NULL,
      NULL,
      NULL,
      1.466490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.956484,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.929329,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.921511,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.722978,
      0.605838,
      0.640982,
      1.003465,
      0,
      1.961080,
      NULL,
      NULL,
      3.556569,
      NULL,
      NULL,
      NULL,
      235.468379,
      NULL,
      NULL,
      NULL,
      1.452508,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.766775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.477845,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.963998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.395147,
      NULL,
      NULL,
      NULL,
      1.980546,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7.687113,
      NULL,
      NULL,
      NULL,
      1.165024,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.853233,
      3,
      NULL,
      0.453922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.600235,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      418,
      NULL,
      NULL,
      0,
      1.722929,
      0.410470,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.275423,
      0.444827,
      1,
      1,
      0,
      0,
      0,
      0,
      2,
      NULL,
      0.770797,
      NULL,
      1.503739,
      NULL,
      1.300255,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.362143,
      13,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.773361,
      NULL,
      1,
      NULL,
      1.426740,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.276496,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.066281,
      NULL,
      NULL,
      1.379988,
      0.140168,
      0.663809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.364905,
      1.350414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.189812,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.944103,
      NULL,
      1.148606,
      NULL,
      NULL,
      NULL,
      1.279594,
      0,
      0.887240,
      NULL,
      1.152590,
      NULL,
      0.833159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.090945,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.092000,
      NULL,
      1.079254,
      NULL,
      1,
      NULL,
      0.750042,
      NULL,
      NULL,
      NULL,
      0.743619,
      NULL,
      1,
      NULL,
      0.179960,
      1,
      NULL,
      NULL,
      NULL,
      1.732000,
      NULL,
      NULL,
      NULL,
      1,
      1.910320,
      NULL,
      0.918258,
      NULL,
      1,
      0.375004,
      1,
      7,
      0.057901,
      NULL,
      1.444503,
      0.724273,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.395314,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      0.034472,
      1.160522,
      NULL,
      0,
      0.290804,
      NULL,
      NULL,
      1.382980,
      NULL,
      0.617408,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.265184,
      1.369168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.669499,
      NULL,
      1,
      NULL,
      1,
      NULL,
      6,
      3.278405,
      2,
      NULL,
      NULL,
      NULL,
      57,
      129,
      1,
      2,
      4,
      '31243',
      '20411',
      '',
      0.168683,
      NULL,
      '',
      '',
      0,
      NULL,
      NULL,
      NULL);
commit;
end;
/


