set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9312240';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-10-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '0134411',
      2.400018,
      NULL,
      4,
      2,
      NULL,
      3,
      NULL,
      NULL,
      46.339393,
      ' 1-24-1990',
      NULL,
      NULL,
      NULL,
      1,
      0.148795,
      ' 1- 6-2000',
      NULL,
      0,
      100,
      140,
      1.862725,
      '10-27-1992',
      ' 1-10-1979',
      ' 9- 0-1979',
      NULL,
      0,
      3,
      2,
      1.692881,
      NULL,
      NULL,
      1,
      1.319925,
      43.050425,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      31.572763,
      5.118562,
      1,
      2.332448,
      1,
      1.988581,
      NULL,
      0.194869,
      1,
      1,
      0,
      0.417464,
      NULL,
      1,
      9,
      3,
      5.923518,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.895979,
      NULL,
      NULL,
      0.409745,
      0,
      0.208310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.176541,
      0,
      0.389750,
      0.094804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.405920,
      1.556099,
      1,
      0.696170,
      NULL,
      2.907264,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      3,
      0.942787,
      0.138975,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      1.538450,
      NULL,
      2.376410,
      0,
      NULL,
      3,
      4,
      0.021401,
      9.163456,
      1.747921,
      2.138465,
      8.061669,
      0,
      0.925021,
      8,
      4,
      0.246139,
      NULL,
      0.532534,
      0.080412,
      1,
      NULL,
      7.145410,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.299600,
      0.207281,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      19,
      1.499103,
      1.125864,
      0.063669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.389591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      3.856517,
      3.799232,
      1.878989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.893292,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.692709,
      NULL,
      0.050997,
      1.868332,
      0,
      0.641890,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.778177,
      0.416820,
      1.702173,
      0.959809,
      1.880490,
      3,
      2,
      3.050158,
      3.986784,
      3.962667,
      0,
      NULL,
      3,
      2,
      0.242410,
      0,
      0,
      3,
      3.332420,
      NULL,
      0,
      0.873108,
      1,
      0.734561,
      0.207320,
      0.953059,
      1.488419,
      0.255001,
      4.020497,
      NULL,
      2.867680,
      3,
      6,
      NULL,
      2,
      7.645016,
      NULL,
      0,
      0.979325,
      3,
      0,
      2,
      2,
      2.123543,
      2.576116,
      NULL,
      34.720780,
      NULL,
      43,
      0,
      0.683996,
      3.890691,
      '10440',
      '',
      NULL,
      1.382536,
      '',
      '',
      NULL,
      1.708831,
      '',
      '',
      NULL,
      3.976262,
      NULL,
      1,
      27.117842,
      0,
      NULL,
      6,
      13,
      7,
      2,
      2.298807,
      NULL,
      1.338648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.805997,
      NULL,
      NULL,
      1.325130,
      NULL,
      0.270707,
      1,
      NULL,
      NULL,
      1.262839,
      NULL,
      NULL,
      1.901129,
      NULL,
      NULL,
      0.370225,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.404977,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.387394,
      1,
      1.136154,
      NULL,
      NULL,
      NULL,
      1.871051,
      NULL,
      NULL,
      3.737951,
      0.814424,
      0,
      1.214351,
      NULL,
      2,
      NULL,
      2.842815,
      NULL,
      0,
      2.514294,
      0,
      2.052910,
      1,
      NULL,
      3.091021,
      1,
      NULL,
      NULL,
      0.067404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      9,
      NULL,
      0.362739,
      0,
      NULL,
      NULL,
      NULL,
      0.662707,
      NULL,
      NULL,
      NULL,
      1.959339,
      NULL,
      NULL,
      0.002698,
      NULL,
      NULL,
      1.488294,
      NULL,
      NULL,
      1.934187,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.688923,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      10,
      0,
      3.195650,
      1.656983,
      NULL,
      2.832641,
      0.475830,
      0.288740,
      4.831520,
      2.172715,
      NULL,
      0.250956,
      NULL,
      6.959211,
      1.541460,
      NULL,
      NULL,
      NULL,
      3.955874,
      0.737847,
      1.020713,
      2.504738,
      1,
      1.276121,
      NULL,
      0.488832,
      5,
      4.700364,
      0.509349,
      NULL,
      3.207520,
      NULL,
      0.310324,
      1.205671,
      NULL,
      3,
      2,
      3,
      NULL,
      1.217558,
      NULL,
      9,
      0.914844,
      8,
      4,
      5,
      1,
      0,
      5,
      3.374853,
      0,
      1.127428,
      0,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.493700,
      NULL,
      NULL,
      1.933508,
      NULL,
      NULL,
      1.856756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.311036,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      3.045604,
      NULL,
      NULL,
      NULL,
      NULL,
      0.733488,
      NULL,
      NULL,
      5.426202,
      103.883450,
      NULL,
      NULL,
      2.170552,
      2.570490,
      NULL,
      NULL,
      2.849714,
      0,
      NULL,
      NULL,
      0.265890,
      0.297220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.153915,
      1.722010,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      2.673065,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.823008,
      1.623685,
      NULL,
      NULL,
      0,
      5,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      10.179143,
      25.706044,
      3.858699,
      2.845851,
      2.180768,
      1,
      NULL,
      NULL,
      1.881661,
      31,
      NULL,
      1.424956,
      7,
      NULL,
      0.154593,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      306.726798,
      0.829720,
      NULL,
      0.407313,
      1,
      NULL,
      0.614220,
      1,
      0,
      1.932865,
      NULL,
      NULL,
      1,
      1,
      0.204369,
      1.049226,
      1,
      0.901962,
      1.776594,
      3.203311,
      NULL,
      0.180390,
      NULL,
      0.102175,
      NULL,
      1.187399,
      NULL,
      1,
      NULL,
      1.820581,
      NULL,
      0.603926,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.919910,
      1.022179,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.302136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.622905,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.058055,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      0.780561,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.603554,
      NULL,
      0.147100,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.710280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.846014,
      2.891695,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.795648,
      NULL,
      0,
      NULL,
      0,
      0,
      0.848405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.245605,
      4.075932,
      0.027141,
      0,
      0,
      NULL,
      6.749859,
      2,
      2.439272,
      1.823776,
      0,
      0.545942,
      0.129517,
      1,
      0.505999,
      1.306039,
      NULL,
      0,
      1,
      1,
      NULL,
      1.409934,
      0.568036,
      0,
      1,
      0.204874,
      0,
      3,
      0,
      0,
      NULL,
      1.275024,
      1.576228,
      NULL,
      1,
      0.527268,
      NULL,
      1.307430,
      0.180493,
      2,
      NULL,
      1,
      NULL,
      0.205660,
      NULL,
      1.904516,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.517953,
      NULL,
      NULL,
      1.077237,
      NULL,
      1.791443,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.190490,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.648361,
      42,
      2,
      NULL,
      0,
      0,
      1.176866,
      0,
      1.743772,
      0.553469,
      0.124618,
      2,
      2,
      1.540988,
      NULL,
      NULL,
      NULL,
      NULL,
      2.384234,
      0,
      1,
      '43411',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1.462723,
      '',
      '',
      '');
commit;
end;
/


